/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.gef;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.amp.agf.gef.Shapes;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;

public abstract class GenericEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    public static final int SCALE = 20;
    protected ConnectionAnchor anchor;
    public static final Border HIGHLIGHT_RECTANGLE = new MarginBorder(2){

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle r = Rectangle.SINGLETON;
            r.setBounds(figure.getBounds());
            r.shrink(1, 1);
            graphics.setLineWidth(figure.getBounds().width / 10);
            graphics.setForegroundColor(ColorConstants.black);
            graphics.setLineStyle(1);
            graphics.drawRectangle(r);
            graphics.setLineStyle(2);
            graphics.setForegroundColor(ColorConstants.yellow);
            graphics.drawRectangle(r);
        }
    };
    public static final Border HIGHLIGHT_ELLIPSE = new MarginBorder(2){

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.setLineWidth(2);
            graphics.setLineStyle(1);
            graphics.setXORMode(false);
            Rectangle r = Rectangle.SINGLETON;
            r.setBounds(figure.getBounds());
            graphics.setForegroundColor(ColorConstants.black);
            graphics.drawOval(r);
            r.shrink(1, 1);
            graphics.setLineStyle(2);
            graphics.setForegroundColor(ColorConstants.yellow);
            graphics.drawOval(r);
        }
    };
    protected static Set<Class> noFigureWarning = new HashSet<Class>();

    public void activate() {
        if (!this.isActive()) {
            super.activate();
        }
    }

    protected IFigure buildFigure(IFigure figure) {
        return figure != null ? figure : Shapes.createRectangle();
    }

    protected IFigure createFigure() {
        Shape figure = Shapes.createRectangle();
        figure.setForegroundColor(ColorConstants.black);
        figure.setBackgroundColor(ColorConstants.gray);
        return figure;
    }

    protected void updateSelection() {
        if (this.getSelected() == 0) {
            if (this.getFigure().getBorder() != null) {
                this.getFigure().setBorder(null);
                this.getFigure().repaint();
            }
        } else {
            if (this.getFigure() instanceof Ellipse) {
                this.getFigure().setBorder(HIGHLIGHT_ELLIPSE);
            } else if (this.getFigure() instanceof RoundedRectangle) {
                this.getFigure().setBorder(HIGHLIGHT_RECTANGLE);
            } else {
                this.getFigure().setBorder(HIGHLIGHT_RECTANGLE);
            }
            this.getFigure().repaint();
        }
    }

    protected void refreshVisuals() {
        this.setFigure(this.buildFigure(this.getFigure()));
        this.updateSelection();
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
        }
    }

    private void setupShared(Shape figure) {
        figure.setFill(true);
        figure.setOutline(true);
        figure.setLineWidth(1);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new SelectionEditPolicy(){

            protected void setSelectedState(int type) {
                super.setSelectedState(type);
                GenericEditPart.this.updateSelection();
            }

            protected void hideSelection() {
            }

            protected void showSelection() {
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateSelection();
    }
}

