/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw3d.Connection3D;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.geometryext.PointList3D;
import org.eclipse.draw3d.util.Draw3DCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionLocator3D
extends ConnectionLocator {
    public ConnectionLocator3D(Connection i_connection, int i_align) {
        super(i_connection, i_align);
    }

    protected IVector3f getLocation(List<IVector3f> i_points, Vector3f io_result) {
        if (i_points == null) {
            throw new NullPointerException("i_points must not be null");
        }
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        int size = i_points.size();
        switch (this.getAlignment()) {
            case 2: {
                result.set(i_points.get(0));
                break;
            }
            case 3: {
                result.set(i_points.get(size - 1));
                break;
            }
            case 4: {
                if (size % 2 == 0) {
                    int i = size / 2;
                    IVector3f p1 = i_points.get(i - 1);
                    IVector3f p2 = i_points.get(i);
                    Math3D.sub((IVector3f)p2, (IVector3f)p1, (Vector3f)result);
                    result.scale(0.5f);
                    Math3D.add((IVector3f)p1, (IVector3f)result, (Vector3f)result);
                    break;
                }
                result.set(i_points.get((size - 1) / 2));
                break;
            }
            default: {
                throw new IllegalStateException("unknown location: " + this.getAlignment());
            }
        }
        return result;
    }

    protected ISurface getSurface() {
        IFigure3D figure3D;
        ConnectionAnchor targetAnchor;
        if (this.getConnection() instanceof Connection3D) {
            return null;
        }
        IFigure figure = null;
        ConnectionAnchor sourceAnchor = this.getConnection().getSourceAnchor();
        if (sourceAnchor != null) {
            figure = sourceAnchor.getOwner();
        }
        if (figure == null && (targetAnchor = this.getConnection().getTargetAnchor()) != null) {
            figure = targetAnchor.getOwner();
        }
        if (figure != null && (figure3D = Figure3DHelper.getAncestor3D(figure)) != null) {
            return figure3D.getSurface();
        }
        return null;
    }

    public void relocate(IFigure i_target) {
        IFigure3D target3D = (IFigure3D)i_target;
        Vector3f wLocation = Draw3DCache.getVector3f();
        Vector3f size = Draw3DCache.getVector3f();
        try {
            if (this.getConnection() instanceof Connection3D) {
                Connection3D connection3D = (Connection3D)this.getConnection();
                PointList3D points = connection3D.getPoints3D();
                this.getLocation(points, wLocation);
            } else {
                PointList points = this.getConnection().getPoints();
                Point sLocation = this.getLocation(points);
                ISurface surface = this.getSurface();
                if (surface != null) {
                    surface.getWorldLocation(sLocation, wLocation);
                }
            }
            size.set(target3D.getPreferredSize3D());
            target3D.getPosition3D().setSize3D((IVector3f)size);
            size.scale(0.5f);
            Math3D.sub((IVector3f)wLocation, (IVector3f)size, (Vector3f)wLocation);
            target3D.getPosition3D().setLocation3D((IVector3f)wLocation);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{wLocation, size});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{wLocation, size});
    }
}

