/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.gef;

import org.eclipse.amp.agf.IGraphicsAdapter;
import org.eclipse.amp.agf.gef.AgentConnectionPart;
import org.eclipse.amp.agf.gef.AgentEditPart;
import org.eclipse.amp.agf.gef.IFigureProvider;
import org.eclipse.amp.agf.gef.NetworkConnection;
import org.eclipse.amp.agf.gef.ScapeEditPart;
import org.eclipse.amp.agf.gef.ScapeGraphEditPart;
import org.eclipse.amp.axf.core.ICompositionProvider;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.space.IGraphProvider;
import org.eclipse.amp.axf.space.ILocationProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

public class ScapePartFactory
implements EditPartFactory {
    IModel model;
    ILocationProvider locationProvider;
    ICompositionProvider compositionProvider;
    IGraphProvider graphProvider;
    IGraphicsAdapter graphicsAdapter;

    public ScapePartFactory(IModel model, IGraphicsAdapter graphicsAdapter) {
        this.model = model;
        this.graphicsAdapter = graphicsAdapter;
        this.compositionProvider = (ICompositionProvider)Platform.getAdapterManager().getAdapter((Object)model, ICompositionProvider.class);
        this.locationProvider = (ILocationProvider)Platform.getAdapterManager().getAdapter((Object)model, ILocationProvider.class);
        this.graphProvider = (IGraphProvider)Platform.getAdapterManager().getAdapter((Object)model, IGraphProvider.class);
        Assert.isNotNull((Object)graphicsAdapter);
        Assert.isNotNull((Object)this.compositionProvider);
    }

    public EditPart createEditPart(EditPart context, Object model) {
        EditPart part = this.getPartForElement(model);
        part.setModel(model);
        return part;
    }

    protected EditPart getPartForElement(Object model) {
        if (this.compositionProvider.isComposition(model)) {
            IFigureProvider figure = (IFigureProvider)this.graphicsAdapter.getAdapter(this.compositionProvider.getChildrenPrototype(model), IFigureProvider.class);
            if (figure != null) {
                if (this.graphProvider.isGraph(model)) {
                    return new ScapeGraphEditPart(this.compositionProvider, this.locationProvider, this.graphProvider, null);
                }
                return new ScapeEditPart(this.compositionProvider, this.locationProvider, null);
            }
        } else if (model instanceof NetworkConnection) {
            return new AgentConnectionPart();
        }
        return new AgentEditPart(this.graphicsAdapter);
    }

    public ICompositionProvider getCompositionProvider() {
        return this.compositionProvider;
    }

    public IGraphProvider getGraphProvider() {
        return this.graphProvider;
    }

    public void setCompositionProvider(ICompositionProvider compositionProvider) {
        this.compositionProvider = compositionProvider;
    }

    public void setGraphProvider(IGraphProvider graphProvider) {
        this.graphProvider = graphProvider;
    }

    public ILocationProvider getLocationProvider() {
        return this.locationProvider;
    }

    public IGraphicsAdapter getGraphicsAdapter() {
        return this.graphicsAdapter;
    }
}

