/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.gef;

import org.eclipse.amp.agf.IGraphicsAdapter;
import org.eclipse.amp.agf.gef.AgentNodeEditPart;
import org.eclipse.amp.agf.gef.IFigureProvider;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;

public class AgentEditPart
extends AgentNodeEditPart {
    private IGraphicsAdapter graphicsAdapter;
    ILabelProvider labelProvider;
    IFigureProvider figureProvider;
    IColorProvider colorProvider;

    public AgentEditPart(IGraphicsAdapter graphicsAdapter) {
        this.graphicsAdapter = graphicsAdapter;
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.figureProvider = (IFigureProvider)this.getGraphicsAdapter().getAdapter(model, IFigureProvider.class);
        this.labelProvider = (ILabelProvider)this.getGraphicsAdapter().getAdapter(model, ILabelProvider.class);
        this.colorProvider = (IColorProvider)this.getGraphicsAdapter().getAdapter(model, IColorProvider.class);
    }

    protected void updateColor(IFigure figure) {
        figure.setForegroundColor(this.getColorProvider().getForeground(this.getModel()));
        figure.setBackgroundColor(this.getColorProvider().getBackground(this.getModel()));
    }

    @Override
    protected IFigure createFigure() {
        Object agent = this.getModel();
        this.figure = this.figureProvider.getFigure(agent);
        this.updateColor(this.figure);
        return this.figure;
    }

    @Override
    protected void refreshVisuals() {
        if (this.figureProvider.isFigureUpdateable(this.getModel())) {
            this.setFigure(this.createFigure());
        }
        if (!this.figureProvider.isHandlingColor(this.getModel()) && this.figureProvider.isColorMutable(this.getModel())) {
            this.updateColor(this.figure);
        }
        this.updateSelection();
    }

    public IColorProvider getColorProvider() {
        return this.colorProvider;
    }

    public IFigureProvider getFigureProvider() {
        return this.figureProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public IGraphicsAdapter getGraphicsAdapter() {
        return this.graphicsAdapter;
    }
}

