/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.tools;

import java.util.logging.Logger;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.MouseEvent3D;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.picking.Picker;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gef3d.ui.parts.GraphicalViewer3D;
import org.eclipse.swt.events.MouseEvent;

public abstract class AbstractTool3D
extends AbstractTool {
    private static final Logger log = Logger.getLogger(AbstractTool3D.class.getName());
    private Input3D m_current;

    public void deactivate() {
        super.deactivate();
        this.m_current = null;
    }

    protected AbstractTool.Input getCurrentInput() {
        if (this.m_current == null) {
            this.m_current = new Input3D();
        }
        return this.m_current;
    }

    protected Input3D getCurrentInput3D() {
        return (Input3D)this.getCurrentInput();
    }

    protected IScene getScene() {
        EditPartViewer viewer = this.getCurrentViewer();
        if (!(viewer instanceof GraphicalViewer3D)) {
            throw new AssertionError((Object)"camera tool can only be used with a 3D graphical viewer");
        }
        return ((GraphicalViewer3D)viewer).getLightweightSystem3D();
    }

    public class Input3D
    extends AbstractTool.Input {
        Point screenLocation = new Point();
        Point surfaceLocation = new Point();
        Vector3f wLocation = new Vector3fImpl();

        public Point getRealMouseLocation() {
            return this.screenLocation;
        }

        public IVector3f getWorldLocation() {
            return this.wLocation;
        }

        public void setInput(MouseEvent i_me) {
            super.setInput(i_me);
            if (i_me instanceof MouseEvent3D) {
                MouseEvent3D me3D = (MouseEvent3D)i_me;
                this.wLocation.set(me3D.getWorldLocation());
                this.surfaceLocation.x = me3D.x;
                this.surfaceLocation.y = me3D.y;
                this.screenLocation.x = me3D.getScreenLocation().x;
                this.screenLocation.y = me3D.getScreenLocation().y;
            } else {
                this.surfaceLocation.x = i_me.x;
                this.surfaceLocation.y = i_me.y;
                Picker picker = AbstractTool3D.this.getScene().getPicker();
                ISurface surface = picker.getCurrentSurface();
                surface.getWorldLocation(this.surfaceLocation, this.wLocation);
                ICamera camera = AbstractTool3D.this.getScene().getCamera();
                camera.project((IVector3f)this.wLocation, this.screenLocation);
            }
        }
    }
}

