/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.documentLink;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class DocumentLinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        for (LanguageServiceAccessor.LSPDocumentInfo info : LanguageServiceAccessor.getLSPDocumentInfosFor(textViewer.getDocument(), capabilities -> capabilities.getDocumentLinkProvider() != null)) {
            ArrayList<DocumentHyperlink> hyperlinks;
            block5: {
                DocumentLinkParams params = new DocumentLinkParams(new TextDocumentIdentifier(info.getFileUri().toString()));
                CompletionStage documentLink = info.getInitializedLanguageClient().thenCompose(languageServer -> languageServer.getTextDocumentService().documentLink(params));
                List links = (List)((CompletableFuture)documentLink).get(2L, TimeUnit.SECONDS);
                if (links == null || links.isEmpty()) continue;
                hyperlinks = new ArrayList<DocumentHyperlink>(links.size());
                for (DocumentLink link : links) {
                    int end;
                    int start = LSPEclipseUtils.toOffset(link.getRange().getStart(), textViewer.getDocument());
                    Region linkRegion = new Region(start, (end = LSPEclipseUtils.toOffset(link.getRange().getEnd(), textViewer.getDocument())) - start);
                    if (!TextUtilities.overlaps((IRegion)region, (IRegion)linkRegion) || link.getTarget() == null) continue;
                    hyperlinks.add(new DocumentHyperlink(link.getTarget(), (IRegion)linkRegion));
                }
                if (!hyperlinks.isEmpty()) break block5;
                return null;
            }
            try {
                return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
            }
            catch (InterruptedException | ExecutionException | TimeoutException | BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return null;
    }

    public static class DocumentHyperlink
    implements IHyperlink {
        private String uri;
        private IRegion highlightRegion;

        public DocumentHyperlink(String uri, IRegion highlightRegion) {
            this.uri = uri;
            this.highlightRegion = highlightRegion;
        }

        public IRegion getHyperlinkRegion() {
            return this.highlightRegion;
        }

        public String getTypeLabel() {
            return this.uri;
        }

        public String getHyperlinkText() {
            return this.uri;
        }

        public void open() {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            LSPEclipseUtils.open(this.uri, page, null);
        }
    }
}

