/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.mt.ast.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.compatibility.model.mt.Resource;
import org.eclipse.acceleo.compatibility.model.mt.ResourceSet;
import org.eclipse.acceleo.compatibility.model.mt.core.CoreFactory;
import org.eclipse.acceleo.compatibility.model.mt.core.Metamodel;
import org.eclipse.acceleo.compatibility.model.mt.core.Service;
import org.eclipse.acceleo.compatibility.model.mt.core.Template;
import org.eclipse.acceleo.internal.compatibility.AcceleoCompatibilityMessages;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.core.ScriptParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.core.ServiceParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.MTFileContent;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateConstants;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TextSearch;
import org.eclipse.core.resources.IFile;

public final class TemplateParser {
    private TemplateParser() {
    }

    public static void parseTemplate(IFile file, Template template, ResourceSet root, List<TemplateSyntaxException> problems) {
        String text = MTFileContent.getFileContent(file.getLocation().toFile()).toString();
        TemplateConstants.getDefault().initConstants(text);
        template.setBeginTag(TemplateConstants.getDefault().getFeatureBegin());
        template.setEndTag(TemplateConstants.getDefault().getFeatureEnd());
        if (text != null && text.length() > 0) {
            Service service = ServiceParser.createImplicitService(file, root);
            if (service != null) {
                template.getImports().add((Object)service);
            }
            TemplateParser.parseImports(text, template, root, problems);
            ScriptParser.parseScripts(0, text, template, problems);
        }
    }

    private static void parseImports(String text, Template template, ResourceSet root, List<TemplateSyntaxException> problems) {
        ArrayList<String> importValues = new ArrayList<String>();
        int end = TextSearch.indexIn(text, TemplateConstants.getDefault().getScriptBegin(), new Region(0, text.length()), null, TemplateConstants.getDefault().getInhibsScriptContent()).b();
        if (end == -1) {
            end = text.length();
        }
        int pos = 0;
        while (pos > -1 && pos < end) {
            Region bComment = TextSearch.indexIn(text, TemplateConstants.getDefault().getCommentBegin(), new Region(pos, end));
            Region bImports = TextSearch.indexIn(text, TemplateConstants.getDefault().getImportBegin(), new Region(pos, end));
            if (bComment.b() > -1 && (bImports.b() == -1 || bComment.b() <= bImports.b())) {
                Region eComment = TextSearch.blockIndexEndIn(text, TemplateConstants.getDefault().getCommentBegin(), TemplateConstants.getDefault().getCommentEnd(), new Region(bComment.b(), end), false, null, null);
                if (eComment.b() > -1) {
                    pos = eComment.e();
                    continue;
                }
                problems.add(new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingCommentEndTag"), template, bComment.b()));
                pos = end;
                continue;
            }
            if (bImports.b() > -1) {
                Region eImports = TextSearch.indexIn(text, TemplateConstants.getDefault().getImportEnd(), new Region(bImports.e(), end));
                if (eImports.b() > -1) {
                    Region[] imports = TextSearch.splitPositionsIn(text, new Region(bImports.e(), eImports.b()), new String[]{"\n"}, false, null, null);
                    int i = 0;
                    while (i < imports.length) {
                        Region importPos = imports[i];
                        if ((importPos = TextSearch.trim(text, importPos.b(), importPos.e())).b() > -1 && importPos.e() > importPos.b()) {
                            TemplateParser.parseImport(text, importPos, template, root, problems, importValues);
                        }
                        ++i;
                    }
                    pos = eImports.e();
                    continue;
                }
                problems.add(new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.InvalidImportSequence"), template, bImports.b()));
                pos = end;
                continue;
            }
            pos = end;
        }
    }

    private static void parseImport(String text, Region range, Template template, ResourceSet root, List<TemplateSyntaxException> problems, List<String> importValuesFound) {
        if (TextSearch.indexIn(text, TemplateConstants.getDefault().getImportWord(), range).b() == range.b()) {
            Region valuePos = TextSearch.trim(text, range.b() + TemplateConstants.getDefault().getImportWord().length(), range.e());
            if (valuePos.b() > -1) {
                String value = text.substring(valuePos.b(), valuePos.e()).trim();
                if (importValuesFound.contains(value)) {
                    problems.add(new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.DuplicateValue", new Object[]{"import"}), template, valuePos));
                } else {
                    importValuesFound.add(value);
                    try {
                        TemplateParser.parseImport(value, valuePos, importValuesFound.size(), template, root);
                    }
                    catch (TemplateSyntaxException e) {
                        problems.add(e);
                    }
                }
            } else {
                problems.add(new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.EmptyImport"), template, range.b() + TemplateConstants.getDefault().getImportWord().length()));
            }
        } else if (TextSearch.indexIn(text, TemplateConstants.getDefault().getModelTypeWord(), range).b() == range.b()) {
            Region valuePos = TextSearch.trim(text, range.b() + TemplateConstants.getDefault().getModelTypeWord().length(), range.e());
            if (valuePos.b() > -1) {
                String value = text.substring(valuePos.b(), valuePos.e()).trim();
                if (importValuesFound.contains(value)) {
                    problems.add(new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.DuplicateValue", new Object[]{"metamodel"}), template, valuePos));
                } else {
                    importValuesFound.add(value);
                    try {
                        TemplateParser.parseImport(value, valuePos, importValuesFound.size(), template, root);
                    }
                    catch (TemplateSyntaxException e) {
                        problems.add(e);
                    }
                }
            } else {
                problems.add(new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.EmptyValue", new Object[]{"metamodel"}), template, range.b() + TemplateConstants.getDefault().getModelTypeWord().length()));
            }
        } else {
            problems.add(new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingKeyWord", new Object[]{"import"}), template, range.b()));
        }
    }

    private static void parseImport(String value, Region valuePos, int num, Template template, ResourceSet root) throws TemplateSyntaxException {
        if (!TemplateParser.parseMetamodelImport(value, num, template, root)) {
            Template importedTemplate = null;
            Iterator resources = root.getResources().iterator();
            while (importedTemplate == null && resources.hasNext()) {
                Resource resource = (Resource)resources.next();
                if (!(resource instanceof Template) || !value.equals(((Template)resource).getName())) continue;
                importedTemplate = (Template)resource;
            }
            if (importedTemplate != null) {
                template.getImports().add(importedTemplate);
            } else {
                Service importedService = ServiceParser.createImportedService(value, root);
                if (importedService != null) {
                    template.getImports().add((Object)importedService);
                } else {
                    throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.UnresolvedImport", new Object[]{value}), template, valuePos);
                }
            }
        }
    }

    private static boolean parseMetamodelImport(String value, int num, Template template, ResourceSet root) throws TemplateSyntaxException {
        if (num == 1) {
            String uri = value.trim();
            Metamodel importedMetamodel = null;
            Iterator resources = root.getResources().iterator();
            while (importedMetamodel == null && resources.hasNext()) {
                Resource resource = (Resource)resources.next();
                if (!(resource instanceof Metamodel) || !uri.equals(((Metamodel)resource).getName())) continue;
                importedMetamodel = (Metamodel)resource;
            }
            if (importedMetamodel == null) {
                importedMetamodel = CoreFactory.eINSTANCE.createMetamodel();
                importedMetamodel.setName(uri);
                root.getResources().add((Object)importedMetamodel);
            }
            template.getImports().add((Object)importedMetamodel);
            return true;
        }
        return false;
    }
}

