/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.lookup.opt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.lookup.opt.LookupEdge;
import org.eclipse.acceleo.query.runtime.lookup.opt.LookupNode;

public class InnerLookupNode
extends LookupNode {
    private final List<LookupEdge> children = new ArrayList<LookupEdge>();
    private IService method;

    @Override
    public IService lookup(Class<?>[] argumentTypes, int step) {
        if (step == argumentTypes.length) {
            return this.method;
        }
        for (LookupEdge edge : this.children) {
            if (!edge.getLabel().isAssignableFrom(argumentTypes[step])) continue;
            return edge.getChild().lookup(argumentTypes, step + 1);
        }
        return null;
    }

    private LookupEdge createNewEdge(IService method, int step) {
        InnerLookupNode newNode = new InnerLookupNode();
        newNode.addMethod(method, step + 1);
        return new LookupEdge(method.getServiceMethod().getParameterTypes()[step], newNode);
    }

    @Override
    void addMethod(IService method, int step) {
        Class<?>[] parameterTypes = method.getServiceMethod().getParameterTypes();
        if (step == parameterTypes.length) {
            this.method = method;
        } else {
            int i = 0;
            int size = this.children.size();
            Class<?> stepParameterType = parameterTypes[step];
            while (i < size && !this.children.get(i).getLabel().isAssignableFrom(stepParameterType)) {
                ++i;
            }
            if (i == size) {
                this.children.add(this.createNewEdge(method, step));
            } else if (this.children.get(i).getLabel() == stepParameterType) {
                this.children.get(i).getChild().addMethod(method, step + 1);
            } else {
                this.children.add(i, this.createNewEdge(method, step));
            }
        }
    }
}

