/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.completion;

import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClassifier;

public class VariableDeclarationCompletionProposal
implements ICompletionProposal {
    private final IType type;

    public VariableDeclarationCompletionProposal(IType type) {
        this.type = type;
    }

    @Override
    public String getProposal() {
        String result;
        IType rawType = this.type;
        while (rawType instanceof ICollectionType) {
            rawType = ((ICollectionType)rawType).getCollectionType();
        }
        EClassifier eClassifier = ((EClassifierType)rawType).getType();
        if (rawType != this.type) {
            result = String.valueOf(this.toLowerFirst(eClassifier.getName())) + "s : " + eClassifier.getEPackage().getNsPrefix() + "::" + eClassifier.getName() + " | ";
        } else {
            String prefix = eClassifier.getName().startsWith("A") || eClassifier.getName().startsWith("O") || eClassifier.getName().startsWith("E") || eClassifier.getName().startsWith("I") || eClassifier.getName().startsWith("U") ? "an" : "a";
            result = String.valueOf(prefix) + eClassifier.getName() + " : " + eClassifier.getEPackage().getNsPrefix() + "::" + eClassifier.getName() + " | ";
        }
        return result;
    }

    @Override
    public int getCursorOffset() {
        return this.getProposal().length();
    }

    @Override
    public IType getObject() {
        return this.type;
    }

    public String toString() {
        return this.getProposal();
    }

    public String toLowerFirst(String self) {
        String resultString = self.length() == 0 ? self : (self.length() == 1 ? self.toLowerCase() : String.valueOf(Character.toLowerCase(self.charAt(0))) + self.substring(1));
        return resultString;
    }
}

