/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug;

import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;

public class DeploymentStreamMonitor
implements IFlushableStreamMonitor {
    private final Set<IStreamListener> listeners = ConcurrentHashMap.newKeySet();
    private final Queue<String> messageBuffer = new ConcurrentLinkedQueue<String>();
    private boolean buffered = true;

    public String getContents() {
        return this.messageBuffer.stream().collect(Collectors.joining("\n"));
    }

    public void flushContents() {
        this.messageBuffer.clear();
    }

    public void setBuffered(boolean buffer) {
        this.buffered = buffer;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void addListener(IStreamListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IStreamListener listener) {
        this.listeners.remove(listener);
    }

    protected void message(String message) {
        if (this.buffered) {
            this.messageBuffer.add(message);
        }
        this.listeners.forEach(l -> l.streamAppended(message, (IStreamMonitor)this));
    }
}

