/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.value;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.debug.IEvaluatorDebugTarget;
import org.eclipse.fordiac.ide.debug.value.EvaluatorDebugStructuredValue;
import org.eclipse.fordiac.ide.model.eval.value.StructValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;

public final class EvaluatorDebugStructValue
extends EvaluatorDebugStructuredValue {
    private final Map<String, EvaluatorDebugVariable> members;

    public EvaluatorDebugStructValue(StructValue value, String expression, IEvaluatorDebugTarget target) {
        super((Value)value, target);
        this.members = value.getMembers().values().stream().map(member -> target.createVariable((Variable<?>)member, EvaluatorDebugStructValue.createSubExpression(expression, member.getName()))).collect(Collectors.toUnmodifiableMap(EvaluatorDebugVariable::getName, Function.identity()));
    }

    public EvaluatorDebugStructValue(StructValue value, EvaluatorDebugVariable variable) {
        super((Value)value, variable);
        this.members = value.getMembers().values().stream().map(member -> variable.createSubVariable((Variable<?>)member, EvaluatorDebugStructValue.createSubExpression(variable.getExpression(), member.getName()))).collect(Collectors.toUnmodifiableMap(EvaluatorDebugVariable::getName, Function.identity()));
    }

    public StructValue getInternalValue() {
        return (StructValue)super.getInternalValue();
    }

    @Override
    public EvaluatorDebugVariable getVariable(String name) {
        return this.members.get(name);
    }

    @Override
    public IVariable[] getVariables() {
        return (IVariable[])this.members.values().stream().sorted().toArray(IVariable[]::new);
    }

    @Override
    public boolean hasVariables() {
        return true;
    }
}

