# Druck-Men
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen
# Copyright (C) 1996  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc ClickDvi2Printer {modifier} {TestPut 4 "$modifier"
 global vv sub anl0 Wq main_file tsuff asuff
 lock; set sub 1
 writescr0 .d.tt "[datime] $vv(xtc1as) $main_file\n"
 set austext ""
 switch -- [mdtest [fileName $main_file] $tsuff $asuff austext] {
  -1 {TestPut 4 "$main_file or dvi-file doesn't exist";writescr .d.tt "$austext"; unlock_list}
   0 {TestPut 4 "dvi-file and tex-file exist, but dvi-file is older"
	if [winfo exists $Wq] {destror $Wq}; toplevel $Wq; set anl0 0
	set frage "$vv(aus5) $main_file$tsuff $vv(ut13) $main_file$asuff $vv(ut14)"
	proc ReqDviYes {} "destror $Wq; dvi2printer \"$modifier\""
	proc ReqDviNo  {} "destror $Wq; unlock_list"
	Request $Wq "$frage" "" "$vv(xtrotz)" ReqDviYes "$vv(dmaa)" ReqDviNo dm_agedvitex "" n
     }
   1 {TestPut 4 "OK: .dvi newer/no .tex"; writescr .d.tt "$austext"; dvi2printer $modifier}
 }
 Focus .
}

proc dvi2printerDirect {} {
 global vv prtfilperm prt_file main_file prtsuf
 set prtfpold $prtfilperm; set prtfilperm $vv(dm20)
 if {$prtsuf==".ps"} {set prt_file [fileName $main_file.print.ps]} \
 else {set prt_file [fileName $main_file$prtsuf]}
 dmWdmae 0
 set prtfilperm $prtfpold
}

proc dmWdmae {request} {# destroys print menu; calls printer driver, then evtl. print request
 global vv Wdm Wq austext sub prtdriver prt_file prtfilperm lpcmd lpopt olsep printer
 global mkcommand dm_f

 if [winfo exist $Wdm] {dmfocus ""; if {$dm_f>0} return; destros $Wdm}
 set sub 1
 set ret [prt_$prtdriver .d.tt austext]; writescr .d.tt "$austext"
 if {(($ret=="")||($ret=="0"))&&[file exists $prt_file]} {
   if {$request==1} {
     if {[winfo exists $Wq]==1} {destror $Wq}; toplevel $Wq
     set frage "[eval list $vv(drafrage)]"
     Request $Wq "$frage " "" "$vv(yes)" dmReqPrintYes $vv(no) dmReqPrintNo dm_ausdrucken "" y
   } else {
     printing .d.tt austext; writescr .d.tt "$austext"
     if {$prtfilperm=="$vv(dm20)"} {unlink -nocomplain $prt_file}
     unlock_list; Focus .
   }
 } elseif {$mkcommand=="mkcommand.0"} {
   mkCmd_wait .d.tt $lpcmd [eval list [lindex [split $lpopt $olsep] 1] \
	[lindex [split $lpopt $olsep] 2] $prt_file]
   unlock_list; Focus .
 } else {# prt_....tcl aborted or no output file produced by prt_....tcl
   if ![file exists $prt_file] {writescr .d.tt "\n*** $vv(drakd)\n";mybell 3}
   if {$prtfilperm=="$vv(dm20)"} {unlink -nocomplain $prt_file}
   unlock_list; Focus .
 }
}

proc dmWdmaa {} {global Wdm; dmfocus {}; destros $Wdm; unlock_list; Focus .}

##############################################################################################

proc dvi2printer {modifier} {TestPut 4 "$modifier";# call printer driver and foreward output

proc dmReqPrintNo {} {# output is not to be printed
 global Wq vv prtfilperm prt_file
 destror $Wq
 if {$prtfilperm=="$vv(dm20)"} {unlink -nocomplain $prt_file}
 unlock_list; Focus .
}

proc dmReqPrintYes {} {# output is to be printed
 global Wq vv prtfilperm prt_file
 destror $Wq
 printing .d.tt austext; writescr .d.tt "$austext"
 if {$prtfilperm=="$vv(dm20)"} {unlink -nocomplain $prt_file}
 unlock_list; Focus .
}

global vv Wdm prtdriver xtem_path mkcommand pg_start pg_end printcops prmtext pg_start pg_end

lpcmdTest
if {$prmtext==""} {vstr_driver; set pg_start "$vv(dmstart)"; set pg_end "$vv(dmend)"}
if {$prtdriver==""} {
  puts stdout {Error! printer driver name is empty; see Installation Guide ("printing.vst")}
  mybell 4
} else {
  if {[info commands prt_$prtdriver]!="prt_$prtdriver"} {
    if [file exists $xtem_path/prt_${prtdriver}.tcl] {
      source $xtem_path/prt_${prtdriver}.tcl
      if {[info commands prt_$prtdriver]!="prt_$prtdriver"} {
	puts stdout "Error! File \"$xtem_path/prt_${prtdriver}.tcl\" doesn't contain "
	puts stdout "(called) procedure \"prt_$prtdriver\"; see Installation Guide"
	mybell 4; return
      }
    } else {
      puts stdout "Error! Missing file \"$xtem_path/prt_${prtdriver}.tcl\""
      puts stdout "       for called printer driver  \"$prtdriver\"; see Installation Guide"
      mybell 4; return
    }
  }
  if [winfo exists $Wdm] {destros $Wdm}
  set printcops 1
  set pg_start "$vv(dmstart)"; set pg_end "$vv(dmend)"
  if {$modifier=="Shift"} {dvi2printerDirect} else {printmenu}
}

}

##############################################################################################

proc printmenu {} {

proc dmdsel {s} {# print macro selected
 global Wdm vv dmsep prmtext prmrelabs prmsel pg_start pg_end dmdsel_v prtreversed
 global prtcmd prtcmdmax dmP StrtPg EndePg
 dmfocus ""
 writescr0 $Wdm.d.tt ""
 set old $prmrelabs
 set prmtext [getvalue $s 0 $dmsep]; set prmrelabs [getvalue $s 1 $dmsep]
 set prmsel [getvalue $s 2 $dmsep]; set prtreversed [getvalue $s 3 $dmsep]
 for {set c 1} {$c<=$prtcmdmax} {incr c} {set prtcmd($c) [getvalue $s [expr $c+3] $dmsep]}
 if {$prmrelabs==""} {
   set pg_start "$vv(dmstart)"; set pg_end "$vv(dmend)"
   foreach w "s e" {$Wdm.c.2.$w delete 0 end}
 } else {
   dmSetMm
   if {($dmP(OK)==1)&&($prmrelabs!="$old")} {
     dmInsLOP short
     if {($StrtPg!="")&&($dmP(a=r)==0)} {set StrtPg ""; set pg_start "$vv(dmstart)"}
     if {($EndePg!="")&&($dmP(a=r)==0)} {set EndePg ""; set pg_end "$vv(dmend)"}
   }
   if {$StrtPg!=""} {dmChkPag StrtPg 1; set pg_start $StrtPg}
   if {$EndePg!=""} {dmChkPag EndePg 1; set pg_end $EndePg}
 }
 if     {$prmrelabs=="r"}	{set prmrelabst "$vv(dm11)"} \
 elseif {$prmrelabs=="a"}	{set prmrelabst "$vv(dm12)"} \
 else				{set prmrelabst "$vv(dm13)"}
 $Wdm.c.1.d2 configure -text "$vv(dmc1d2) $prmrelabst "
 $Wdm.c.1.d3 configure -text "$vv(dmc1d3) $prmrelabst " 
 dmprtrev nontoggle
 updateWdmb1;  writescr $Wdm.d.tt "$vv(dm14)\n$prmtext\n"
 set dmdsel_v "$s"
}

proc dmfocus {w} {
 global Wdm dm_f
 if {$dm_f==1} dmesp elseif {$dm_f==2} dmeep elseif {$dm_f==3} dmefn elseif {$dm_f==4} dmecn
 if {$w!=""} {focus $w} else {focus $Wdm.a.e}
}

proc dmesp {} {# start page selected
 global Wdm vv prmrelabs StrtPg pg_start dm_f dmP dmLOP prtnumpag dmI
 set err 0; set t ""; writescr0 $Wdm.d.tt "$t"; dmLookLOP; if [info exist dmI] {unset dmI}
 if {$prtnumpag==1} {set StrtPg [Num $StrtPg]}
 if {$prmrelabs==""} {set err 1; mybell 2; set StrtPg ""; set t "${t}$vv(dm16)\n"} \
 elseif {$StrtPg==""} {set pg_start $vv(dmstart); set t "${t}$vv(dm15) $pg_start\n"} \
 else {dmChkPag StrtPg 1; set pg_start $StrtPg; set t "${t}$vv(dm15) $StrtPg\n"}
 if {($prmrelabs=="a")&&($StrtPg!="")&&([dmRepPg $StrtPg]!="")} \
	{set t "\n${t}$vv(dm44) $StrtPg $vv(dm45)\n$vv(dm46) [dmRepPg $StrtPg]\n"; mybell 2}
 updateWdmb1; writescr $Wdm.d.tt "$t"; if {$err==0} {set dm_f 0}
}

proc dmeep {} {# end page selected
 global Wdm vv prmrelabs EndePg prmtext pg_end dm_f dmP dmLOP prtnumpag dmI
set err 0; set t ""; writescr0 $Wdm.d.tt "$t"; dmLookLOP; if [info exist dmI] {unset dmI}
 if {$prtnumpag==1} {set EndePg [Num $EndePg]}
 if {$prmrelabs==""} {set err 1; mybell 2; set EndePg ""; set t "${t}$vv(dm16)\n"} \
 elseif {$EndePg==""} {set pg_end $vv(dmend); set t "${t}$vv(dm17) $pg_end\n"} \
 else {dmChkPag EndePg 1; set pg_end $EndePg; set t "${t}$vv(dm17) $EndePg\n"}
 if {($prmrelabs=="a")&&($EndePg!="")&&([dmRepPg $EndePg]!="")} \
	{set t "\n${t}$vv(dm44) $EndePg $vv(dm45)\n$vv(dm46) [dmRepPg $EndePg]\n"; mybell 2}
 updateWdmb1; writescr $Wdm.d.tt "$t"; if {$err==0} {set dm_f 0}
}


proc dmRepPg {pg} {# looks for multiple occurences of an absolute page number in dmLOP
 global dmLOP
 set i [expr [lsearch $dmLOP $pg]+1]; set lp "$i"; set b $i
 while {[lsearch [lrange $dmLOP $b end] $pg]>=0} \
	{set i [expr [lsearch [lrange $dmLOP $b end] $pg]+1]; incr b $i; set lp "${lp}, $b"}
 if {[llength $lp]>1} {return "$lp"} else {return ""}
}

proc dmChkPag {pagvar mes} {# checks EndePg/StrtPg (if pages_show was running OK only!)
 global vv Wdm StrtPg EndePg dmP dmLOP prmrelabs
 upvar 1 $pagvar pv
 if {$dmP(OK)!=1} {return}
 #TestPut 3 "<$prmrelabs><$pagvar><$pv> <$dmP(rmin)><$dmP(rmax)> <$StrtPg><$EndePg>"
 set warn 0
 if {($prmrelabs=="r")&&($pv<$dmP(rmin))} {set pv $dmP(rmin); set warn 2; set t "$vv(dm42)!"}
 if {($prmrelabs=="r")&&($pv>$dmP(rmax))} {set pv $dmP(rmax); set warn 2; set t "$vv(dm42)!"}
 if {($prmrelabs=="a")&&($pv<$dmP(amin))} {set pv $dmP(amin); set warn 2; set t "$vv(dm42)!"}
 if {($prmrelabs=="a")&&($pv>$dmP(amax))} {set pv $dmP(amax); set warn 2; set t "$vv(dm42)!"}
 if {($prmrelabs=="a")&&([string first " $pv " "$dmLOP"]<0)} {
   set t "$vv(dm42), $vv(dm43)!"; set warn 2
   while {$pv>$dmP(amin)} { incr pv -1; if {[string first " $pv " "$dmLOP"]>=0} {break} }
 }
 if {($warn!=0)&&($mes!=0)} {dmInsLOP long; writescr $Wdm.d.tt "$t\n"; mybell 2}
 #TestPut 3 "<$prmrelabs><$pagvar><[set pagvar]> <$dmP(rmin)><$dmP(rmax)> <$StrtPg><$EndePg>"
}

proc dmefn {} {# enter file name
 global Wdm vv prt_file prtfilperm dm_f
 if {$prt_file == ""} {dmSetprt_file;	 writescr0 $Wdm.d.tt "$vv(dm23) $prt_file\n"} \
 else					{writescr0 $Wdm.d.tt "$vv(dm24) $prt_file\n"}
 updateWdmb1a
 set dm_f 0
}

proc dmSetprt_file {} {
 global prt_file prtsuf main_file
 if {$prtsuf==".ps"} {set prt_file [fileName $main_file.print.ps]} \
 else {set prt_file [fileName $main_file$prtsuf]}
}

proc dmecn {} {# enter number of print copies
 global Wdm vv printcops maxprintcops dm_f
 set err 0; set t ""
 #if {$printcops!=[Num $printcops]} \
 #	{set err 1; mybell 3; set printcops [Num $printcops]; set t "$vv(num)\n"}
 if {$printcops>$maxprintcops} {
   set err 1; mybell 2; set printcops $maxprintcops; set t "${t}$vv(dm26) $printcops"
 } else {
   if {($printcops=="")||($printcops<="0")} {set err 1; set printcops 1; mybell 2}
   set t "${t}$vv(dm25) $printcops"
 }
 selection clear $Wdm.c.2.pc.cn
 writescr0 $Wdm.d.tt "$t\n"; if {$err==0} {set dm_f 0}
}

proc updateWdmb1 {} {
 global Wdm vv prmtext pg_start pg_end
 $Wdm.b.1 configure -text "$prmtext  $vv(dm10) $pg_start - $pg_end)"
}

proc dmprtrev {toggle} {# variable prtreversed undocumented up to now, for future use
 # prtreversed: 3rd parameter in prt_*.vst; vlaues: "" (=unused), 1, 2, -1, -2
 global Wdm vv prtreversed
 if {$prtreversed==""} {pack forget $Wdm.c.1.d4.t $Wdm.c.2.rv.t; return}
 if {$toggle=="toggle"} {if {$prtreversed==1} {set prtreversed 2} {set prtreversed 1}}
 if {($prtreversed==1)||($prtreversed==-1)} {set t $vv(dm4)} else {set t $vv(dm5)}
 pack configure $Wdm.c.1.d4.t $Wdm.c.2.rv.t
 if {$prtreversed<0} {$Wdm.c.2.rv.t configure -state disabled; update idletasks} \
 else {$Wdm.c.2.rv.t configure -state normal; update idletasks}
 $Wdm.c.2.rv.t configure -text "$t"; update
}

proc dmfilperm {focus} {
 global vv Wdm prtfilperm prt_file
 if {$focus=="dmfocus"} {dmfocus ""}
 if {$prtfilperm==$vv(dm20)} {set t $vv(dm19)} else {set t $vv(dm20)}
 set prtfilperm $t; $Wdm.c.2.pc.np configure -text $t
 writescr0 $Wdm.d.tt ""
 updateWdmb1a
}

proc updateWdmb1a {} {
 global vv Wdm prtfilperm prt_file
 $Wdm.b.1a configure -text "$vv(dm21) ${prtfilperm}$vv(dm22) $vv(dm18) $prt_file"
}

proc dmInsLOP {type} {# displays "list of pages ($dmLOP)"
 global Wdm vv dmLOP dmP prmrelabs dm_f
 TestPut 3 "<$type><$dm_f> <$dmP(OK)><$dmLOP>"
 if {$dmP(OK)!=1} {
   if {($dmP(OK)==-2)||($dmP(OK)==-3)} {writescr $Wdm.d.tt "$dmLOP\n\n"; mybell 2}
   return
 }
 if {($type!="med")&&($dmP(a=r)==0)&&($dmP(rmax)>1)} {
   if {$dmP(rmax)<20} {set ta "  "; set te ""} else {set ta "\n"; set te "\n"}
   writescr $Wdm.d.tt "\n$vv(dm29):$ta$dmLOP\n$te"
 } elseif {($type=="long")&&($dmP(a=r)==0)} {
   for {set p 1; set lp ""} {$p<=[llength $dmLOP]} {incr p 1} \
	{set lp "$lp $p:\[[lindex $dmLOP [expr $p-1]]\]"}
   writescr $Wdm.d.tt "\n$lp\n\n"
 }
 if {$dmP(rmax)==1} {
   set t "$vv(dm34);  $vv(dm35) ="
   if {$dmP(a=r)==0} {set t "${t} $dmP(rmin),"}
   set t "${t} $vv(dm36) = $dmP(amin)\n"
 } else {
   set t "$vv(dm28):  $dmP(rmin) - $dmP(rmax)\n"
   if {$dmP(a=r)==1} {set t "${t}$vv(dm30)\n"} \
   else {set t "${t}$vv(dm31): $dmP(amin)\n$vv(dm32): $dmP(amax)\n"}
 }
 writescr $Wdm.d.tt "$t\n"
 if {($prmrelabs=="a")&&($dmP(asm)==0)} \
	{writescr $Wdm.d.tt "$vv(dm39)\n$vv(dm40)\n$vv(dm41)\n"; mybell 2}
}

proc dmLookLOP {} {# looks for "list of pages ($dmLOP)"
 global Wdm vv dmLOP main_file xtem_path dmP
 if {$dmP(OK)==1} {return}
 set pagelistprog $xtem_path/pages_show
 TestPut 4 "<[file exists $pagelistprog]><$pagelistprog>"
 if {($dmP(OK)==0)&&[file exists $pagelistprog]&&[file executable $pagelistprog]} {
   writescr $Wdm.d.tt "$vv(dm27)\n"
   SigChldB; set res [catch "exec $pagelistprog $main_file" mes]; SigChldU; lock
   if {($res==0)&&([string trim $mes]!="")} {
     set dmP(OK) 1; set dmLOP " $mes "
		 #  set dmLOP " [list 1 2 1 2 3 4 5 5] ";# for tests only!
     set dmP(rmax) [llength $dmLOP]
     if {$dmP(rmax)==0} {set dmP(rmin) 0} else {set dmP(rmin) 1}
     set dmP(afirst) [lindex $dmLOP 0]
     set dmP(alast) [lindex $dmLOP [expr [llength $dmLOP]-1]]
     set dmP(amin) 999999; set dmP(amax) 0
     set dmP(a=r) 1; set dmP(asm) 1; set o [expr $dmP(afirst)-1]
     for {set p 1} {$p<=$dmP(rmax)} {incr p} {
	set pp [lindex $dmLOP [expr $p-1]]
	if {$dmP(amin)>$pp} {set dmP(amin) $pp}
	if {$dmP(amax)<$pp} {set dmP(amax) $pp}
	if {$p!=$pp} {set dmP(a=r) 0}; if {$o>=$pp} {set dmP(asm) 0}; set o $pp
     }
     if {($dmP(asm)==1)&&([expr $dmP(amax)-$dmP(amin)+1]==$dmP(rmax))} {set dmP(ang) 1} \
     else {set dmP(ang) 0}
     TestPut 4 "<$dmP(a=r)><$dmP(asm)><$dmP(ang)> "\
		" <$dmP(rmin)-$dmP(rmax)><$dmP(amin)-$dmP(amax)> <$dmP(afirst)><$dmP(alast)>"
   } \
   elseif {($res==0)&&([string trim $mes]=="")} {set dmP(OK) -2; set dmLOP "$vv(dm37)"} \
   else {set dmP(OK) -3; set dmLOP "$vv(dm38)"}; # $res!=0
   dmInsLOP short
 } else {set dmP(OK) -1; set dmLOP ""}
 TestPut 3 "<$dmP(OK)> <$dmLOP>"
}

proc dmSetMm {} {# sets dmP(m)=min.-page and dmP(M)=max.-page for page-sel. Key-Up/Down-binds
 global dmP prmrelabs
 if {$dmP(OK)==1} {# pages_show run OK
   if	  {$prmrelabs=="r"}	{set dmP(m) $dmP(rmin); set dmP(M) $dmP(rmax)} \
   elseif {$prmrelabs=="a"}	{set dmP(m) $dmP(amin); set dmP(M) $dmP(amax)}
   TestPut 3 "<$prmrelabs,$dmP(rmin)-$dmP(rmax),$dmP(amin)-$dmP(amax)>"
 }
}

proc IncPag {variable inc} {# increments variale (StrtPg/EndePg) by inc within limits
 global dmP dmLOP pgMaxim prmrelabs dmI
 upvar 1 $variable pgv
 set pgv [Num $pgv]
 if {$dmP(OK)==1} {# pages_show run OK
   if {$pgv==""} {
     set pgv $dmP(m)
   } elseif {$prmrelabs=="a"} {
     dmChkPag pgv 0
     if ![info exist dmI] {set dmI [lsearch $dmLOP "$pgv"]}
     incr dmI $inc
     if {$dmI<0} {set dmI 0} elseif {$dmI>=$dmP(rmax)} {set dmI [expr $dmP(rmax)-1]}
     set pgv [lindex $dmLOP $dmI]
   } elseif {$prmrelabs=="r"} {
     incr pgv $inc; if {$pgv<$dmP(m)} {set pgv $dmP(m)}; if {$pgv>$dmP(M)} {set pgv $dmP(M)}
   } else {incr pgv $inc}
 } else {# no pageslist from pages_show run
   if {$pgv==""} {set pgv 1} \
   else {incr pgv $inc; if {$pgv<1} {set pgv 1}; if {$pgv>$pgMaxim} {set pgv $pgMaxim}}
 }
}


global vv Wdm printcops StrtPg EndePg dm_f button2end
global printer prtdriver prtoptions lpcmd prtfilperm prtselstr
global pg_start pg_end prmtext prmsel prmrelabs dmsep prt_file dmLOP dmP pgMaxim

toplevel_init $Wdm "$vv(dmvor)" 0 0; set tyh 19; dmSetprt_file

# Bereich a fuer erste Buttons

frame $Wdm.a -relief raised -borderwidth 1; pack configure $Wdm.a -pady 10 -anchor w
 
button $Wdm.a.e -text "O.K." -command "dmWdmae 1"
if {$button2end==2} {
  Bind2P $Wdm.a.e 1 dmWdmae 0;# OK, print without Request-call
  Bind3HTF $Wdm.a.e "$vv(btclk2):\n  $vv(btclk4)\n" dm_OK $Wdm.d.tt
} else {
  Bind3HF $Wdm.a.e dm_OK $Wdm.d.tt
}
button $Wdm.a.a -text "$vv(dmaa)" -command dmWdmaa
Bind3HF $Wdm.a.a dm_abbruch $Wdm.d.tt
button $Wdm.a.h -text "$vv(ah)" -command {HTxtFile "" dm_h $Wdm.d.tt}
Bind2HF $Wdm.a.h dm_h $Wdm.d.tt
Bind3HF $Wdm.a.h dm_h $Wdm.d.tt
button $Wdm.a.l -text "$vv(al)" -command {writescr0 $Wdm.d.tt ""}
Bind3HF $Wdm.a.l z_loeschetf $Wdm.d.tt
pack configure $Wdm.a.e $Wdm.a.a $Wdm.a.h $Wdm.a.l -side left -padx 3 -pady 3
bind $Wdm.a.e <Tab> {focus $Wdm.a.a; Bend}
bind $Wdm.a.e <Shift-Tab> {set dm_f 4; focus $Wdm.c.2.pc.cn; Bend}
bind $Wdm.a.e <Return> {dmWdmae 1; Bend}
bind $Wdm.a.a <Tab> {if [winfo exists $Wdm.b.f.f.li] {focus $Wdm.b.f.f.li; Bend}}
bind $Wdm.a.a <Return> {dmWdmaa; Bend}
bind $Wdm.a.a <Shift-Tab> {focus $Wdm.a.e; Bend}


# Bereich bv fuer eigene Einstellungen

frame $Wdm.bv; pack configure $Wdm.bv -pady 13 -anchor w
label $Wdm.bv.dv -text "$vv(bvdv)" -width 23 -anchor w
Bind3HF $Wdm.bv.dv z_voreinst1 $Wdm.d.tt
button $Wdm.bv.va -text "$vv(bvva)" -command {
  dmfocus ""
  if {$dirprefix==""} {set mainfile $main_file} else {set mainfile [fileName $main_file]}
  set opt1 "[lindex [split $prtoptions $opsep] 1]";# set driver options (except format)
  if {$printcops!="1"} {set opt1 "$opt1 -C $printcops"};# add number of copies to options
  set opt2 "[lindex [split $prtoptions $opsep] 2]";# set format dependent driver options
  if {$StrtPg==""} {set sv 1} {set sv $StrtPg}
  if {$EndePg==""} {set ev $pgMaxim} {set ev $EndePg}
  for {set c 1; set tc ""} {($c<=$prtcmdmax)&&($prtcmd($c)!="")} {incr c} {
    set te [prtRegsub "$prtcmd($c)" $mainfile "$opt1" "$opt2" "$sv" "$ev"]
    if {"$te"=="$prtcmd($c)"} {set tc "$tc\n prtcmd($c) \t:  $prtcmd($c)"} \
    else		      {set tc "$tc\n prtcmd($c) \t:  $prtcmd($c)\n\t\t   $te"}
  }
  writescr0 $Wdm.d.tt "$vv(aus0)\n\n $vv(dm2)  $vv(dmvon) $pg_start $vv(dmbis) $pg_end\n" \
	" $vv(dm3)  $prmtext ($prmsel)\n\n $vv(dv2)  $printer\n" \
	" $vv(dv4)  $prtdriver\n $vv(dv6)  $prtformat\n" \
	" $vv(dv7)  $prtoptions\n $vv(dv3)  $lpcmd\n $vv(dv8)  $lpopt\n" \
	" $tc"
}
Bind3HF $Wdm.bv.va z_voreinst1 $Wdm.d.tt
pack configure $Wdm.bv.dv $Wdm.bv.va -side left


# Bereich b fuer Anzeigen und Drucker-Auswahl

frame $Wdm.b; pack configure $Wdm.b -anchor w -fill x

label $Wdm.b.1 -width 96 -anchor w -text "$prmtext  $vv(dm10) $pg_start - $pg_end)"
Bind3HF $Wdm.b.1 dm_anzeig $Wdm.d.tt
label $Wdm.b.1a -width 96 -anchor w; updateWdmb1a
Bind3HF $Wdm.b.1a dm_anzeig $Wdm.d.tt
if {$printer==""} {set t "$vv(dvbad1)"} else {set t "$vv(dvbad2) $prtselstr"}
label $Wdm.b.1b -width 96 -anchor w -text "$t"
Bind3HF $Wdm.b.1b dm_anzeig $Wdm.d.tt
pack configure $Wdm.b.1 $Wdm.b.1a $Wdm.b.1b
set dmsep [getsep prt_${prtdriver}.vst]
set r [CreateLSBox $Wdm.b $vv(dmb2) top 85 8 2 dm_seitena $Wdm.d.tt \
    $dmsep [vst2list prt_${prtdriver}.vst 1 $dmsep "$prmtext" dmdsel_v] dmdsel "" "dmWdmae 1"]
if [winfo exists $Wdm.b.f.f.li] {
  bind $Wdm.b.f.f.li <Tab> {set dm_f 1; focus $Wdm.c.2.s; dmInsLOP short; Bend}
  bind $Wdm.b.f.f.li <Shift-Tab> {focus $Wdm.a.a; Bend}
} elseif [winfo exists $Wdm.b.f.f.$r] {
  bind $Wdm.b.f.f.$r <Tab> {set dm_f 1; focus $Wdm.c.2.s; dmInsLOP short; Bend}
  bind $Wdm.b.f.f.$r <Shift-Tab> { }
}
if	{$prmrelabs=="r"} {set prmrelabst "$vv(dm11)"} \
elseif	{$prmrelabs=="a"} {set prmrelabst "$vv(dm12)"} \
else	{set prmrelabst "$vv(dm13)"}


# Bereich c fuer Seitenbereich, permanente Datei, Kopienanzahl

frame $Wdm.c; pack configure $Wdm.c -anchor w
frame $Wdm.c.1; frame $Wdm.c.2; pack configure $Wdm.c.1 $Wdm.c.2 -side left -fill x -ipadx 5

# Bereich c1 fuer Label
label $Wdm.c.1.d2 -text "$vv(dmc1d2) $prmrelabst "
label $Wdm.c.1.d3 -text "$vv(dmc1d3) $prmrelabst "
frame $Wdm.c.1.d4; label $Wdm.c.1.d4.t -text "$vv(dmc1d4): "
label $Wdm.c.1.d5 -text "$vv(dm18): "
Bind3HF $Wdm.c.1.d2 dm_seitens $Wdm.d.tt
Bind3HF $Wdm.c.1.d3 dm_seitene $Wdm.d.tt
Bind3HF $Wdm.c.1.d4.t dm_prtrev $Wdm.d.tt
Bind3HF $Wdm.c.1.d5 dm_perm $Wdm.d.tt
pack configure $Wdm.c.1.d2 $Wdm.c.1.d3 $Wdm.c.1.d4 $Wdm.c.1.d5 -anchor e -ipady 1
# $Wdm.c.1.d4.t will be packed in procedure dmprtrev

# Start- und Ende-Seite

entry $Wdm.c.2.s -textvariable StrtPg -width 20 -relief sunken
entry $Wdm.c.2.e -textvariable EndePg -width 20 -relief sunken
frame $Wdm.c.2.rv; frame $Wdm.c.2.pc 
pack configure $Wdm.c.2.s $Wdm.c.2.e $Wdm.c.2.rv $Wdm.c.2.pc -anchor w

if {$pg_start!="$vv(dmstart)"} {set StrtPg "$pg_start"} else {set StrtPg ""}
if {$pg_end!="$vv(dmend)"} {set EndePg "$pg_end"} else {set EndePg ""}


bind $Wdm.c.2.s <Button-1> {dmfocus $Wdm.c.2.s; if {$dm_f!=-1} {dmInsLOP short}; set dm_f 1}
bind $Wdm.c.2.s <Button-2> {Bend}
Bind3HF $Wdm.c.2.s dm_seitens $Wdm.d.tt
bind $Wdm.c.2.s <Return>	{dmesp; dmfocus ""; Bend}
bind $Wdm.c.2.s <Tab>		{dmesp; focus $Wdm.c.2.e; set dm_f 2; dmInsLOP short; Bend}
bind $Wdm.c.2.s <Shift-Tab>	{dmesp}
bind $Wdm.c.2.s <Key-Down>	 {IncPag StrtPg  -1}
bind $Wdm.c.2.s <Shift-Key-Down> {IncPag StrtPg  -10}
bind $Wdm.c.2.s <Control-Down> 	 {IncPag StrtPg -100}
bind $Wdm.c.2.s <Key-Up>	 {IncPag StrtPg    1}
bind $Wdm.c.2.s <Shift-Key-Up>	 {IncPag StrtPg   10}
bind $Wdm.c.2.s <Control-Key-Up> {IncPag StrtPg  100}

bind $Wdm.c.2.e <Button-1> {dmfocus $Wdm.c.2.e; if {$dm_f!=-1} {dmInsLOP short}; set dm_f 2}
bind $Wdm.c.2.e <Button-2> {Bend}
Bind3HF $Wdm.c.2.e dm_seitene $Wdm.d.tt
bind $Wdm.c.2.e <Return>	{dmeep; dmfocus ""; Bend}
bind $Wdm.c.2.e <Tab>	 	{dmeep; set dm_f 3; focus $Wdm.c.2.pc.fn; Bend}
bind $Wdm.c.2.e <Shift-Tab>	{dmeep; set dm_f 1; focus $Wdm.c.2.s; dmInsLOP short; Bend}
bind $Wdm.c.2.e <Key-Down>	 {IncPag EndePg   -1}
bind $Wdm.c.2.e <Shift-Key-Down> {IncPag EndePg  -10}
bind $Wdm.c.2.e <Control-Down> 	 {IncPag EndePg -100}
bind $Wdm.c.2.e <Key-Up>	 {IncPag EndePg    1}
bind $Wdm.c.2.e <Shift-Key-Up>   {IncPag EndePg   10}
bind $Wdm.c.2.e <Control-Key-Up> {IncPag EndePg  100}


# Druckrichtung

button $Wdm.c.2.rv.t -text "" -width 15 -command {dmprtrev toggle}
Bind3HF $Wdm.c.2.rv.t dm_prtrev $Wdm.d.tt
# $Wdm.c.2.rv.t will be packed in procedure dmprtrev
dmprtrev nontoggle


# nicht/permanente Druckdatei

entry $Wdm.c.2.pc.fn -textvariable prt_file -width 20 -relief sunken
button $Wdm.c.2.pc.np -text "$prtfilperm" -width 15 -command {dmfilperm dmfocus}
pack configure $Wdm.c.2.pc.fn $Wdm.c.2.pc.np -side left
bind $Wdm.c.2.pc.fn <Button-1> {dmfocus $Wdm.c.2.pc.fn; set dm_f 3; Bend}
bind $Wdm.c.2.pc.fn <Button-2> {Bend}
bind $Wdm.c.2.pc.fn <Return>	{dmefn; dmfocus ""; Bend}
bind $Wdm.c.2.pc.fn <Tab>	{dmefn; focus $Wdm.c.2.pc.np; Bend}
bind $Wdm.c.2.pc.fn <Shift-Tab>	{dmefn; set dm_f 2; focus $Wdm.c.2.e; dmInsLOP short; Bend}
bind $Wdm.c.2.pc.np <Return>	{dmefn; dmfocus ""; Bend}
bind $Wdm.c.2.pc.np <Tab>	{dmefn; set dm_f 4; focus $Wdm.c.2.pc.cn; Bend}
bind $Wdm.c.2.pc.np <Shift-Tab>	{dmefn; set dm_f 3; focus $Wdm.c.2.pc.fn; Bend}
bind $Wdm.c.2.pc.np <Key-Down>>	{dmfilperm nodmfocus}
bind $Wdm.c.2.pc.np <Key-Up>>	{dmfilperm nodmfocus}
Bind3HF $Wdm.c.2.pc dm_perm $Wdm.d.tt
Bind3HF $Wdm.c.2.pc.np dm_perm $Wdm.d.tt
Bind3HF $Wdm.c.2.pc.fn dm_perm $Wdm.d.tt


# Kopienzahl

label $Wdm.c.2.pc.ct -text "  $vv(dmc2ct)"
entry $Wdm.c.2.pc.cn -textvariable printcops -width 10 -relief sunken
pack configure $Wdm.c.2.pc.ct $Wdm.c.2.pc.cn -side left

Bind3HF $Wdm.c.2.pc.ct dm_numcop $Wdm.d.tt
Bind3HF $Wdm.c.2.pc.cn dm_numcop $Wdm.d.tt
bind $Wdm.c.2.pc.cn <Button-1> {dmfocus $Wdm.c.2.pc.cn;set dm_f 4;$Wdm.c.2.pc.cn icursor end}
bind $Wdm.c.2.pc.cn <Button-2> {set printcops 1; writescr0 $Wdm.d.tt "";dmfocus "";Bend}
bind $Wdm.c.2.pc.cn <Return>	{dmecn; dmfocus ""; Bend}
bind $Wdm.c.2.pc.cn <Tab>	{dmecn; dmfocus $Wdm.a.e; Bend}
bind $Wdm.c.2.pc.cn <Shift-Tab> {dmecn; dmfocus $Wdm.c.2.pc.np; Bend}
bind $Wdm.c.2.pc.cn <Key-Down>	 {set printcops [IncrNumL $printcops  -1 1 $maxprintcops 1]}
bind $Wdm.c.2.pc.cn <Shift-Down> {set printcops [IncrNumL $printcops -10 1 $maxprintcops 1]}
bind $Wdm.c.2.pc.cn <Key-Up>	 {set printcops [IncrNumL $printcops   1 1 $maxprintcops 1]}
bind $Wdm.c.2.pc.cn <Shift-Up>	 {set printcops [IncrNumL $printcops  10 1 $maxprintcops 1]}


# Bereich d fuer Hilfe-Ausgaben

InsertTextFrame $Wdm $tyh "" "" ""
bind [AlphNum CmdXNo$Wdm.d.tt] <Button-1> {dmfocus ""}

#####WaitUntilExistsWin $Wdm.d.tt "Aufruf 1 aus dm.tcl, proc printmenu"

set dm_f -1; set dmLOP ""; set dmP(OK) 0; dmLookLOP; dmSetMm
focus $Wdm.a.e

}
