# Voreinstellungsmen fr Preview   
#
# Copyright (C) 2004  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc prv_select {s1 s2} {# get options after selection according to 
                         # s1 (== prtext, prformat)  and 
                         # s2 (!= "" if format is to be changed to "s2")
                         # return 1 if selection successfull, 0 otherwise
 global  vv Wp pvsep prtext preview prsuffix proptions prformat prback prpreopt prvfmtli

 if {![info exists pvsep]} {# read first line, get separator from it
   set foid [open_vst preview.vst]
   getscl $foid ein;  set pvsep [string index [string trim $ein] 0]
   close $foid
 }

 set p [string last "," $s1]
 set txt [string trim [string range $s1 0 [expr $p-1]]]; # selection string
 set fms [string trim [string range $s1 [expr $p+1] end]]; # select this format
 set foid [open_vst preview.vst]
 getscl $foid ein; # skip first line
 set selected 0
 if {[info exists prvfmtli]} {unset prvfmtli}
 while {[getscl $foid ein] > 0} {
   set z [split $ein $pvsep]
   if {[string trim [lindex $z 0]]==$txt} {# preview found
     set preview_     [string trim [lindex $z 1]]
     set prsuffix_    [string trim [lindex $z 2]]
     set proptions_   [string trim [lindex $z 3]]
     set sn [split [string trim [lindex $z 4]] ","]
     set prvfmtli ""
     foreach i $sn {# set list of all possible formats for this previewer
	regsub -all "\{" $i " \{" lien
	set prvfmtli "$prvfmtli [lindex $lien 0]"
     }
     foreach i $sn {# process formats for a distinct previewer until found
       regsub -all "\{" $i " \{" lien
       set fmt [lindex $lien 0]
       if {"$fmt"=="$fms"} {# (new) format is found
	 if {$s2==""} {
	   set prpreopt_ "[lindex $lien 1]"
	   set proptions_ "$proptions_ [lindex $lien 2]"
	   set prformat "$fms"
	   set selected 1; break
	 } else {# format change is demanded; look for new format hit
	   foreach j $sn {
	     regsub -all "\{" $j " \{" lien
	     set fmt [lindex $lien 0]
	     if {"$fmt"=="$s2"} {# new format hit
	       set prpreopt_ "[lindex $lien 1]"
	       set proptions_ "$proptions_ [lindex $lien 2]"
	       set prformat "$s2"
	       set selected 1; break
	     }
	   }
	   if {$selected} {break}
	 }
       }
     }
     if {$selected} {break}
   }
 }
 close $foid
 if {![info exists prvfmtli]} \
	{set prvfmtli "$vv(pvns1)\n$vv(pvns2) \"$txt\"\n$vv(xt41)\n$vv(xt42)\n$vv(xt33)"}
 if {$selected} {
   set prtext    $txt
   set preview   $preview_
   set prsuffix  $prsuffix_
   set proptions $proptions_
   set prpreopt  $prpreopt_
   progback  preview prback
   if [winfo exists $Wp] {pvanzeige;  if {$s2==""} {pvanzeigen "$vv(pv5)"}}
 }
 if {$selected} {return 1} else {return 0}
}


proc pvanzeige {} {global vv Wp preview prtext prformat proptions
 if {$preview==""} {$Wp.b.ad configure -text "$vv(pvbad1)"} \
	else {$Wp.b.ad configure -text "$vv(pvbad2)   $prtext, $prformat"}
 $Wp.cb delete 0 end;  $Wp.cb insert end "$proptions"
}

proc pvanzeigen {s1} {global vv Wp prtext prformat preview prback prsuffix prpreopt proptions
 writescr0 $Wp.d.tt "$s1\n\n$prtext, $prformat\n\n $vv(pv2) $preview$prback\n" \
       " $vv(pv3) $prsuffix\n $vv(pv7) $prpreopt\n $vv(pv4) $proptions\n $vv(pv6) $prformat\n"
}


proc pv  {} {

proc pvsel1 {s} {
 global vv Wp
 pvfocus ""
 if {$s!=""} {prv_select "$s" ""} else {writescr0 $Wp.d.tt "\n $vv(el)\n\n";mybell 2}
}

proc pvsel2 {s} {global pvnoend; set pvnoend 0; pvfocus ""; prfmtwahl "$s"}

proc prvlistfill {} {#fills the "preview list" in the "preview setting menu" by
                     #reading file "preview.vst",respecting variable "prvformat"
 global Wp pvsep prvformat

 set foid [open_vst preview.vst]
 # read first line, get separator from it
 getscl $foid ein;  set pvsep [string index [string trim $ein] 0]
 # read 2. and following lines
 $Wp.c.1.f.f.li delete 0 end;  $Wp.c.2.f.f.li delete 0 end
 set fmtl ""; set fmtla 0
 while {[getscl $foid ein] > 0} {
   set z [split $ein $pvsep]
   set sn [split [string trim [lindex $z 4]] ","]
   foreach i $sn {
     regsub -all "\{" $i " \{" lien
     set fmt [lindex $lien 0]
     if {[string first $fmt $fmtl]<0} {set fmtl "$fmtl $fmt"; incr fmtla}
     if {"$fmt"=="$prvformat"} \
		{$Wp.c.1.f.f.li insert end "[string trim [lindex $z 0]], $prvformat"}
   }
 }
 set fmtl [lsort $fmtl]
 foreach i $fmtl {$Wp.c.2.f.f.li insert end "$i"}
 close $foid
}

proc prfmtwahl {fmtneu} {
 global vv Wp main_file sub

 writescr0 $Wp.d.tt ""
 set subalt $sub; exec touch $main_file.dvi; lock; set sub $subalt
 format_switch $Wp.d.tt "$fmtneu" 3
}

proc pvfocus {w} {global Wp pv_foc;if {$pv_foc} pvopt;if {$w!=""} {focus $w} {focus $Wp.d.tt}}

proc pvopt {} {
 global Wp vv pv_foc proptions
 set proptions [$Wp.cb get]; writescr0 $Wp.d.tt "$vv(aus4)\n $proptions\n"
 set pv_foc 0
}

proc pvWpae {exImmediately} {
 global Wp main_file psuff prsuffix pvnoend
 if {($pvnoend==1)&&($exImmediately==0)} {set pvnoend 0; return}
 pvfocus ""; destros $Wp
 if {$main_file==""} {set psuff ""} else {set psuff $prsuffix};  knoepfe
 setInUnlockListe .c.1.pr; unlock_list
}

proc pvWpag {} {
 global vv prformat preview prback prvformat
 pvfocus ""; vstr_preview; progback preview prback
 pvanzeige; pvanzeigen "$vv(ausg1)"; set prvformat $prformat; prvlistfill
}


global vv Wp pv_foc pvnoend

toplevel_init $Wp "$vv(pvvor)" 0 0;  set tyh 12; set pvnoend 0


# Bereich a fuer erste Buttons

insertTopButtons $Wp pv_h "pvWpae 1"
button $Wp.a.g -text "$vv(ag)" -command {pvWpag}
Bind3HF $Wp.a.g pv_grund $Wp.d.tt
pack configure $Wp.a.g -side left -padx 3 -pady 3


# Bereich bv fuer eigene Einstellungen

frame $Wp.bv; pack configure $Wp.bv -pady 13 -anchor w
label   $Wp.bv.dv -text "$vv(bvdv)" -width 23 -anchor w
Bind3HF $Wp.bv.dv z_voreinst1 $Wp.d.tt
button  $Wp.bv.va -text "$vv(bvva)" -command {pvfocus ""; pvanzeigen "$vv(aus0)"}
Bind3HF $Wp.bv.va z_voreinst1 $Wp.d.tt
pack configure $Wp.bv.dv $Wp.bv.va -side left


# Bereich b fuer Anzeigen

frame $Wp.b; pack configure $Wp.b -anchor w
label $Wp.b.ad -width 80 -anchor w; pack configure $Wp.b.ad
Bind3HF $Wp.b.ad pv_anzeig $Wp.d.tt


# Bereich c fuer Wechsel   

frame $Wp.c; pack configure $Wp.c -anchor w -fill both -expand yes
frame $Wp.c.1; frame $Wp.c.d -width 5; frame $Wp.c.2
pack configure $Wp.c.2 $Wp.c.d $Wp.c.1 -side left -anchor n -fill both -expand yes

# Bereich c1 fuer Preview-Auswahl
CreateLSBox $Wp.c.1 "$vv(pvc1dl)" top 52 8 2 pv_prevsel $Wp.d.tt "" "" pvsel1 sel "pvWpae 0"

# Bereich c2 fuer Formatwechsel
CreateLSBox $Wp.c.2 "$vv(pvc2dl)" top 22 8 2 pv_fmtsel $Wp.d.tt "" "" pvsel2 sel "pvWpae 0"


# Ausgabe und Veraendern des Optionen-Strings

label $Wp.ca -text "$vv(pvca)"
Bind3HF $Wp.ca pv_optedi $Wp.d.tt
pack configure $Wp.ca -anchor w

entry $Wp.cb -width 80 -relief sunken
bind  $Wp.cb <Button-1> {pvfocus $Wp.cb; set pv_foc 1}
Bind3HF $Wp.cb pv_optedi $Wp.d.tt
bind  $Wp.cb <Return> {pvopt; pvfocus ""}
pack configure $Wp.cb -anchor w


InsertTextFrame $Wp $tyh "" "" ""

prvlistfill; pvanzeige; set pv_foc 0
}
