(******************************************************************************
 * program:     wp2latex                                                      *
 * function:    convert WordPerfect 5.0 or 5.1 files into LaTeX               *
 * modul:       wp2latex.c                                                    *
 * description: The main program opens and closes files and calls functions.  *
 ******************************************************************************)
Program WordPerfect_to_LaTeX;

{           Version 1.0  Date 27-1-1990
	    Version 2.0  Date 7-12-1996
		    2.1  Date 19-7-1997
                    2.15 Date 17-11-1997
                    2.19 Date 1-3-1998
                    2.20 Date 14-3-1998
}


{$R+,X+}       { Range check error }

{
Flags:'h';     Hard return
      's';     Soft return
      'P';     Hard page
      'p';     Soft page

      'B'      Table
      'C','c'  Center (only one line)
      'I'      Identing
      'L'      Left
      'R'      Right
      'Q'      Equation
      'T'      Tabbing



      'l' size			Line Spacing
      'U' type			Right Justification
      'S' number,[tab1,tab2]	Tabset
      #FF			end of line
}

Uses strings,
     pass1,pass1_6,pass2,
     common,
     {$ifdef windows}WinCrt;{$else}Crt;{$endif} { Clearscreen }


const version='2.3';


Var wpd_fn,
    strip_fn,
    tabel_fn,
    latex_fn,
    log_fn  : String;

    wpd,tabel: Bin;
    strip,log  : Text;
    Plog:Ptext;

    latex: Text;

    Exitsave : pointer;



{$F+}
Procedure end_prog;
{ This procedure wordt tied het end van het programma aangeroepen. }
{ Er wordt gekeken of er zich Run-Time error heeft voor gedaan.     }

Var
   save_ErrorAddr : Pointer;

Begin
   Writeln;

   ExitProc:=Exitsave;
   save_ErrorAddr := ErrorAddr;
   ErrorAddr := nil;

   If save_ErrorAddr <> nil
   Then Case Exitcode of
	       $0002 : Writeln('File not found.');
	       $0003 : Writeln('Path not found.');
	       $0100 : Writeln('Program Error.');
	       $0200 : Writeln('No filename entered !');
	       $0201 : Writeln('Not a WordPerfect 5.0 document !');

	     Else ErrorAddr := save_ErrorAddr;
	End

   Else Begin
	   Writeln('Conversion completed.');
	   Writeln;
	End;

   Writeln;
End;
{$F-}

{$i-}
Function Fopen(path:string):Ptext;
begin
end;
{$i+}


{ Controls of the openned WP-document wel daadwerkelijk one   }
{ WP5.x-document is.                                          }
Procedure Wpd_check;
Var id1,id2,std1,std2,filetype,dmp1,dmp2,dmp3 : Word;
    Startdoc, Pointer : Longint;
    b:Byte;

Begin
   Rd_word(wpd,id1); Rd_word(wpd,id2);
   Rd_word(wpd,std1); Rd_word(wpd,std2);
   Rd_word(wpd,filetype);
   Rd_word(wpd,dmp1); Rd_word(wpd,dmp2); Rd_word(wpd,dmp3);



   Startdoc:=std2*65536+std1;

   If (id1=$57ff) and (id2=$4350) and
      (filetype=$0A01)  {and (dmp1=$0) and (dmp2=$0) and (dmp3=$0)}

  (* && dmp1 == 0 && dmp2 == 0 && dmp3 == 0 ) *)
  (* ^-- this was a comment in the Pascal file. I (AT) translated
      * this code into C by hand, because it seems me to give a hint
      * on the WP-Version. I'm absolutely not sure whether the
      * following is correct, but I think:
      *   dmp1 == 0x0000 -> WP 5.0
      *   dmp1 == 0x0100 -> WP 5.1
      *   dmp1 == 0x0002 -> WP 6.0  <- this will not correct handled!!!!  *)

   Then begin
        Seek(wpd,startdoc);    { Het is one WP5.0-document}
        wp60:= dmp1 = 0002;
        if wp60 then writeln('Warning: It seems to be a WordPerfect 6.0 document!'+
		             '  EXPECT ERRORS!!!'#10#13);
        end
   Else RunError($0201)       { Het is geen WP5.0-document}
End;


{ This procedure handles parametters and the filenames}
Procedure Filenames;
Var name  :string;
    p   : Integer;

Begin
   wpd_fn:='';
   latex_fn:='';

   for p:=1 to paramcount do
	begin
	name:=ParamStr(p);
	if name[1]='-' then name[1]:='/';
	if name[1]='/' then
		begin
		if name='/cp895' then
		   begin
		   CodePage:=895;
		   continue;
		   end;
		if name='/cp852' then
		   begin
		   CodePage:=852;
		   continue;
		   end;
                if name='/charset1' then
		   begin
                   WPcharset:=1;
		   end;
                if (name='/s')or(name='/silent') then
		   begin
                   Verbosing:=0;
		   end;
                if name='/optimizesection' then
		   begin
                   OptimizeSection:=True;
		   end;
                if name='/nooptimizesection' then
		   begin
                   OptimizeSection:=False;
		   end;
                if (name='/charsetCZ')or(name='/charsetCS') then
		   begin
                   WPcharset:=2;
		   end;
		if name='/texchars' then
		   begin
		   TexChars:=True;
		   end;
                if name='/notexchars' then
		   begin
		   TexChars:=False;
		   end;
		if name='/?' then
		   begin
		   writeln(#10#13'Somebody at Eindhoven Univ of Techn wrote a wordperfect 5.0 to LaTeX'+
			   #10#13'conversion program (only running on MSDOS of course) :=)'+
			   #10#13'           This program was completely rewritten by Jaroslav Fojtik',
			   #10#13'and many new functions was added (eg conversion of math equations)'+
			   #10#13'Write any suggestions, reports or bugs to address FOJTIK@VISION.FELK.CVUT.CZ'+
			   #10#10#13'Parametters: WP2LATEX [input_file [output_file]] [/cp895|/cp852] [/texchars]',
                           #10#13'                      [/?] [/optimizesection] [/silent]',
			   #10#13'   /cp895     switch generation of output code table 895 (Kamenicky)',
			   #10#13'   /cp852     switch generation of output code table 852 (ISO8)',
			   #10#13'   /texchars  doesn''t interpret tex macros (all chars 32-128 will not be',
			   #10#13'              converted)',
                           #10#13'   /charset1  switch internal WordPerfect char set to set 1. This option',
			   #10#13'              is default.',
                           #10#13'   /charsetCZ switch internal WordPerfect char set to keybcs.',
                           #10#13,
			   #10#13'Important note: Conversions performed by wp2latex are only partial.',
			   #10#13'Print the resulting document and compare carefully with original.',
			   #10#13'In all but the simplest documents you will have to do further editing.',
			   #10#13'Or you may wish to edit the WordPerfect document to remove unwanted',
			   #10#13'codes (such as Tab, Tab Set), then run it through wp2latex again.');
		     halt(1);
		   end;

                 if name='/i' then
        	         begin
                         inc(p);
	                 wpd_fn:=ParamStr(p);
                         end;
                 if name='/o' then
        	         begin
                         inc(p);
	                 latex_fn:=ParamStr(p);
                         end;
                 if name='/l' then
        	         begin
                         inc(p);
	                 log_fn:=ParamStr(p);
                         end;


		continue;
		end;


	if wpd_fn='' then
		begin
		wpd_fn:=name;
		continue;
		end;
	if latex_fn='' then
		begin
		latex_fn:=name;
		continue;
		end;
	end;

  if (latex_fn='') then
      begin

      if (Verbosing>=1)or(wpd_fn='') then
        begin
        Writeln;
        Writeln;
        Write('WordPerfect-filename [',wpd_fn,'] : ');
        Readln(name);
        If name<>'' Then wpd_fn:=name;
        end;


      If wpd_fn='' Then RunError($200);       { No filename entered }

      p:=Pos('.',wpd_fn);
      if p=0 then name:=wpd_fn
	     else name:=copy(wpd_fn,1,p-1);
      if latex_fn='' then latex_fn:=concat(name,'.TEX');

      if (Verbosing>=1)or(latex_fn='') then
        begin
        Write('LaTeX-filename [',latex_fn,'] : ');
        Readln(name);
        Writeln;
        If name<>'' Then latex_fn:=name;
        end;
      end;


   p:=Pos('.',wpd_fn);
   if p=0 then name:=wpd_fn
	     else name:=copy(wpd_fn,1,p-1);

   strip_fn:=concat(name,'.STR');
   tabel_fn:=concat(name,'.TBL');

   Assign(wpd,wpd_fn);
   Assign(strip,strip_fn);
   Assign(tabel,tabel_fn);
   Assign(latex,latex_fn);
   Assign(log,log_fn);
End;

{---begin of PROG---}
Begin
   Cyrilic:=False;
   Verbosing:=1;
   TexChars:=False;
   CodePage:=0;			{unknown - no 8 bit code generated}
   WPcharset:=1;		{common char set 1}
   ExtendedCheck:=True;

   Exitsave:=Exitproc;		{ store the original exit-pointer }
   Exitproc:=@end_prog;		{ store the Exit Proc. pointer end_prog }

   ClrScr;
   Writeln;
   Writeln(' Conversion program : From Wordperfect 5.1 to LaTeX Version ',version,' (WP2latEX)');
   Writeln;
   Writeln('  (c) TUE-Eindhoven ---- Made by R.C.Houtepen ---- Date : 24 Jan 1990');
   Writeln('  (c) CVUT Prague   ---- Made by J.Fojtik     ---- Date : 1996-1998');

   Filenames;

   filemode:=0;
   Reset(wpd);
   filemode:=2;
   wpd_check;

   Rewrite(strip);
   Rewrite(tabel);
   Plog:=nil;
   if log_fn<>'' then
   	begin
	Rewrite(log);
        Plog:=addr(log);
        end;

   Writeln('Converting ...');
   Writeln;

   if wp60 then Convert_first_pass60(wpd,tabel,strip,Plog)
           else Convert_first_pass(wpd,tabel,strip,Plog);

   Close(wpd);
   Close(strip);
   Close(tabel);
   if log_fn<>'' then Close(log);

   Reset(strip);
   Reset(tabel);
   Rewrite(latex);

   Convert_second_strike(Strip,tabel, latex);

   Close(strip);
   Close(tabel);
   Close(latex);

   Erase(strip);
   Erase(tabel);{}

End.

