'****************************************************************************
' qfig.bas  <-- bfig.bas <-- motivated by "xfig" on X-*indow of UN*X
'                2/21/1993        T.Iwakuma (bear@hashi1.civil.tohoku.ac.jp)
'****************************************************************************
' "mouse.obj" and "graph.obj" must be "link"ed and "lib"ed to make
'            "qfig.lib" as well as "qfig.qlb".
'                       interpreter must be activated as "qb /lqfig"
'****************************************************************************
'$INCLUDE: 'QB.BI'
'$DYNAMIC
'$INCLUDE: 'MOUSE.BI'
'$INCLUDE: 'QFIG.BI'
'****************************************************************************
qfigtitle$ = "qfig Ver.1.1a (3/24/1997)"
'qfigtitle1$ = "modified for J-3100/IBM compatible PCs"
qfigtitle2$ = "by: William Ofosu-Amaah"
'qfigtitle3$ = "from: qfig NEC Ver.0.9c+1 (3/20/1993)"
'qfigtitle4$ = "by: Mr T.Iwakuma (bear@hashi1.tohoku.ac.jp)"
qfigtitle5$ = "(XI6W-OFSA@asahi-net.or.jp)"
'****************************************************************************
'
IF INSTR(COMMAND$, "/?") <> 0 THEN
   whelp
   END
END IF

Preparation
'                                                                   key call
ON KEY(1) GOSUB f.1
ON KEY(2) GOSUB f.2
ON KEY(3) GOSUB f.3
ON KEY(4) GOSUB f.4
ON KEY(5) GOSUB f.5
ON KEY(6) GOSUB f.6
ON KEY(7) GOSUB f.7
ON KEY(8) GOSUB f.8
ON KEY(9) GOSUB f.9
ON KEY(10) GOSUB f.10
ON KEY(15) GOSUB fnctn:  KEY 15, CHR$(&H0) + CHR$(&H1) 'ESC
ON KEY(16) GOSUB redraw: KEY 16, CHR$(&H4) + CHR$(&H13) 'CTRL+R
ON KEY(17) GOSUB Help: KEY 17, CHR$(&H4) + CHR$(&H23) 'CTRL+H
ON KEY(19) GOSUB quit: KEY 19, CHR$(&H4) + CHR$(&H10) 'CTRL+Q
ON KEY(20) GOSUB clreset: KEY 20, CHR$(&H4) + CHR$(&H1F) 'CTRL+S
ON KEY(22) GOSUB stext:     KEY 22, CHR$(&H4) + CHR$(&H14)'CTRL+T
ON KEY(24) GOSUB widewindow: KEY 24, CHR$(&H4) + CHR$(&H11) 'CTRL+W
KeySwitch 1
KEY(8) ON: KEY(9) ON: KEY(10) ON: KEY(17) ON: KEY(19) ON
KEY OFF
ON ERROR GOTO somethingwrong
'                                                           mouse activation
IF MouseReady% THEN                           '<=== when Mouse is used
  MouseInit                                   '|
  MouseMode 1                                 '|
  MouseHide                                   '|
  MouseBorder pymin%, pxmin%, pymax%, pxmax%  '|
  MouseLocate py%, px%                        '|
  mouswitch% = -1                             '|
END IF                                        '<=== when Mouse is used

SCREEN scrtype%
GOSUB title
VIEW SCREEN (0, 0)-(windowx%(0), windowy%(0))
WINDOW SCREEN (0, 0)-(windowx%(0), windowy%(0))
CL.R.edraw 0, 0
SetInst -1

'                                                         Main infinite LOOP
DO
  pxold% = px%: pyold% = py%
  keyin% = KeyIsTyped%
  IF ((keyin% > 4) AND (job% = 0)) THEN
	ON keyin% - 4 GOSUB rollup, rolldown, leftmost, rightmost
  END IF
  IF keyin% = 2 OR keyin% = 3 THEN
	qx% = INT(CSNG(px% - pxo%) / wndwxy(wndwfctr%) + .9)
	qy% = INT(CSNG(py% - pyo%) / wndwxy(wndwfctr%) + .9)
	IF qy% > windowy%(0) - 48 THEN
	  IF qx% < 15 THEN
		IF py% >= pymax% - 4 THEN GOSUB rolldown
	  ELSEIF qx% < 295 THEN
		i% = INT((CSNG(qx%) + 41!) / 56!)
		IF qx% < 56 * i% + 8 THEN
		  GOSUB setbymouse
		  ON i% GOSUB f.1, f.2, f.3, f.4, f.5
		END IF
	  ELSEIF qx% > 366 THEN
		i% = INT((CSNG(qx%) - 31!) / 56!)
		IF qx% < 56 * i% + 80 THEN
		  GOSUB setbymouse
		  ON i% - 5 GOSUB f.6, f.7, f.8, f.9, f.10
		END IF
	  END IF
	ELSEIF py% <= pymin% + 4 THEN
	  IF px% <= pxmin% + 4 THEN
		dwndwfctr% = 1
		GOSUB widewindowbymouse
	  ELSEIF px% >= pxmax% - 4 THEN
		dwndwfctr% = -1
		GOSUB widewindowbymouse
	  ELSE
		GOSUB rollup
	  END IF
	ELSEIF px% <= pxmin% + 4 THEN
	  GOSUB leftmost
	ELSEIF px% >= pxmax% - 4 THEN
	  GOSUB rightmost
	END IF
  END IF
  CursorDisplay pxold%, pyold%
  CursorDisplay px%, py%
LOOP
'                                                show or not show text
stext:
KeySwitch 0
IF wtext% = 0 THEN
   wtext% = 1
ELSE
   wtext% = 0
END IF
CL.R.edraw 0, 0
KeySwitch 1
RETURN
'                                                           command by mouse
setbymouse:
IF py% - pyo% < windowy%(wndwfctr%) - INT(32! * wndwxy(wndwfctr%) + .9) THEN
  func% = 0: func1% = 0: GOSUB fnctn1  'Top Line of Function row
ELSEIF py% - pyo% < windowy%(wndwfctr%) - INT(16! * wndwxy(wndwfctr%) + .9) THEN
  func% = 1: func1% = 1: GOSUB fnctn1 'Middle Line
ELSE
  func% = 2: func1% = 1: GOSUB fnctn1 'Bottom Line
END IF

RETURN
'                                                            clear and reset
clreset:
LOCATE 12, 30: PRINT " Are you sure (Y/N) " '; CHR$(7);
DO: a$ = KeyIsTouched$
LOOP UNTIL a$ = CHR$(CR) OR (a$ <> "" AND INSTR("YyNn", a$) <> 0)
IF UCASE$(a$) = "Y" THEN
  nobj% = 0
  CL.R.edraw 0, 0: SetInst -1
ELSE
  GOSUB redraw
END IF
 RETURN
'                                                                     ending
quit:
QUIT0
RETURN
'
quit1:
IF mouswitch% THEN MouseHide: MouseInit         '<=== when Mouse is used
KeySwitch 0: KEY(8) OFF: KEY(9) OFF: KEY(10) OFF: KEY(17) OFF: KEY(19) OFF
RETURN
'
title:
deg = 3.14 / 180
IF ega% = 0 THEN
 cf% = 12
 cb% = 15
 cs% = 1
 cline% = 1
 ytext% = 16
ELSE
 cf% = 4
 cb% = 7
 cs% = 0
 cline% = 1
 ytext% = 18
END IF
'cl% and cb% should never be the same'
xlogo% = 50

PAINT (xlogo% + 135, 100), cb%
CIRCLE (xlogo% + 205, 100), 50, cline%, , , 1
CIRCLE (xlogo% + 215, 105), 50, cline%, 70 * deg, 236 * deg, 1
CIRCLE (xlogo% + 212, 103), 67, cline%, 250 * deg, 80 * deg, 1
CIRCLE (xlogo% + 200, 100), 67, cline%, , , 1
PAINT (xlogo% + 135, 100), cf%, cline%
PAINT (xlogo% + 156, 100), cs%, cline%
PAINT (xlogo% + 278, 103), cs%, cline%
LINE (xlogo% + 205, 150)-(xlogo% + 240, 180), 2
LINE (xlogo% + 190, 166)-(xlogo% + 240, 200), 2
LINE (xlogo% + 240, 180)-(xlogo% + 290, 170), 2
LINE (xlogo% + 240, 200)-(xlogo% + 290, 170), 2
LINE (xlogo% + 205, 150)-(xlogo% + 190, 166), 2
PAINT (xlogo% + 240, 198), cf%, 2
LINE (xlogo% + 205, 150)-(xlogo% + 190, 166), cf%
LINE (xlogo% + 205, 150)-(xlogo% + 240, 180), cline%
LINE (xlogo% + 190, 166)-(xlogo% + 240, 200), cline%
LINE (xlogo% + 240, 180)-(xlogo% + 290, 170), cline%
LINE (xlogo% + 240, 200)-(xlogo% + 290, 170), cline%
LINE -STEP(3, 8), cline%
LINE -STEP(-50, 30), cline%
LINE -STEP(-30, -25), cline%
PAINT (xlogo% + 290, 172), cs%, cline%
CIRCLE (xlogo% + 193, 165), 20, cline%, 48 * deg, 113 * deg, 1
PAINT (xlogo% + 193, 147), cf%, cline%
CIRCLE (xlogo% + 205, 100), 50, cf%, 250 * deg, 270 * deg, 1
LINE (xlogo% + 280, 160)-(xlogo% + 285, 130), cline%
LINE -STEP(-5, 0), cline%
LINE -STEP(2, -8), cline%
LINE -STEP(40, 0), cline%
LINE -STEP(-3, 8), cline%
LINE -STEP(-20, 0), cline%
LINE -STEP(-1, 7), cline%
LINE -STEP(15, 0), cline%
LINE -STEP(-2, 6), cline%
LINE -STEP(-13, 0), cline%
LINE -STEP(-3, 17), cline%
LINE -STEP(-14, 0), cline%
PAINT (xlogo% + 282, 159), cf%, cline%
LINE (xlogo% + 326, 160)-(xlogo% + 331, 122), cline%
LINE -STEP(10, 0), cline%
LINE -STEP(-5, 38), cline%
LINE -STEP(-10, 0), cline%
PAINT (xlogo% + 328, 158), cf%, cline%
CIRCLE (xlogo% + 367, 140), 17, cline%, 36 * deg, 160 * deg, 1
CIRCLE (xlogo% + 368, 138), 8, cline%, 25 * deg, 160 * deg, 1
LINE (xlogo% + 350, 135)-(xlogo% + 348, 149), cline%
LINE (xlogo% + 361, 135)-(xlogo% + 357, 147), cline%
LINE (xlogo% + 375, 135)-(xlogo% + 382, 135), cline%
LINE -STEP(-1, -4), cline%
CIRCLE (xlogo% + 365, 143), 17, cline%, 200 * deg, 335 * deg, 1
CIRCLE (xlogo% + 366, 144), 8, cline%, 200 * deg, 335 * deg, 1
LINE (xlogo% + 373, 146)-(xlogo% + 367, 146), cline%
LINE -STEP(2, -4), cline%
LINE -STEP(20, 0), cline%
LINE -STEP(-2, 4), cline%
LINE -STEP(-6, 0), cline%
LINE -STEP(0, 3), cline%
PAINT (xlogo% + 377, 133), cf%, cline%

PSET (xlogo% + 120, 210), cline%
LINE -STEP(58, 0), cline%
PSET (xlogo% + 120, 210), cline%
LINE -STEP(12, 11), cline%
LINE -STEP(-12, 11), cline%
LINE -STEP(55, 0), cline%
CIRCLE (xlogo% + 178, 213), 3, cline%, 270 * deg, 90 * deg, 1
CIRCLE (xlogo% + 178, 219), 3, cline%, 90 * deg, 270 * deg, 1
LINE (xlogo% + 181, 213)-(xlogo% + 181, 224), cline%
LINE (xlogo% + 175, 219)-(xlogo% + 175, 250), cline%
CIRCLE (xlogo% + 250, 0), 234, cline%, 252 * deg, 288 * deg, 1
PAINT (xlogo% + 126, 214), cf%, cline%
PAINT (xlogo% + 176, 219), cf%, cline%
PSET (xlogo% + 320, 210), cline%
LINE -STEP(60, 0), cline%
PSET (xlogo% + 380, 210), cline%
LINE -STEP(-12, 11), cline%
LINE -STEP(12, 11), cline%
LINE -STEP(-57, 0), cline%
CIRCLE (xlogo% + 320, 219), 3, cline%, 270 * deg, 90 * deg, 1
CIRCLE (xlogo% + 320, 213), 3, cline%, 90 * deg, 270 * deg, 1
LINE (xlogo% + 317, 213)-(xlogo% + 317, 225), cline%
LINE (xlogo% + 323, 219)-(xlogo% + 323, 250), cline%
CIRCLE (xlogo% + 250, 0), 260, cline%, 253.5 * deg, 286.4 * deg, 1
PAINT (xlogo% + 321, 219), cf%, cline%
PAINT (xlogo% + 320, 226), cf%, cline%
PAINT (xlogo% + 376, 212), cf%, cline%
s$ = "Version 1.1a"
DIM inRegs AS RegType, outRegs AS RegType
LOCATE ytext%, 27 + INT(xlogo% / 8)
inRegs.bx = &H80 + (cf%)
FOR i = 1 TO LEN(s$)
  inRegs.ax = &HE00 + ASC(MID$(s$, i, 1))
  CALL INTERRUPT(&H10, inRegs, outRegs)
NEXT i
SLEEP 1
CLS 0: RETURN

'                                                      alternative functions
fnctn:
func% = (func% + 1) MOD 3
fnctn1:
LOCATE line2%, 2: PRINT " "; : COLOR 7
LOCATE line1%, 2: PRINT " "; : COLOR 7
LOCATE line1% + 1, 2: PRINT " "; : COLOR 7
LOCATE line2% + func%, 2: COLOR 6: PRINT "@"; : RETURN
'LOCATE line2% + func1%, 2: PRINT " "; : COLOR 7: RETURN

'fnctn: SWAP func%, func1%
'LOCATE line2% + func%, 2: COLOR 6: PRINT "@";
'LOCATE line2% + func1%, 2: PRINT " "; : COLOR 7: RETURN

'                                                                 need help?
Help: Help.Me: RETURN
'                                                                     redraw
redraw: CL.R.edraw 0, 0: RETURN
'                                                                   grouping
'grouping: G.Group: GOTO f.end
'                                                         rollup/down screen
rollup:
IF pymin% - vscroll% < 0 THEN RETURN
ipy% = -vscroll%: GOTO updown
rolldown:
IF pymax% + vscroll% > REGIONYMAX THEN RETURN
ipy% = vscroll%
updown:
pyo% = pyo% + ipy%: py% = py% + ipy%
row% = row% + ipy%: pyold% = pyold% + ipy%
pymin% = pyo% + INT(margin% * wndwxy(wndwfctr%) + .9)
pymax% = pyo% + windowy%(wndwfctr%) - INT(margin% * wndwxy(wndwfctr%) + .9)
pymax2% = pyo% + windowy%(wndwfctr%) - INT(margin% * wndwxy(wndwfctr%) + .9) - texth% * 3 * INT(wndwxy(wndwfctr%) + .9) - 21
GOTO rst.scrn
'                                                     move left/right screen
leftmost:
IF pxmin% - hscroll% < 0 THEN RETURN
ipx% = -hscroll%: GOTO leftright
rightmost:
IF pxmax% + hscroll% > REGIONXMAX THEN RETURN
ipx% = hscroll%
leftright:
pxo% = pxo% + ipx%: px% = px% + ipx%
col% = col% + ipx%: pxold% = pxold% + ipx%
pxmin% = pxo% + INT(margin% * wndwxy(wndwfctr%) + .9)
pxmax% = pxo% + windowx%(wndwfctr%) - INT(margin% * wndwxy(wndwfctr%) + .9)
'                                                               reset   screen
rst.scrn:
IF mouswitch% THEN                             '<=== when Mouse is used
  MouseBorder pymin%, pxmin%, pymax%, pxmax%   '|
END IF                                         '<=== when Mouse is used
WINDOW SCREEN (pxo%, pyo%)-(pxo% + windowx%(wndwfctr%), pyo% + windowy%(wndwfctr%))
CL.R.edraw 0, 0
RETURN
'                                                      widen window by mouse
widewindowbymouse:
wndwfctr% = wndwfctr% + dwndwfctr%
IF wndwfctr% > UBOUND(wndwxy) THEN wndwfctr% = 0
IF wndwfctr% < LBOUND(wndwxy) THEN wndwfctr% = UBOUND(wndwxy)
GOTO windowide
'                                                               widen window
widewindow:
KeySwitch 0
KEY(17) OFF: KEY(19) OFF   'Also disable Help, Quit
CLS 0
PRINT "Reduction rate:"
FOR i% = 0 TO 3: PRINT TAB(4); i%; " : "; INT(1000 / wndwxy(i%)) / 10;
PRINT TAB(16); "%": NEXT i%
PRINT "Select one [0-3]"
DO: a$ = INKEY$: LOOP UNTIL a$ <> "" AND INSTR("0123", a$) <> 0
wndwfctr% = VAL(a$)
windowide:
pxmin% = pxo% + INT(margin% * wndwxy(wndwfctr%) + .9)
pxmax% = pxo% + windowx%(wndwfctr%) - INT(margin% * wndwxy(wndwfctr%) + .9)
pymin% = pyo% + INT(margin% * wndwxy(wndwfctr%) + .9)
pymax% = pyo% + windowy%(wndwfctr%) - INT(margin% * wndwxy(wndwfctr%) + .9)
pymax2% = pyo% + windowy%(wndwfctr%) - INT(margin% * wndwxy(wndwfctr%) + .9) - texth% * 3 * INT(wndwxy(wndwfctr%) + .9) - 21
IF px% > pxmax% OR px% < pxmin% THEN
  IF px% > pxmax% THEN
	px% = INT(CSNG(pxmax%) / 4!) * 4
  ELSE
	px% = INT(CSNG(pxmin%) / 4! + .9) * 4
  END IF
  pxold% = px%: col% = px%
END IF
IF py% > pymax% OR py% < pymin% THEN
  IF py% > pymax% THEN
	py% = INT(CSNG(pymax% - INT(48! * wndwxy(wndwfctr%))) / 4!) * 4
  ELSE
	py% = INT(CSNG(pymin%) / 4! + .9) * 4
  END IF
  pyold% = py%: row% = py%
END IF
KEY(17) ON: KEY(19) ON  'Renable Help, Quit
KeySwitch 1
GOTO rst.scrn
'                                                      straight lines / move
f.1:
seljob% = 1
KEY(1) OFF
IF kswitch% = 1 AND func% = 0 THEN
  linesel% = 0
  G.Curve 1, 0
ELSEIF kswitch% = 1 AND func% = 1 THEN
  linesel% = 1
  MoveObj 0
ELSE
  FillPattern
  COLOR 10
  LOCATE line1% + 1, 7: PRINT fill%;
  LOCATE line1% + 1, 3: PRINT "Fil-P";
  COLOR 7
  IF inbox% = 1 THEN
    IF fill% <> 0 THEN
	  LINE (sxg%, syg%)-(px%, py%), 2, B
	  PAINT ((sxg% + px%) / 2, (syg% + py%) / 2), 0, 2
    END IF
    LINE (sxg%, syg%)-(px%, py%), 0, BF
    LINE (sxg%, syg%)-(px%, py%), 0, BF
    IF fill% = 0 THEN
	  LINE (sxg%, syg%)-(px%, py%), 7, B
    ELSE
	  LINE (sxg%, syg%)-(px%, py%), 2, B
	  PAINT ((sxg% + px%) / 2, (syg% + py%) / 2), tlp$(fill%), 2
    END IF
  ELSEIF inbox% = 2 THEN
   obj%(nobj%, 6) = fill%
     LINE (INT(xx(nobj%, 0)), INT(yy(nobj%, 0)))-(INT(xx(nobj%, 1)), INT(yy(nobj%, 1))), 0, BF
     D.Lines INT(xx(nobj%, 0)), INT(yy(nobj%, 0)), INT(xx(nobj%, 1)), INT(yy(nobj%, 1)), 7, 2, obj%(nobj%, 4), 0, obj%(nobj%, 6), 0
  END IF
END IF
seljob% = 0
KEY(1) ON
GOTO f.end
'                                                              curves / copy
f.2:
KEY(2) OFF
IF kswitch% = 1 AND func% = 0 THEN
  seljob% = 2
  linesel% = 0
  G.Curve 2, 0
  seljob% = 0
ELSEIF kswitch% = 1 AND func% = 1 THEN
  seljob% = 2
  linesel% = 1
  MoveObj 1
  seljob% = 0
ELSE
  chartype% = chartype% + 1: IF chartype% > UBOUND(chartype$) THEN chartype% = 0
  COLOR 10: LOCATE line1% + 1, 10: PRINT chartype$(chartype%); : COLOR 7
END IF
KEY(2) ON
GOTO f.end
'                                             circle+ellipse/ symmetric copy
f.3:
KEY(3) OFF
IF kswitch% = 1 AND func% = 0 THEN
  seljob% = 3
  linesel% = 0
  G.Crcl.Ellps
  seljob% = 0
ELSEIF kswitch% = 1 AND func% = 1 THEN
  seljob% = 3
  linesel% = 1
  CopySymm
  seljob% = 0
ELSE    'Just added
  SELECT CASE charpt%
	CASE 10
	    charpt% = 12
	CASE 12
	    charpt% = 10
  END SELECT
  COLOR 10: LOCATE line1% + 1, 17: PRINT charpt%;
  LOCATE line1% + 1, 20: PRINT "pt."; : COLOR 7
END IF
KEY(3) ON
GOTO f.end
'                                                                arc/ rotate
f.4:
seljob% = 4
IF func% = 0 THEN
  linesel% = 0
  G.Arc
ELSEIF func% = 1 THEN
  linesel% = 1
  Rotate
ELSE
  COLOR 7
  GOSUB widewindow
END IF
seljob% = 0
GOTO f.end
'                                                                  box/ edit
f.5:
seljob% = 5
IF func% = 0 THEN
  linesel% = 0
  G.Box
ELSEIF func% = 1 THEN
  linesel% = 1
  EditObject
ELSE
  GOSUB stext
  SELECT CASE wtext%
     CASE 0
       COLOR 3: LOCATE line1% + 1, 31: PRINT "T_Hide"; : COLOR 7
     CASE 1
       COLOR 3: LOCATE line1% + 1, 31: PRINT "T_Show"; : COLOR 7
  END SELECT
END IF
seljob% = 0
GOTO f.end
'                                                               polygon/ cut
f.6:
seljob% = 6
IF func% = 0 THEN
  linesel% = 0
  G.Curve 1, 1
ELSEIF func% = 1 THEN
  linesel% = 1
  DispCut
ELSE
  CL.R.edraw 0, 0
END IF
seljob% = 0
GOTO f.end
'                                                         closed curve/ kill
f.7:
seljob% = 7
IF func% = 0 THEN
  linesel% = 0
  G.Curve 2, 1
ELSEIF func% = 1 THEN
  linesel% = 1
  KillObject
ELSE
  COLOR 7
  GOSUB clreset
END IF
seljob% = 0
GOTO f.end
'                                                           arrow/ line type
f.8:
IF kswitch% = 1 AND func% = 0 THEN
  seljob% = 8
  KEY(8) OFF
  linesel% = 0
  G.Arrows
  seljob% = 0
  KEY(8) ON
  GOTO f.end
ELSE
  ltype% = ltype% + 1: IF ltype% > UBOUND(ltp$) THEN ltype% = 0
  kky$(18) = ltp$(ltype%)
  COLOR 10: LOCATE line1%, 61: PRINT kky$(18); : COLOR 7
  RETURN
END IF
'                                                         strings/ thickness
f.9:
IF kswitch% = 1 AND func% = 0 THEN
  seljob% = 9
  KEY(9) OFF
  linesel% = 0
  G.Char
  seljob% = 0
  KEY(9) ON
  GOTO f.end
ELSE
  thick% = thick% + 1: IF thick% > UBOUND(lth$) THEN thick% = 0
  kky$(19) = lth$(thick%)
  COLOR 10: LOCATE line1%, 68: PRINT kky$(19); : COLOR 7
  RETURN
END IF
'                                                     file operations/ pitch
f.10:
IF kswitch% = 1 AND func% = 0 THEN
  IO.File
  GOTO f.end
ELSE
  SELECT CASE s%

	CASE 1
	    s% = 4
	    kky$(20) = "Pitch4"
	CASE 4
	    s% = 8
	    kky$(20) = "Pitch8"
	CASE 8
	    s% = 1
	    kky$(20) = "Pitch1"
  END SELECT

  COLOR 10: LOCATE line1%, 75: PRINT kky$(20); : COLOR 7
  RETURN
END IF
'
f.end: pxold% = px%: pyold% = py%
RETURN

somethingwrong:
CLOSE : OPEN "$panic$.qfg" FOR OUTPUT AS #1
wrong% = 1
CLS 0
IO.Save 3: CLOSE
wrong% = 0
COLOR 14: PRINT : PRINT
PRINT TAB(10); CHR$(7); "Ummm...  Something wrong happened..."; CHR$(7)
COLOR 7: PRINT : PRINT TAB(10); "Error code is #"; ERR
SELECT CASE ERR
  CASE 7
   PRINT : PRINT TAB(10); "Out of memory. Free some more conventional memory"
  CASE 9
   PRINT : PRINT TAB(10); "A subscript is out of range"
  CASE 52
   PRINT : PRINT TAB(10); "Illegal DOS filename"
  CASE 64
   PRINT : PRINT TAB(10); "Illegal DOS filename"

END SELECT
PRINT : PRINT TAB(10); "Objects are saved into '$panic$.qfg'"
PRINT : PRINT
SLEEP 3
GOSUB quit1: KEY ON: END

'                                                                       data
DATA 88,00,00,00,88,00,00,00
DATA CC,00,33,00,CC,00,33,00,CC,33,CC,33,CC,33,CC,33
'--------------------------------------------------------------------------
tex.pitch:
'set by \wd and \ht of \box of each character; 7/24/1992
' roman 10pt
DATA 333,278,500,833,500,833,778,250,389,389,500,778,167,778,278,500
DATA 500,500,500,500,500,500,500,500,500,500,278,278,778,778,778,472
DATA 778,750,708,722,764,681,653,785,750,386,514,778,625,917,750,778
DATA 681,778,736,556,722,750,750,1028,750,750,611,278,333,278,525,360
DATA 333,500,556,444,556,444,292,500,556,278,306,528,278,833,556,525
DATA 556,528,392,394,389,556,528,722,528,528,444,500,278,500,525
' bold 10pt
DATA 383,350,603,958,575,958,894,301,447,447,575,894,192,778,319,575
DATA 575,575,575,575,575,575,575,575,575,575,319,319,778,894,778,543
DATA 894,869,818,831,882,756,724,904,900,465,594,901,692,1092,900,864
DATA 786,864,862,639,800,885,869,1189,869,869,703,319,383,319,525,414
DATA 383,559,639,511,639,527,335,575,639,319,351,607,319,958,639,604
DATA 639,607,474,454,447,639,607,831,607,607,511,500,278,500,525
' italic 10pt
DATA 358,307,514,818,500,818,767,257,409,409,511,767,170,778,307,511
DATA 511,511,511,511,511,511,511,511,511,511,307,307,778,767,778,511
DATA 767,743,704,716,755,678,653,774,743,386,525,769,627,897,743,767
DATA 678,767,729,562,716,743,743,999,743,743,613,307,358,307,525,368
DATA 358,511,460,414,511,414,307,460,511,307,307,460,302,818,562,465
DATA 511,460,422,409,332,537,460,664,464,486,409,500,278,500,525
' bold-italic 10pt
DATA 414,386,621,944,548,944,886,310,473,473,591,886,197,852,356,591
DATA 591,591,591,591,591,591,591,591,591,591,356,356,852,886,852,591
DATA 886,866,817,827,876,757,727,895,896,472,611,895,698,1073,896,855
DATA 787,855,859,650,796,881,866,1160,866,866,709,356,414,356,575,426
DATA 414,591,532,479,591,479,378,532,591,356,356,532,350,944,650,538
DATA 591,532,502,487,385,621,532,768,561,562,491,548,304,548,575
'

REM $STATIC
SUB Chr.Input (aci$)
' ----- character input -----
'  allow to use left/right arrows, back space and delete
'  presumably all other char's are visible and no longer than 2 lines
aci$ = RTRIM$(aci$)
lciold% = POS(0): mciold% = CSRLIN: cci% = LEN(aci$) + 1
LOCATE mciold%, lciold%, 1, 14, 15
DO
  LOCATE mciold%, lciold%: PRINT SPACE$(LEN(aci$) + 4);
  length% = LEN(aci$)
  LOCATE mciold%, lciold%: PRINT aci$;
'  LOCATE , , 1, 0, 7
  mci% = mciold%
  kci% = lciold% - 1
  IF cci% = length% + 1 THEN kci% = kci% + 1
  FOR ici% = 1 TO cci%
	kkci% = LEN(MID$(aci$, ici%, 1))
	IF kkci% = 2 AND kci% = 79 THEN kci% = kci% + 1
	kci% = kci% + kkci%
  NEXT ici%
  IF kci% > 80 THEN kci% = kci% - 80: mci% = mci% + 1
  IF cci% <> length% + 1 AND LEN(MID$(aci$, cci%, 1)) = 2 THEN kci% = kci% - 1
  LOCATE mci%, kci%
  DO: cci$ = INKEY$: LOOP WHILE cci$ = ""
 
  SELECT CASE cci$
	CASE CHR$(&H8) ' back-space
	  IF cci% <> 1 THEN
		aci$ = MID$(aci$, 1, cci% - 2) + MID$(aci$, cci%)
		cci% = cci% - 1
	  END IF
	CASE CHR$(&H0) + CHR$(&H4B)' left-arrow
	  IF cci% <> 1 THEN
		cci% = cci% - 1
	  END IF
	CASE CHR$(&H0) + CHR$(&H53)' delete
	  IF length% > 0 THEN
		aci$ = MID$(aci$, 1, cci% - 1) + MID$(aci$, cci% + 1)
	  END IF
	CASE CHR$(&H0) + CHR$(&H4D)' right-arrow
	  IF cci% < length% + 1 THEN
		cci% = cci% + 1
	  END IF
	CASE IS >= CHR$(&H20) ' visible characters
	IF (length% < nodemax% - 1) THEN
	  aci$ = MID$(aci$, 1, cci% - 1) + cci$ + MID$(aci$, cci%)
	  cci% = cci% + 1
	END IF
	END SELECT
toolong:
LOOP UNTIL cci$ = CHR$(&HD)
LOCATE , , 0, 0, 15
'
END SUB

SUB CursorDisplay (ppxx%, ppyy%)
'                                                     cursor mark on and off
xyshift% = INT(5! * wndwxy(wndwfctr%))
PUT (ppxx% - xyshift%, ppyy% - xyshift%), curs%, XOR
IF mouswitch% THEN MouseLocate ppyy%, ppxx%  '<=== when Mouse is used
aa = ppxx% * .25: bb = ppyy% * .25
ad = aa - INT(aa) + .001: bd = bb - INT(bb) + .001
aa = INT(aa): bb = INT(bb)
a$ = "<" + RIGHT$("  " + STR$(aa), 3) + ":"
a$ = a$ + RIGHT$("  " + STR$(bb), 3) + ">"
b$ = "(" + MID$(STR$(ad), 2, 3) + ":" + MID$(STR$(bd), 2, 3) + ")"
COLOR 7
LOCATE line2%, 38: PRINT a$;
LOCATE line1%, 38: PRINT b$;
PUT (ppxx% - 2, 3 + pyo%), markx%, XOR
PUT (3 + pxo%, ppyy% - 2), marky%, XOR
'
END SUB

SUB CursorMotion (keyin%)
'                                  cursor motion with cursor mark on and off
pxold% = px%: pyold% = py%
keyin% = KeyIsTyped%
IF job% <> 0 AND pyold% > pymax2% THEN
pyold% = pymax2%
CursorDisplay pxold%, pyold%
END IF
CursorDisplay pxold%, pyold%
CursorDisplay px%, py%
'
END SUB

SUB KeyDisplay
'                                         function-key instruction displayed
COLOR 3
FOR i% = 1 TO 5: LOCATE line2%, i% * 7 - 4: PRINT kky$(i%);
LOCATE line1%, i% * 7 - 4: PRINT kky$(i% + 10); : NEXT i%
SELECT CASE wtext%
   CASE 0
     LOCATE line1% + 1, 31: PRINT "T_Hide";
   CASE 1
     LOCATE line1% + 1, 31: PRINT "T_Show";
END SELECT

LOCATE line1% + 1, 24: PRINT " Zoom";
LOCATE line1% + 1, 47: PRINT "Redraw";
LOCATE line1% + 1, 55: PRINT "Reset";


COLOR 14: LOCATE line1% + 1, 64: PRINT "[CTRL+h=HELP]";
'COLOR 12: LOCATE line1% + 1, 64: PRINT "[QFIG ver. 1.1a]";

COLOR 10
LOCATE line1% + 1, 7: PRINT fill%;
LOCATE line1% + 1, 3: PRINT "Fil-P";
LOCATE line1% + 1, 10: PRINT chartype$(chartype%);
LOCATE line1% + 1, 17: PRINT charpt%;
LOCATE line1% + 1, 20: PRINT "pt."; : COLOR 3


FOR i% = 6 TO 7: LOCATE line2%, 5 + i% * 7: PRINT kky$(i%);
LOCATE line1%, 5 + i% * 7: PRINT kky$(i% + 10); : NEXT i%
FOR i% = 8 TO 10: COLOR 3: LOCATE line2%, 5 + i% * 7: PRINT kky$(i%);
COLOR 10: LOCATE line1%, 5 + i% * 7: PRINT kky$(i% + 10); : NEXT i%: COLOR 7
LOCATE line2% + func%, 2: COLOR 6: PRINT "@"; : COLOR 7

COLOR 6
LOCATE line3%, 20: PRINT "L-but(SPC)|R-but(RET)";
'LOCATE line3%, 19: PRINT "L-but=SPC/y|R-but=RET/n";
LOCATE line3%, 60: PRINT "L+R (DEL)"; : COLOR 7

CursorDisplay px%, py%
'
END SUB

FUNCTION KeyIsTouched$
'
IF mouswitch% THEN MousePoll row%, col%, lbut%, rbut% '<=== when Mouse is used
KeyIsTouched$ = INKEY$
'
END FUNCTION

FUNCTION KeyIsTyped%
'                                            which key has been typed so far
'            1:motion                    2:space or left button
'            3:return or right button    4:delete or both button (sensitive)
keyin% = 0
DO
  DO
	IF Help% = 1 AND mouswitch% <> 0 THEN
	  keyin% = 1: Help% = 0
	  EXIT DO
	END IF
	q$ = KeyIsTouched$
  LOOP UNTIL q$ <> "" OR row% <> py% OR col% <> px% OR lbut% <> 0 OR rbut% <> 0
  SELECT CASE q$
	CASE CHR$(&H0) + CHR$(UP)
	  IF py% - s% >= pymin% THEN py% = py% - s%: keyin% = 1
	CASE CHR$(&H0) + CHR$(DOWN)
	  IF py% + s% <= pymax% THEN py% = py% + s%: keyin% = 1
	CASE CHR$(&H0) + CHR$(LEFT)
	  IF px% - s% >= pxmin% THEN px% = px% - s%: keyin% = 1
	CASE CHR$(&H0) + CHR$(RIGHT)
	  IF px% + s% <= pxmax% THEN px% = px% + s%: keyin% = 1
	CASE CHR$(SP)
	  keyin% = 2
	CASE CHR$(CR)
	  keyin% = 3
	CASE CHR$(&H0) + CHR$(DEL)
	  keyin% = 4
	CASE CHR$(&H0) + CHR$(&H49) 'CTRL + PGUP
	  keyin% = 5
	CASE CHR$(&H0) + CHR$(&H51) 'CTRL + PGDN
	  keyin% = 6
	CASE CHR$(&H0) + CHR$(&H73) 'CTRL + LEFT
	  keyin% = 7
	CASE CHR$(&H0) + CHR$(&H74) 'CTRL + RIGHT
	  keyin% = 8
	CASE ""
	  IF mouswitch% THEN
		 IF lbut% <> 0 THEN
		  keyin% = 2
		  DO
	       MousePoll row%, col%, lbut%, rbut% '<=== when Mouse is used
		  LOOP UNTIL lbut% = 0 OR rbut% <> 0
		  IF rbut% <> 0 THEN keyin% = 4
		END IF
		IF rbut% <> 0 THEN
		  keyin% = 3
		  DO
	       MousePoll row%, col%, lbut%, rbut% '<=== when Mouse is used
		  LOOP UNTIL rbut% = 0 OR lbut% <> 0
		  IF lbut% <> 0 THEN keyin% = 4
		END IF
		IF row% - py% THEN
		  IF row% > pymax% THEN row% = pymax%
		  IF row% < pymin% THEN row% = pymin%
		  py% = row%
		  IF keyin% = 0 THEN keyin% = 1
		END IF
		IF col% - px% THEN
		  IF col% > pxmax% THEN col% = pxmax%
		  IF col% < pxmin% THEN col% = pxmin%
		  px% = col%
		  IF keyin% = 0 THEN keyin% = 1
		END IF
		IF keyin% = 4 THEN
		  DO
	       MousePoll row%, col%, lbut%, rbut% '<=== when Mouse is used
		  LOOP UNTIL rbut% = 0 AND lbut% = 0
		END IF
	  END IF
  END SELECT
      IF (job% <> 0) AND py% > pymax2% THEN py% = pymax2%
      IF (py% + texth% - 5) > pymax2% AND job% = 5 THEN py% = pymax2% - texth% + 5
IF Help% = 1 THEN keyin% = 1
IF ((keyin% > 4) AND (job% <> 0) AND (keyin% <> 9)) THEN keyin% = 0
LOOP UNTIL keyin% <> 0
KeyIsTyped% = keyin%
Help% = 0
'
END FUNCTION

SUB KeySwitch (ksw%)
'                                                          key on/off switch
kswitch% = ksw%   '<-- global definition ?
IF kswitch% = 1 THEN
  KEY(1) ON: KEY(2) ON: KEY(3) ON: KEY(4) ON: KEY(5) ON: KEY(6) ON
  KEY(7) ON: KEY(15) ON: KEY(16) ON: KEY(18) ON
  KEY(20) ON: KEY(21) ON: KEY(22) ON: KEY(23) ON: KEY(24) ON
ELSE
'  KEY(3) OFF:
  KEY(4) OFF: KEY(5) OFF: KEY(6) OFF
  KEY(7) OFF: KEY(15) OFF: KEY(16) OFF: KEY(18) OFF
  KEY(20) OFF: KEY(21) OFF: KEY(22) OFF: KEY(23) OFF: KEY(24) OFF
END IF
'
END SUB

SUB Preparation
'                                                               preparations
ltp%(0) = &HFFFF: ltp%(1) = &H8888: ltp%(2) = &HC3C3: ltp%(3) = &HA0A0
ltp$(0) = " Solid": ltp$(1) = "Dotted"
ltp$(2) = " Dash ": ltp$(3) = "D-Dash"

lth$(0) = " Thin ": lth$(1) = "Thick1": lth$(2) = "Thick2"

FOR i% = 1 TO 3: tlp$(i%) = ""
FOR j% = 1 TO 8: READ tt$: tt = VAL("&H" + tt$)
FOR k% = 1 TO 4: tlp$(i%) = tlp$(i%) + CHR$(tt): NEXT k%, j%, i%

nocheat% = 0: IF INSTR(COMMAND$, "/NC") <> 0 THEN nocheat% = 1

nofile% = 1: IF INSTR(COMMAND$, "/F") <> 0 THEN nofile% = 0

'nofile% = 0
wspec% = 0: IF INSTR(COMMAND$, "/S") <> 0 THEN wspec% = 1

ega% = 0: IF INSTR(COMMAND$, "/E") <> 0 THEN ega% = 1
'chartype$(0) = "Roman       ": chartype$(1) = "Bold        "
'chartype$(2) = "Italic      ": chartype$(3) = "Bold Italic "

chartype$(0) = " Roman": chartype$(1) = " Bold "
chartype$(2) = "Italic": chartype$(3) = "Bld-It"

'original KEEP

chartex$(0, 0) = "\xpt\rm ": chartex$(0, 1) = "\xpt\bf "
chartex$(0, 2) = "\xpt\it ": chartex$(0, 3) = "\xpt\FonttenBI "
chartex$(1, 0) = "\xiipt\rm ": chartex$(1, 1) = "\xiipt\bf "
chartex$(1, 2) = "\xiipt\it ": chartex$(1, 3) = "\xiipt\FonttwlBI "
charjtex$(0, 0) = "\tendm ": charjtex$(0, 1) = "\tendg "
charjtex$(1, 0) = "\twelvedm ": charjtex$(1, 1) = "\twelvedg "

'original end

chartype% = 0: charpt% = 12
chattr%(0, 0) = 7: chattr%(0, 1) = 0
chattr%(1, 0) = 11: chattr%(1, 1) = 6
chattr%(2, 0) = 7: chattr%(2, 1) = 11
chattr%(3, 0) = 11: chattr%(3, 1) = 10

' set by \wd \ht of \hbox at 10pt; 7/24/1992
jpitch% = 915: jheight(0) = .77088: jheight(1) = .77088
' set by \ht of height of "A" in each font at 10pt; 7/24/1992
eheight(0) = .68333: eheight(1) = .68611
eheight(2) = .68333: eheight(3) = .68611
'
RESTORE tex.pitch
FOR i% = 0 TO 94: READ epitch%(0, i%): NEXT i%
FOR i% = 0 TO 94: READ epitch%(1, i%): NEXT i%
FOR i% = 0 TO 94: READ epitch%(2, i%): NEXT i%
FOR i% = 0 TO 94: READ epitch%(3, i%): NEXT i%
'                      scriptsize up/down motion in dot (* point * 0.25 mm)
scrpt(0) = 0!: scrpt(1) = .5: scrpt(2) = -.2

Ins(0).L = SPACE$(15): Ins(0).R = SPACE$(15): Ins(0).D = SPACE$(15)
Ins(1).L = "    mid-pts set": Ins(1).R = "last pt. set   ": Ins(1).D = "cancel"
Ins(2).L = "circle cnt/rads": Ins(2).R = "ellps diag.pts.": Ins(2).D = "cancel"
Ins(3).L = "     end points": Ins(3).R = "on the arc     ": Ins(3).D = "cancel"
Ins(4).L = "  diagonal pts.": Ins(4).R = " diagonal pts. ": Ins(4).D = "cancel"
Ins(5).L = "       position": Ins(5).R = "       position": Ins(5).D = "cancel"
Ins(6).L = "    <--- / --->": Ins(6).R = "<----->        ": Ins(6).D = "cancel"
Ins(7).L = "  object select": Ins(7).R = "  region select": Ins(7).D = "cancel"
Ins(8).L = "  object select": Ins(8).R = "  region select ": Ins(8).D = "cancel"
Ins(9).L = "  displace node": Ins(9).R = "cut node        ": Ins(9).D = "cancel"
Ins(10).L = "  object select": Ins(10).R = "  region select ": Ins(10).D = "cancel"
Ins(11).L = "wrt hrzntl axis": Ins(11).R = "wrt vrtcl axius": Ins(11).D = "cancel"
Ins(12).L = "         rotate": Ins(12).R = "set(angle/obj) ": Ins(12).D = "cancel"
Ins(13).L = "  object select": Ins(13).R = "  region select": Ins(13).D = "cancel"

s% = 4: s1% = 1: px% = 320: py% = 200: mouswitch% = 0
pxo% = 0: pyo% = 0: inbox% = 0
func% = 0: func1% = 1: job% = 0: seljob% = 0: Help% = 0
nobj% = 0: ltype% = 0: thick% = 0: fill% = 0
xmin% = REGIONXMAX: xmax% = 0: ymin% = REGIONYMAX: ymax% = 0
pi = 4! * ATN(1!): group% = 1: margin% = 7

wndwfctr% = 0
wndwxy(0) = 1!: wndwxy(1) = 1.3125: wndwxy(2) = 1.8: wndwxy(3) = 2.2
IF ega% = 0 THEN
   windowx%(0) = 639: windowy%(0) = 479: texth% = 16
   scrtype% = 12: line1% = 29: line2% = 28: line3% = 27
ELSE
   windowx%(0) = 639: windowy%(0) = 349: texth% = 14
   scrtype% = 9: line1% = 24: line2% = 23: line3% = 22
END IF
FOR i% = 1 TO 3: windowx%(i%) = INT(CSNG(windowx%(0) + 1) * wndwxy(i%) - 1)
windowy%(i%) = INT(CSNG(windowy%(0) + 1) * wndwxy(i%) - 1): NEXT i%
pxmin% = margin%: pxmax% = windowx%(0) - margin%
pymin% = margin%: pymax% = windowy%(0) - margin%
pymax2% = windowy%(0) - texth% * 4 - 5 - margin%
winpy% = windowy%(0) - texth% * 4 - margin%
'                                                               cursor marks
SCREEN scrtype%
LINE (320, 195)-STEP(0, 10): LINE (315, 200)-STEP(10, 0)
GET (315, 195)-(325, 205), curs%: CLS
LINE (318, 195)-(322, 195): LINE (317, 196)-(323, 196)
LINE (317, 196)-(317, 197): LINE (323, 196)-(323, 197)
LINE (318, 196)-(318, 198): LINE (322, 196)-(322, 198)
LINE (320, 197)-(320, 200): LINE (319, 198)-(319, 200)
LINE (321, 198)-(321, 200)
LINE (315, 200)-(316, 200): LINE (324, 200)-(325, 200)
LINE (317, 201)-(318, 201): LINE (322, 201)-(323, 201)
LINE (318, 202)-(322, 202)
LINE (315, 204)-(316, 204): LINE (324, 204)-(325, 204)
LINE (317, 203)-(318, 203): LINE (322, 203)-(323, 203)
GET (315, 195)-(325, 205), curs1%: CLS                 'cursor mark for KILL
CIRCLE (323, 197), 2: CIRCLE (323, 203), 2
LINE (315, 196)-(323, 201): LINE (315, 204)-(323, 199)
LINE (316, 196)-(324, 201): LINE (316, 204)-(324, 199)
GET (315, 195)-(325, 205), curs2%: CLS                  'cursor mark for CUT

CIRCLE (3, 3), 3, 10: GET (0, 0)-(6, 6), mark%: CLS
LINE (0, 0)-(6, 6), 10, BF: CIRCLE (3, 3), 3, 0
GET (0, 0)-(6, 6), markg%: CLS

LINE (2, 0)-(4, 4), 6: LINE -(0, 4), 6: LINE -(2, 0), 6: PAINT (2, 3), 6
GET (0, 0)-(4, 4), markx%: CLS
LINE (0, 2)-(4, 0), 6: LINE -(4, 4), 6: LINE -(0, 2), 6: PAINT (3, 2), 6
GET (0, 0)-(4, 4), marky%: CLS

kky$(1) = " Line ": kky$(2) = " Curve": kky$(3) = "CrcEll"
kky$(4) = " Arc  ": kky$(5) = " Box  ": kky$(6) = " Poly "
kky$(7) = "Cl-Crv": kky$(8) = " Arrow"
kky$(9) = "String": kky$(10) = " File "
kky$(11) = " Move ": kky$(12) = " Copy ": kky$(13) = "Sym.cp"
kky$(14) = "Rotate": kky$(15) = " Edit ": kky$(16) = "DspCut"
kky$(17) = " Kill ": kky$(18) = " Solid"
kky$(19) = " Thin ": kky$(20) = "Pitch4"
kky$(21) = " 12pt.": kky$(21) = "Roman "
altpitch$ = "Pitch1"

IF nofile% = 1 THEN mpath% = 0: GOTO inputusersettings
'                                         input user-definable data settings
path0$ = ".;" + ENVIRON$("PATH")
DO
  mpath% = INSTR(path0$, ";")
  IF mpath% = 0 THEN
	path$ = path0$
	path0$ = ""
  ELSE
	path$ = LEFT$(path0$, mpath% - 1)
	path0$ = MID$(path0$, mpath% + 1)
  END IF
  IF path$ <> "" AND RIGHT$(path$, 1) <> "\" THEN path$ = path$ + "\"
  ifile$ = path$ + "qfig_set.dat"
  OPEN ifile$ FOR RANDOM AS #1
  IF LOF(1) = 0 THEN
	CLOSE #1
	KILL ifile$
  ELSE
	mpath% = -1
	EXIT DO
  END IF
LOOP UNTIL mpath% = 0

inputusersettings:
IF mpath% = 0 THEN
'                                                                    default
  arrowhead = 8!               'arrow = arrowhead + darrowhead * obj%(n%, 4)
  darrowhead = 1.5
  arrowdirect = pi / 9!                'arrow is directed to \pm arrowdirect
  arcarrowd = pi / 30!            'correction of inward direction on the arc
  dpattern$(1) = "6pt, 3pt"                           'dashpattern on PiCTeX
  dpattern$(2) = "10pt, 3pt, 2pt, 3pt"
  dpattern$(3) = "10pt, 3pt, 2pt, 3pt, 2pt, 3pt"
  filler%(0) = 0                                    'filler color on N-Graph
  filler%(1) = 2
  filler%(2) = 6
  filler%(3) = 1
  eepicpattern$(1) = "\dottedline{3}"
  eepicpattern$(2) = "\dashline[50]{10}"
  eepicpattern$(3) = "\dashline[50]{10}[2]"
  tpicshade$(1) = "[0.1]"
  tpicshade$(2) = "[0.4]"
  tpicshade$(3) = "[0.7]"
  hscroll% = 200
  vscroll% = 120
  interpolcurve% = 10
  interpolang% = 36    '5 degree
ELSE
  CLOSE #1
  OPEN ifile$ FOR INPUT AS #1
  arrowhead = VAL(Usetdata$)
  darrowhead = VAL(Usetdata$)
  arrowdirect = pi / VAL(Usetdata$)
  arcarrowd = pi / VAL(Usetdata$)
  dpattern$(1) = Usetdata$
  dpattern$(2) = Usetdata$
  dpattern$(3) = Usetdata$
  filler%(0) = VAL(Usetdata$)
  filler%(1) = VAL(Usetdata$)
  filler%(2) = VAL(Usetdata$)
  filler%(3) = VAL(Usetdata$)
  eepicpattern$(1) = Usetdata$
  eepicpattern$(2) = Usetdata$
  eepicpattern$(3) = Usetdata$
  tpicshade$(1) = Usetdata$
  tpicshade$(2) = Usetdata$
  tpicshade$(3) = Usetdata$
  hscroll% = VAL(Usetdata$)
  IF hscroll% <= 0 OR hscroll% > 200 THEN hscroll% = 200
  vscroll% = VAL(Usetdata$)
  IF vscroll% <= 0 OR vscroll% > 120 THEN vscroll% = 120
  interpolcurve% = VAL(Usetdata$)
  interpolang% = 180! / CSNG(VAL(Usetdata$))
 
  chartex$(0, 0) = Usetdata$ + " "
  chartex$(0, 1) = Usetdata$ + " "
  chartex$(0, 2) = Usetdata$ + " "
  chartex$(0, 3) = Usetdata$ + " "
  chartex$(1, 0) = Usetdata$ + " "
  chartex$(1, 1) = Usetdata$ + " "
  chartex$(1, 2) = Usetdata$ + " "
  chartex$(1, 3) = Usetdata$ + " "
 
  CLOSE #1
END IF
'
tpicshade% = 1
'
iomessages$(1) = "Load  picture data from file [.qfg]"
iomessages$(2) = "Merge picture data from file [.qfg]"
iomessages$(3) = "Save  this picture into file [.qfg] only"
iomessages$(4) = "Save picture in [.qfg] & 'PiCTeX'   code in [.tex]"
iomessages$(5) = "Save picture in [.qfg] & 'eepic'    code in [.tex]"
iomessages$(6) = "Save picture in [.qfg] & 'eepicemu' code in [.tex]"
iomessages$(7) = "Quit (Exit Program)"
'
END SUB

SUB SetInst (ninstr%)
'                       set instruction of left/right buttons (space/return)
COLOR 7
IF ninstr% > 0 THEN SWAP Ins(0), Ins(ninstr%)
LOCATE line3%, 4: PRINT Ins(0).L; : LOCATE line3%, 42: PRINT Ins(0).R;
LOCATE line3%, 70: PRINT Ins(0).D;
'
END SUB

FUNCTION Usetdata$
'                                               get a line and strip comment
DO
LINE INPUT #1, a$
a$ = LEFT$(a$, INSTR(a$, ";") - 1)
LOOP UNTIL a$ <> ""
i% = INSTR(a$, CHR$(9))
DO UNTIL i% = 0
  a$ = LEFT$(a$, i% - 1)
  i% = INSTR(a$, CHR$(9))
LOOP
Usetdata$ = LTRIM$(RTRIM$(a$))
'
END FUNCTION

