@echo off
:: This is a DOS batch file facilitating the usage of PS_VIEW---part 1
:: The purpose is to define PS_VIEW-oriented keyboard functions (e.g.,
:: instead of writing `l' and pressing [Enter] it suffices to press
:: the [Left Arr] key). ANSI.SYS is assumed to be installed.
::
:: Authors: Wietse Dol and Erik Frambach
::          with a contribution of Bogus\l{}aw Jackowski and Piotr Pianowski
::
:: History:
:: Version 1.00 (Thursday, May 4th, 1995)
::         * first official release
:: Version 1.01 (Friday, October 27th, 1995)
::         * aliases for `vu' and `vd' changed following Tadeus Sheibak's
::           advice: instead of [Alt + Open Bracket] and [Alt + Close Bracket]
::           they now read [Alt + Period] and [Alt + Comma]; this convention
::           is supposed to be memorable because period and greater appear
::           on the same key, and comma and less also.
::
:: Axioms:
::   A0) letters and digits must not be redefined,
::   A1) option /x of ANSI.SYS must not be used (no extended keyboard),
::   A2) / * + and - must not be redefined,
::   A3) single letters commands are not to be ``abbreviated''
::       using [Alt] or [Ctrl] combinations,
::   A4) the screen should not scroll during loading the ANSI definitions.
::
:: From A1 and A2 it follows that keypad / * + and - must be left intact.
:: From A4 it follows that echo commands should end with sequence `[1A'.
::
:: ======================================================================
::            LIST OF PS_VIEW COMMANDS + SYNOPSIS + ALIASES
:: ======================================================================
::
:: Remark 1: [Print Scr] is available only with [Ctrl].
:: Remark 2: In curly braces appear optional parameters.
:: Remark 3: Sequences in square braces (aliases) do not need
::           pressing [Enter], but they require ANSI.SYS to be installed.
::
::   (FILE_NAME) a   apply new picture
::   (FILE_NAME) o   open new picture (equivalent to `a')
::   (FILE_NAME) ap  apply new paged document
::   (FILE_NAME) op  open new paged picture (equivalent to `ap')
::               c   redraw current picture
:: ==>               ANSI.SYS alias: [F10]
::               i   view picture with initial parameter settings
:: ==>               ANSI.SYS alias: [F11]
::               w   view whole picture
:: ==>               ANSI.SYS alias: [F12]
:: {(FILE_NAME)} wr  write the restart information
:: ==>               ANSI.SYS alias: {(FILE_NAME)} [F2]
:: {(FILE_NAME)} rr  read conditionally the restart information
:: ==>               ANSI.SYS alias: {(FILE_NAME)} [F3]
::        {PAGE} pn  go to the specified page
::        {PAGE} np  equivalent to `pn'
:: ==> ?             ANSI.SYS alias: {PAGE} [F4]
::               pf  go to the first page
::               fp  equivalent to `pf'
:: ==>               ANSI.SYS alias: [Home]
::               pl  go to the last page
::               lp  equivalent to `pl'
:: ==>               ANSI.SYS alias: [End]
::        {INCR} n   go to next page
:: ==>               ANSI.SYS alias: {INCR} [PgDn]
::        {INCR} p   go to previous page
:: ==>               ANSI.SYS alias: {INCR} [PgUp]
::         {MAG} m   set magnification factor
::               g   draw grid
::   {HOR} {VER} v   view magnified and shifted picture
::   {HOR} {VER} go  shift picture (``go to specified position''; equivalent
::                   to `v' with temporary scaling=1)
:: ==>               ANSI.SYS alias: {HOR} {VER} [Tab]
::   {HOR} {VER} vu  view magnified and shifted picture (equivalent to `v')
:: ==>               ANSI.SYS alias: {HOR} {VER} [Alt + Period]
::   {HOR} {VER} vd  view diminished and shifted picture (equivalent to `v'
::                   with temporary scaling=1/MAG)
:: ==>               ANSI.SYS alias: {HOR} {VER} [Alt + Comma]
::       {SHIFT} s   set shift
::       {SHIFT} l   shift picture left
:: ==>               ANSI.SYS alias: {SHIFT} [Left Arr]
::       {SHIFT} r   shift picture right
:: ==>               ANSI.SYS alias: {SHIFT} [Right Arr]
::       {SHIFT} u   shift picture up
:: ==>               ANSI.SYS alias: {SHIFT} [Up Arr]
::       {SHIFT} d   shift picture down
:: ==>               ANSI.SYS alias: {SHIFT} [Down Arr]
::        {STEP} ro  rotate picture counterclockwise by STEP*90
::                   (i.e., clockwise for STEP<0)
:: ==>               ANSI.SYS alias: {STEP} [Shift + Tab]
::               hf  flip picture horizontaly
::               vf  flip picture verticaly
::        {INCR} un  undo previous picture
:: ==>               ANSI.SYS alias: {INCR} [Del]
::        {INCR} re  redo undone picture
:: ==>               ANSI.SYS alias: {INCR} [Ins]
::               fr  show frame (approximate printing area)
:: {(FILE_NAME)} pr  print screen or send it to a file
:: ==>               ANSI.SYS alias: {(FILE_NAME)} [Ctrl + Print Scr]
::   DEVICE_NAME prs select printer, to be used by `pr'
::            r1024  set screen resolution -- for TVGA and TSENG only
::            r800   set screen resolution -- for TVGA and TSENG only
::            r640   set screen resolution -- for TVGA and TSENG only
::             rsc   reset screen (reset text cursor)
:: ==>               ANSI.SYS alias: [F9]
::               e   attempt to recover from error
::               q   quit saving the restart information
:: ==>               ANSI.SYS aliases: [Ctrl + Q], [Alt + Q] or [Alt + F4]
::               x   exit
:: ==>               ANSI.SYS aliases: [Ctrl + X], [Alt + X] or [Esc]
::             hlp   help
:: ==>               ANSI.SYS aliases: [Alt + H], [F1]
::
:: ======================================================================
::                        ANSI.SYS DEFINITIONS
:: ======================================================================
::
:: [F9], [F10], [F11], [F12]
echo [0;67;" rsc";13p[0;68;" c";13p[0;133;" i";13p[0;134;" w";13p[1A
:: [F2], [F3], [F4]
echo [0;60;" wr";13p[0;61;" rr";13p[0;62;" pn";13p[1A
:: [PgDn], [PgUp]
echo [0;81;" n";13p[0;73;" p";13p[1A
:: [Home], [End]
echo [0;71;" fp";13p[0;79;" lp";13p[1A
:: [Alt + Period] and [Alt + Comma], i.e., [Alt + Greater], [Alt + Less]
echo [0;52;" vu";13p[0;51;" vd";13p[1A
:: [Left Arr], [Right Arr], [Up Arr], [Down Arr]
echo [0;75;" l";13p[0;77;" r";13p[0;72;" u";13p[0;80;" d";13p[1A
:: [Tab], [Shift + Tab]
echo [9;" go";13p[0;15;" ro";13p[1A
:: [Del], [Ins]
echo [0;83;" un";13p[0;82;" re";13p[1A
:: [Ctrl + Print Scr]
echo [0;114;" pr";13p[1A
:: [Ctrl + X] = [Alt + X] = [Esc]
echo [24;" x";13p[0;45;" x";13p[27;" x";13p[1A
:: [Ctrl + Q] = [Alt + Q] = [Alt + F4]
echo [17;" q";13p[0;16;" q";13p[0;107;" q";13p[1A
:: [Alt + H] = [F1]
echo [0;35;" hlp";13p[0;59;" hlp";13p[1A
