/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pp4;

import de.tu_darmstadt.sp.paul.PDFArray;
import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFOutputStream;
import de.tu_darmstadt.sp.paul.PDFStream;
import de.tu_darmstadt.sp.paul.PDFString;
import de.tu_darmstadt.sp.paul.PDFTextString;
import de.tu_darmstadt.sp.pp4.PP4Chunks;
import de.tu_darmstadt.sp.pp4.PP4Exception;
import de.tu_darmstadt.sp.pp4.PP4Handler;
import de.tu_darmstadt.sp.pudl.Document;
import de.tu_darmstadt.sp.pudl.PDFRectangle;
import de.tu_darmstadt.sp.pudl.Page;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;

public class PP4Pages {
    private Document inpdf;
    private Page inpage = null;
    private String progid = null;
    private String pageArguments = null;
    private StringBuffer streambuf = null;
    private int numpages = 0;
    private String curnum = null;
    private String inpdfname = null;
    private String outpdfname = null;
    private int verboseLevel = 0;
    private int charsinline = 0;
    private int compress = 1;
    private PDFArray destNames = null;
    private PrintStream os = null;
    private HashMap handlerhash = new HashMap(10);
    private boolean doCopy = true;
    private PP4Chunks chunks;

    public PP4Pages(String infile, String outfile, PrintStream outs, String id) {
        this.inpdfname = infile;
        this.outpdfname = outfile;
        if (this.os == null) {
            this.os = outs;
        }
        this.progid = id;
    }

    public void addBgStream(Object stream) {
        if (stream instanceof PDFStream) {
            this.chunks.addBG((PDFStream)stream);
        }
    }

    public void addCommentProcessor(PP4Handler hd) {
        String pattern = hd.pattern();
        hd.setPagesRef(this);
        if (this.verboseLevel > 3) {
            this.os.println("register pattern " + pattern);
        }
        if (this.handlerhash.get(pattern) != null) {
            this.os.println("Warning: duplicate pattern " + pattern + " not registered.");
            return;
        }
        this.handlerhash.put(pattern, hd);
    }

    public void append(String contents) {
        this.streambuf.append(contents);
    }

    public void clearStreamBuffer() {
        this.streambuf = new StringBuffer(8192);
    }

    private void destNamesTraversal(PDFDictionary initial, PDFArray collect) {
        PDFObject o = initial.get(PDFName.KIDS);
        if (o != null && o instanceof PDFArray) {
            PDFArray a = (PDFArray)o;
            int i = 0;
            while (i < a.size()) {
                PDFObject next = a.get(i);
                if (next == null) {
                    return;
                }
                if (next instanceof PDFDictionary) {
                    PDFObject nxtlevel = ((PDFDictionary)next).get(PDFName.KIDS);
                    if (nxtlevel != null) {
                        this.destNamesTraversal((PDFDictionary)next, collect);
                    } else {
                        nxtlevel = ((PDFDictionary)next).get(PDFName.NAMES);
                        if (nxtlevel != null && nxtlevel instanceof PDFArray) {
                            PDFArray toCopy = (PDFArray)nxtlevel;
                            int j = 0;
                            while (j < toCopy.size()) {
                                collect.add(toCopy.get(j));
                                ++j;
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void dumpDestNames(String msg, PDFArray names) {
        if (this.verboseLevel > 5) {
            this.os.println(msg);
            int i = 0;
            while (i < names.size()) {
                this.os.println(String.valueOf(String.valueOf(names.get(i))));
                ++i;
            }
        }
    }

    public PP4Chunks getChunks() {
        return this.chunks;
    }

    public boolean getCopyingState() {
        return this.doCopy;
    }

    private PDFArray getDestNames(Document inpdf) {
        if (inpdf == null) {
            return null;
        }
        PDFDictionary rd = inpdf.getRoot();
        if (rd == null) {
            return null;
        }
        PDFObject o = rd.get("Names");
        if (o == null) {
            return null;
        }
        if (!(o instanceof PDFDictionary)) {
            return null;
        }
        rd = (PDFDictionary)o;
        o = rd.get("Dests");
        if (o == null) {
            return null;
        }
        if (!(o instanceof PDFDictionary)) {
            return null;
        }
        rd = (PDFDictionary)o;
        PDFObject tryo = rd.get(PDFName.KIDS);
        if (tryo != null) {
            o = new PDFArray();
            if (tryo instanceof PDFArray) {
                this.destNamesTraversal(rd, (PDFArray)o);
                if (rd.get(PDFName.forString("Limits")) != null) {
                    rd.remove(PDFName.KIDS);
                } else {
                    PDFObject nxtDict = ((PDFArray)tryo).get(0);
                    if (nxtDict != null && nxtDict instanceof PDFDictionary) {
                        rd = (PDFDictionary)nxtDict;
                    }
                }
                rd.put(PDFName.NAMES, o);
                return (PDFArray)o;
            }
        } else {
            o = rd.get("Names");
            if (o == null) {
                return null;
            }
            if (o instanceof PDFArray) {
                return (PDFArray)o;
            }
        }
        return null;
    }

    public float[] getPageBounds() {
        PDFRectangle mbox = null;
        mbox = this.inpage.getMediaBox();
        float[] bounds = new float[]{(float)mbox.getLLX().value(), (float)mbox.getLLY().value(), (float)mbox.getURX().value(), (float)mbox.getURY().value()};
        return bounds;
    }

    private String getPageDestNum(Page page) {
        Object val = null;
        if (this.destNames == null) {
            return null;
        }
        if (page == null) {
            return null;
        }
        int numelem = this.destNames.size();
        int inx = numelem - 1;
        while (inx > 0) {
            String s;
            PDFObject p;
            PDFObject o = this.destNames.get(inx);
            if (o != null && o instanceof PDFDictionary) {
                o = ((PDFDictionary)o).get("D");
            }
            if (o != null && o instanceof PDFArray && (p = ((PDFArray)o).get(0)) == page.getRepresentation() && (o = this.destNames.get(inx - 1)) instanceof PDFTextString && (s = o.toString()).startsWith("first.")) {
                return s;
            }
            inx -= 2;
        }
        return null;
    }

    public void makeNewPage(String arguments) {
        this.chunks.addNumber(this.curnum);
        if (this.streambuf.length() == 0) {
            this.streambuf.append("1 0 0 1 0 0 cm");
        }
        this.chunks.addStream(this.inpage, this.streambuf);
        this.clearStreamBuffer();
        this.chunks.next();
        if (arguments != null && arguments.length() > 0) {
            if ((arguments = arguments.trim()).length() > 7 && arguments.startsWith("trans='") && arguments.endsWith("'")) {
                this.chunks.addArguments(arguments.substring(7, arguments.length() - 1));
            } else {
                this.os.println("Warning: argument " + arguments + " not processed.");
            }
        }
    }

    public Object makeStream(String txt) {
        PDFOutputStream stream = new PDFOutputStream();
        if (this.compress > 0) {
            stream.setFilter(PDFName.FLATEDECODE);
        }
        OutputStream out = stream.getOutputStream();
        try {
            out.write(txt.getBytes());
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        stream.closeOutputStream();
        return stream;
    }

    public void prepend(String context) {
        this.streambuf.insert(0, context);
    }

    private void scanPageStream(InputStream theStream) {
        try {
            String current;
            InputStreamReader isr = new InputStreamReader(theStream, "ISO8859_1");
            BufferedReader readstream = new BufferedReader(isr);
            while ((current = readstream.readLine()) != null) {
                if (current.length() < 1) continue;
                if (current.charAt(0) == '%') {
                    String arguments;
                    int spacepos;
                    if (this.verboseLevel > 4) {
                        this.os.println("Found comment:[" + current + "]");
                    }
                    if ((spacepos = current.indexOf(32)) == -1) {
                        spacepos = current.length();
                        arguments = "";
                    } else {
                        arguments = current.substring(spacepos + 1, current.length());
                    }
                    String command = current.substring(0, spacepos);
                    PP4Handler hd = (PP4Handler)this.handlerhash.get(command);
                    if (hd != null) {
                        try {
                            hd.doit(command, arguments);
                        }
                        catch (PP4Exception e) {
                            this.os.println(e);
                        }
                        continue;
                    }
                    if (!this.doCopy) continue;
                    this.append(String.valueOf(current) + "\n");
                    continue;
                }
                if (!this.doCopy) continue;
                this.append(String.valueOf(current) + "\n");
            }
            this.chunks.addStream(this.inpage, this.streambuf);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    public void setCompressLevel(int level) {
        this.compress = level;
    }

    public void setCopyingState(boolean state) {
        this.doCopy = state;
    }

    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
    }

    private void traceprogress(String txt, int n) {
        if (n > 0) {
            this.os.print(String.valueOf(txt) + n);
            ++this.charsinline;
            int no = n;
            while (no > 0) {
                ++this.charsinline;
                no /= 10;
            }
        } else if (this.charsinline > 72) {
            this.os.println(txt);
            this.charsinline = 0;
        } else {
            this.os.print(txt);
            this.charsinline += txt.length();
        }
    }

    public void work() {
        try {
            PDFObject creator;
            if (this.verboseLevel > 1) {
                this.os.println("Reading and parsing input file...");
            }
            this.inpdf = new Document(this.inpdfname);
            this.destNames = this.getDestNames(this.inpdf);
            this.chunks = new PP4Chunks(this.inpdf, this.destNames, this.compress);
            this.numpages = this.inpdf.numPages();
            if (this.verboseLevel > 1) {
                this.os.println("Got it (" + this.numpages + " Pages).");
            }
            int pageno = 1;
            while (pageno <= this.numpages) {
                this.inpage = this.inpdf.getPage(1);
                if (this.verboseLevel > 0) {
                    this.traceprogress("[", pageno);
                }
                this.curnum = this.getPageDestNum(this.inpage);
                this.clearStreamBuffer();
                PP4Handler hd = (PP4Handler)this.handlerhash.get("BOPHOOK");
                if (hd != null) {
                    try {
                        hd.doit("BOPHOOK", String.valueOf(pageno));
                    }
                    catch (PP4Exception e) {
                        this.os.println(e);
                    }
                }
                this.scanPageStream(this.inpage.getContentStream());
                hd = (PP4Handler)this.handlerhash.get("EOPHOOK");
                if (hd != null) {
                    try {
                        hd.doit("EOPHOOK", String.valueOf(pageno));
                    }
                    catch (PP4Exception e) {
                        this.os.println(e);
                    }
                }
                this.chunks.write(this.inpage);
                this.inpdf.removePage(1);
                if (this.verboseLevel > 0) {
                    this.traceprogress("]", 0);
                }
                ++pageno;
            }
            PDFObject openAction = this.inpdf.getRoot().get("OpenAction");
            PDFObject startpage = null;
            if (openAction != null && openAction instanceof PDFDictionary) {
                startpage = ((PDFDictionary)openAction).get("D");
            }
            if (openAction != null && openAction instanceof PDFArray) {
                startpage = openAction;
            }
            if (startpage != null) {
                if (startpage instanceof PDFArray) {
                    ((PDFArray)startpage).remove(0);
                    ((PDFArray)startpage).add(0, this.inpdf.getPage(1).getRepresentation());
                } else {
                    startpage = new PDFArray();
                    ((PDFArray)startpage).add(0, this.inpdf.getPage(1).getRepresentation());
                    ((PDFArray)startpage).add(1, PDFName.FIT);
                    ((PDFDictionary)openAction).put("D", startpage);
                }
            }
            if ((creator = this.inpdf.getInfo().get("Producer")) != null) {
                this.inpdf.getInfo().put("Producer", (PDFObject)new PDFTextString(String.valueOf(((PDFString)creator).toString()) + " extended by " + this.progid));
            }
            if (this.verboseLevel > 0) {
                this.os.println("\nWriting modified output file...");
            }
            this.inpdf.write(this.outpdfname);
            if (this.verboseLevel > 0) {
                this.os.println("Done.");
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }
}

