/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;

public class UnixDomainSocket
extends Socket {
    public static final int AF_UNIX = 1;
    public static final int SOCK_STREAM;
    public static final int PROTOCOL = 0;
    String path;
    InputStream is;
    OutputStream os;
    SockAddr sockaddr;
    int fd;

    public static native int socket(int var0, int var1, int var2) throws LastErrorException;

    public static native int connect(int var0, SockAddr var1, int var2) throws LastErrorException;

    public static native int recv(int var0, byte[] var1, int var2, int var3) throws LastErrorException;

    public static native int send(int var0, byte[] var1, int var2, int var3) throws LastErrorException;

    public static native int close(int var0) throws LastErrorException;

    public static native String strerror(int var0);

    static String formatError(LastErrorException lee) {
        try {
            return UnixDomainSocket.strerror(lee.getErrorCode());
        }
        catch (Throwable t) {
            return lee.getMessage();
        }
    }

    public UnixDomainSocket(String path) throws IOException {
        if (Platform.isWindows() || Platform.isWindowsCE()) {
            throw new IOException("Unix domain sockets are not supported on Windows");
        }
        this.path = path;
        this.sockaddr = new SockAddr(path);
        try {
            this.fd = UnixDomainSocket.socket(1, SOCK_STREAM, 0);
        }
        catch (LastErrorException lee) {
            throw new IOException("native socket() failed : " + UnixDomainSocket.formatError(lee));
        }
    }

    @Override
    public void close() throws IOException {
        try {
            UnixDomainSocket.close(this.fd);
            this.fd = -1;
        }
        catch (LastErrorException lee) {
            throw new IOException("native close() failed : " + UnixDomainSocket.formatError(lee));
        }
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        try {
            int ret = UnixDomainSocket.connect(this.fd, this.sockaddr, this.sockaddr.size());
            if (ret != 0) {
                throw new IOException(UnixDomainSocket.strerror(Native.getLastError()));
            }
        }
        catch (LastErrorException lee) {
            throw new IOException("native connect() failed : " + UnixDomainSocket.formatError(lee));
        }
        this.is = new UnixSocketInputStream();
        this.os = new UnixSocketOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public void setTcpNoDelay(boolean b) {
    }

    @Override
    public void setKeepAlive(boolean b) {
    }

    @Override
    public void setReceiveBufferSize(int size) {
    }

    @Override
    public void setSendBufferSize(int size) {
    }

    @Override
    public void setSoLinger(boolean b, int i) {
    }

    @Override
    public void setSoTimeout(int timeout) {
    }

    @Override
    public void shutdownInput() {
    }

    @Override
    public void shutdownOutput() {
    }

    static {
        int n = SOCK_STREAM = Platform.isSolaris() ? 2 : 1;
        if (Platform.isSolaris()) {
            System.loadLibrary("nsl");
            System.loadLibrary("socket");
        }
        if (!Platform.isWindows() && !Platform.isWindowsCE()) {
            Native.register("c");
        }
    }

    class UnixSocketOutputStream
    extends OutputStream {
        UnixSocketOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                int size = UnixDomainSocket.send(UnixDomainSocket.this.fd, b, len, 0);
                if (size != len) {
                    throw new IOException("can't write " + len + "bytes");
                }
            }
            catch (LastErrorException lee) {
                throw new IOException("native write() failed : " + UnixDomainSocket.formatError(lee));
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }
    }

    class UnixSocketInputStream
    extends InputStream {
        UnixSocketInputStream() {
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int size = UnixDomainSocket.recv(UnixDomainSocket.this.fd, b, len, 0);
                return size;
            }
            catch (LastErrorException lee) {
                throw new IOException("native read() failed : " + UnixDomainSocket.formatError(lee));
            }
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int bytesRead = this.read(b);
            if (bytesRead == 0) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }

    public static class SockAddr
    extends Structure {
        public short sun_family = 1;
        public byte[] sun_path;

        public SockAddr(String sunPath) {
            byte[] arr = sunPath.getBytes();
            this.sun_path = new byte[arr.length + 1];
            System.arraycopy(arr, 0, this.sun_path, 0, Math.min(this.sun_path.length - 1, arr.length));
            this.allocateMemory();
        }

        @Override
        protected List getFieldOrder() {
            return Arrays.asList("sun_family", "sun_path");
        }
    }
}

