#!/usr/bin/perl -w
use strict;

use Getopt::Long;

my $help = 0;
my $max = 1;
my $outfile = 'chmout';
my $namefile = 0;
my $ext = 'jpg';

GetOptions(
	   "help" => \$help,
	   "n=i" => \$max,
	   "format=s" => \$ext,
	   "outfile=s" => \$outfile,
	   "namefile!" => \$namefile
	   );

if ($help or scalar(@ARGV)==0 ) {
    print <<EOH;
	
makePics.pl is a script to convert documents with OCHEM formula files
into EPS and other graphics formats.

Usage:
makePics.pl [--n=<n>] [--outfile=<outfile>] [--[no]namefile]
            [--format=<format>] <infile>

    --n=<n> sets the number of formulae to process (should be as big as
           there are formula in your document)
    --outfile=<outfile> sets the output file base name, appends also the
           running number to this base name
    --namefile uses the file <infile>.names for naming the resulting EPS-
           and other picture files.
    --format=<format> sets the output format the EPS should be converted into.
           use the extension specifications (jpg, png ...) ImageMagick
           use to determine the format.

Defaults:
    --outfile=$outfile
    --format=$ext
    --n=$max
    --nonamefile

EOH
    exit(0);
}

my $infile = $ARGV[0];

if ($namefile) {
    my $i = 0;
    open(NAMES, "$infile.names") or die "cannot find names file $namefile.names";
    while (my $name = <NAMES>) {
	chomp($name);
	$i++;
	print "converting $i. formula of $infile [$name] into $name.eps and $name.$ext ...\n";
	system("dvips -E -n 1 -p $i -o $name.eps $infile");
	system("convert $name.eps $name.$ext");
	if ($ext eq 'png') {
	    system("mv $name.png.0 $name.png");
	    system("rm $name.png.1");
	}
    }
    close(NAMES);
} else {
    for (my $i=1; $i<=$max; $i++) {
	print "converting $i. formula of $infile into $outfile$i.eps and $outfile$i.$ext ...\n";
	system("dvips -E -n 1 -p $i -o $outfile$i.eps $infile");
	system("convert $outfile$i.eps $outfile$i.$ext");
    }
}


