/* l2xiprse.h  for LTX2X interpreter parser module */
/* BASED ON: parser.h  (unaltered except for common names) */

#ifndef parser_h
#define parser_h

#include "l2xicmon.h"
#include "l2xisymt.h"

/* users of a variable */

typedef enum {
  EXPR_USE, TARGET_USE, VARPARM_USE,
} USE;

/* FUNCTIONS */

TYPE_STRUCT_PTR expression();
TYPE_STRUCT_PTR variable();
TYPE_STRUCT_PTR routine_call();
TYPE_STRUCT_PTR base_type();
BOOLEAN         is_assign_type_compatible();

/* MACROS for parsing */

/* if_token_get  if token = token_code, get the next token */

#define if_token_get(token_code)       \
        if (token == token_code) get_token()

/* if_token_get_else_error if token = token code, get next token, else error */

#define if_token_get_else_error(token_code, error_code) \
        if (token == token_code) get_token();           \
        else error(error_code)

/* ANALYSIS routine calls */
/* Unless the following statements are preceeded by #define analyze */
/* calls to the analysis routines are not compiled.                 */

#ifndef analyze
#define analyze_const_defn(idp)
#define analyze_var_decl(idp)
#define analyze_type_defn(idp)
#define analyze_routine_header(idp)
#define analyze_block(idp)
#endif

#endif
