/* Environment.h
 *
 * The environment is the current set up of the page in terms of font type,
 * page number, and many other general numbers to keep track of.
 *
 * Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
 * edit and use as long as this copyright statement remains intact.
 *
 */

#include "Parameter.h"

class Environment {
 public:
   // MAKE SURE TO UPDATE THE parms[] array initialization
   // in Environment::Environment
   enum ParamTypes {     //  "Counter" must be first so it "reverts" first.
      PCounter, PDocument, PFont, PJustify, PLength, LastType
   };

   Environment();
   Environment(Environment *);
   ~Environment();
   void set(int, int, float, char *);
   void revert(Environment *);
   Param* get_param(int);

   float get(int, int, char *);
 private:
   // Same order as enumerator ParamTypes
   Param *params[LastType];
};
