program pgn2pgn;
{$m 65520,0,600000}
uses
  ch_ppgn, ch_files, ch_parse, crt, dos;

var
  game_numb, not_printed_games : longint;
  source, target: sourcetype;
  target_f: text;
  game : gametype;
  i : integer;


begin
  io_test;
  writeln;
  writeln('Carsten Hansen, CH0506@HDC.HHA.DK, any comment welcome');
  writeln;
  writeln('SYNTAX: PGN2PGN source-file target-file');
  writeln;

  if pos('-SHORT',upcasestr(all_params))=0 then
    use_short_notation:=false
  else
    use_short_notation:=true;

  if get_paramcount=0 then
  begin
    write('Type name of old PGN-file:       ');
    readln(source.name);
    target.name:='';
    write('Type name of new PGN-file:       ');
    readln(target.name);
  end
  else if get_paramcount=1 then
  begin
    source.name:=get_paramstr(1);
    target.name:='';
  end
  else
  begin
    source.name:=get_paramstr(1);
    target.name:=get_paramstr(2);
  end;

  if not file_exist(source.name) then
  begin
    remove_ext(source.name);
    source.name:=source.name+'.pgn';
  end;

  if file_exist(source.name) then
  begin
    find_path(target.name,target.path);
    open_file_for_read(source.game,source.name);
    io_test;
    if target.name='' then
      assign(target_f,'')
    else
    if pos(copy(target.name,1,3),' prn PRN')>0 then
      assign(target_f,'PRN')
    else
    begin
      if (pos('.',target.name)=0) then
        target.name:=target.name+'.pgn';
      assign(target_f,target.path+target.name);
      if file_exist(target.path+target.name) then
        erase(target_f);
    end;
    io_test;
    rewrite(target_f);
    io_test;  io_error:=not(copyerror=0);
    game_numb:=0;
    not_printed_games:=0;
    writeln;
    if not io_error then
    begin
      while (not io_error) and (not source.game.eof) and (not keypressed) do
      begin
        read_pgn(source.game,game);
        if (not game.illegal_move) and
        not (source.game.eof and (game.numb_of_moves=0)) then
        begin
          print_pgn(target_f,game);
          inc(game_numb);
        end
        else
        begin
          if not (source.game.eof and (game.numb_of_moves=0)) then
          begin
            inc(not_printed_games);
            inc(game_numb);
          end;
        end;

        gotoxy(10,wherey);
        write(game_numb,'  Games examined  ',
              not_printed_games,'  Games omitted');
      end;
    end
    else
    begin
      writeln('IO-error while opening ',source.name);
    end;

    close_read_file(source.game);
    close(target_f);
  end
  else
  begin
    writeln(source.name,' Does not exist');
  end;
end.

