{$N-,V-,W-,G+}

Unit wbib3d;

interface

Uses
  WinTypes,WinProcs,bibvars;


Var
  Ctl3dv2Active: boolean;

function  Ctl3dSubclassDlg(HWindow: HWnd; GrBits : word): bool;
function  Ctl3dSubclassDlgEx(HWindow: HWnd; GrBits : longint): bool;
function  Ctl3dGetVer: word;
function  Ctl3dEnabled: bool;
function  Ctl3dCtlColor(DC: HDC; Color: TColorRef): HBrush;
function  Ctl3dCtlColorEx(Message, wParam: word; lParam: longint): HBrush;
function  Ctl3dColorChange: bool;
function  Ctl3dSubclassCtl(HWindow: HWnd): bool;
function  Ctl3dDlgFramePaint(HWindow: HWnd; Message, wParam: word; lParam: longint): longint;
function  Ctl3dAutoSubclass(Instance: THandle): bool;
function  Ctl3dRegister(Instance: THandle): bool;
function  Ctl3dUnregister(Instance: THandle): bool;
procedure Ctl3dWinIniChange;

function  Load3dDll: boolean;
procedure Unload3dDll;

implementation

type
  TCtl3dSubclassDlg   = function(HWindow: HWnd; GrBits : word): bool;
  TCtl3dSubclassDlgEx = function(HWindow: HWnd; GrBits : longint): bool;
  TCtl3dGetVer        = function: word;
  TCtl3dEnabled       = function: bool;
  TCtl3dCtlColor      = function(DC: HDC; Color: TColorRef): HBrush;
  TCtl3dCtlColorEx    = function(Message, wParam: word; lParam: longint): HBrush;
  TCtl3dColorChange   = function: bool;
  TCtl3dSubclassCtl   = function(HWindow: HWnd): bool;
  TCtl3dDlgFramePaint = function(HWindow: HWnd; Message, wParam: word; lParam: longint): longint;
  TCtl3dAutoSubclass  = function(Instance: THandle): bool;
  TCtl3dRegister      = function(Instance: THandle): bool;
  TCtl3dUnregister    = function(Instance: THandle): bool;
  TCtl3dWinIniChange  = procedure;

var
  Ctl3dModule: THandle;

  FCtl3dSubclassDlg  : TFarProc;
  FCtl3dSubclassDlgEx: TFarProc;
  FCtl3dGetVer       : TFarProc;
  FCtl3dEnabled      : TFarProc;
  FCtl3dCtlColor     : TFarProc;
  FCtl3dCtlColorEx   : TFarProc;
  FCtl3dColorChange  : TFarProc;
  FCtl3dSubclassCtl  : TFarProc;
  FCtl3dDlgFramePaint: TFarProc;
  FCtl3dAutoSubclass : TFarProc;
  FCtl3dRegister     : TFarProc;
  FCtl3dUnregister   : TFarProc;
  FCtl3dWinIniChange : TFarProc;

function Ctl3dSubclassDlg(HWindow: HWnd; GrBits : word): bool;
begin
  if not Ctl3dv2Active then Ctl3dSubclassDlg:=false
  else Ctl3dSubclassDlg:=TCtl3dSubclassDlg(FCtl3dSubclassDlg)(HWindow,GrBits);
end;

function Ctl3dSubclassDlgEx(HWindow: HWnd; GrBits : longint): bool;
begin
  if not Ctl3dv2Active then Ctl3dSubclassDlgEx:=false
  else Ctl3dSubclassDlgEx:=TCtl3dSubclassDlgEx(FCtl3dSubclassDlgEx)(HWindow,GrBits);
end;

function Ctl3dGetVer: word;
begin
  if not Ctl3dv2Active then Ctl3dGetVer:=0
  else Ctl3dGetVer:=TCtl3dGetVer(FCtl3dGetVer);
end;

function Ctl3dEnabled: bool;
begin
  if not Ctl3dv2Active then Ctl3dEnabled:=false
  else Ctl3dEnabled:=TCtl3dEnabled(FCtl3dEnabled);
end;

function Ctl3dCtlColor(DC: HDC; Color: TColorRef): HBrush;
begin
  if not Ctl3dv2Active then Ctl3dCtlColor:=0
  else Ctl3dCtlColor:=TCtl3dCtlColor(FCtl3dCtlColor)(DC,Color);
end;

function Ctl3dCtlColorEx(Message, wParam: word; lParam: longint): HBrush;
begin
  if not Ctl3dv2Active then Ctl3dCtlColorEx:=0
  else Ctl3dCtlColorEx:=TCtl3dCtlColorEx(FCtl3dCtlColorEx)(Message,wParam,lParam);
end;

function Ctl3dColorChange: bool;
begin
  if not Ctl3dv2Active then Ctl3dColorChange:=false
  else Ctl3dColorChange:=TCtl3dColorChange(FCtl3dColorChange);
end;

function Ctl3dSubclassCtl(HWindow: HWnd): bool;
begin
  if not Ctl3dv2Active then Ctl3dSubclassCtl:=false
  else Ctl3dSubclassCtl:=TCtl3dSubclassCtl(FCtl3dSubclassCtl)(HWindow);
end;

function Ctl3dDlgFramePaint(HWindow: HWnd; Message, wParam: word; lParam: longint): longint;
begin
  if not Ctl3dv2Active then Ctl3dDlgFramePaint:=0
  else Ctl3dDlgFramePaint:=TCtl3dDlgFramePaint(FCtl3dDlgFramePaint)(HWindow,Message,wParam,lParam);
end;

function Ctl3dAutoSubclass(Instance: THandle): bool;
begin
  if not Ctl3dv2Active then Ctl3dAutoSubclass:=false
  else Ctl3dAutoSubclass:=TCtl3dAutoSubclass(FCtl3dAutoSubclass)(Instance);
end;

function Ctl3dRegister(Instance: THandle): bool;
begin
  if not Ctl3dv2Active then Ctl3dRegister:=false
  else Ctl3dRegister:=TCtl3dRegister(FCtl3dRegister)(Instance);
end;

function Ctl3dUnregister(Instance: THandle): bool;
begin
  if not Ctl3dv2Active then Ctl3dUnregister:=false
  else Ctl3dUnregister:=TCtl3dUnregister(FCtl3dUnregister)(Instance);
end;

procedure Ctl3dWinIniChange;
begin
  if Ctl3dv2Active then TCtl3dWinIniChange(FCtl3dWinIniChange)
end;


function Load3dDll: boolean;
const
  SEM_NoOpenFileErrorBox = $8000;
var
  PrevErrorMode: word;
begin
  Load3dDll:=false;
  Ctl3dModule:=0;
  if Win95 and Win95_3d then Exit;

  PrevErrorMode:=SetErrorMode(SEM_NoOpenFileErrorBox);
  Ctl3dModule:=LoadLibrary('ctl3dv2.dll');
  SetErrorMode(PrevErrorMode);
  if Ctl3dModule<22 then Ctl3dModule:=0
  else begin
    FCtl3dGetVer       := GetProcAddress(Ctl3dModule,PChar(1));
    FCtl3dSubclassDlg  := GetProcAddress(Ctl3dModule,PChar(2));
    FCtl3dSubclassCtl  := GetProcAddress(Ctl3dModule,PChar(3));
    FCtl3dCtlColor     := GetProcAddress(Ctl3dModule,PChar(4));
    FCtl3dEnabled      := GetProcAddress(Ctl3dModule,PChar(5));
    FCtl3dColorChange  := GetProcAddress(Ctl3dModule,PChar(6));
    FCtl3dRegister     := GetProcAddress(Ctl3dModule,PChar(12));
    FCtl3dUnregister   := GetProcAddress(Ctl3dModule,PChar(13));
    FCtl3dAutoSubclass := GetProcAddress(Ctl3dModule,PChar(16));
    FCtl3dCtlColorEx   := GetProcAddress(Ctl3dModule,PChar(18));
    FCtl3dDlgFramePaint:= GetProcAddress(Ctl3dModule,PChar(20));
    FCtl3dSubclassDlgEx:= GetProcAddress(Ctl3dModule,PChar(21));
    FCtl3dWinIniChange := GetProcAddress(Ctl3dModule,PChar(22));

    Load3dDll:=true;
    Ctl3dv2Active:=true;
    Ctl3dRegister(Hinstance);
    Ctl3dAutoSubclass(Hinstance);
  end;
end;                        { Load3dDll }

procedure Unload3dDll;
begin
  if Ctl3dv2Active then Ctl3dUnregister(Hinstance);
  if Ctl3dModule<>0 then FreeLibrary(Ctl3dModule);
  Ctl3dv2Active:=false;
  Ctl3dModule:=0;
end;

begin
  Ctl3dv2Active:=false;
  Ctl3dModule:=0;
end.
