#!/bin/sh
#
# This script writes a .tex file which does the necessary work 
# of converting Adobe Font Metric files for a `normal' font family,
# runs fontinst on it, converts the resulting files,
# and installs them in distribution directories.
#
# (c) Sebastian Rahtz February 6th 1994
#                 March 15th 1994
#                 May 5th 1994
#		  May 8th 1994
# ---------------- fontinst first real release -------
#                 June 7th 1994 (switched to \latinfamily)
#----------------------------------------------------------------
# The user has to supply the Berry family name, and (optionally) 
# any special code to run when the family is loaded.
# The output is:
#  - two .fd files (one for T1, one for OT1)
#  - .tfm and .vf files
#  - a file <family>.map (could be appended to psfonts.map (for dvips))
#  - a file config.<family> (for use with dvips, referencing psfonts.<family>)
#  - a file <famname>.sty package file for trivial use of font family
# Intermediate files are deleted.
#
# Options:
#  -download means that the lines written to psfonts.<family> have "<fontname"
#  -sans  means this is a sanserif font
#  -tt means that this is a typewriter family
#  -out [dir] specifies where the results are to go
#  -lucida  means add special code for Lucida scaling
#  -expert means this is to be set up an expert set
#
# Parameters:
# $1 The family name, eg ptm.
# $2 Extra FD commands to be executed every time the font is loaded.
#    (\hyphenchar\font=-1 is added automatically for tt fonts)
#
# example for Courier:
# psmetrics -tt pcr 
#
# example for Times:
# make-fam-metric ptm 
#-------------------------------------------------------------
# Provide a usage message to refresh human memories.
if test \( $# -lt 1 \) 
then 
  echo "Usage: [-download] [-sans] [-tt] [-out <dir>] family [fd code]"
   exit 1
fi
#
# where to put the results
#
OUTDIR=.
#
# defaults
#
F=$1
#--------------------------------------------------------
# now run TeX with the fontinst macros. could take a while.
# --------------------------------------------------------
tex $F.fti
#--------------------------------------------------------
# convert the ascii .pl and .vpl files to binary
#--------------------------------------------------------
for i in ${F}*0.pl 
do 
 Z=`basename $i .pl`  
 pltotf $Z.pl $Z.tfm   
done    
for i in ${F}*.vpl 
do 
 Z=`basename $i .vpl` 
 vptovf $Z.vpl $Z.vf $Z.tfm  
done
#
# and delete the temporary files
#
rm $F*.mtx 
rm $F*.pl 
rm $F*.vpl
#
# install the files in subdirectories
#
#if test ! -d ${OUT}
#then
#	mkdir ${OUT}
#fi
#for i in tfm vf fd sty
#do
#	if test ! -d ${OUT}/$i
#	then
#		mkdir ${OUT}/$i
#	fi
#	mv *.$i ${OUT}/$i
#done
#if test ! -d ${OUT}/afm
#then
# mkdir ${OUT}/afm
# cp ${F}*${VAR}0.afm ${OUT}/afm
#fi
#
#mv config.${F} ${OUT}
#mv $1.map ${OUT}
cat > $F.rme <<ENDOFCAT
cat > $F.rme <<ENDOFCAT
%%%% ==================================================
%%%% 4allTeX fontinst package (PhB)                       
%%%% Use correct phbfonti.sty instead of fontinst.sty  
%%%% ==================================================
This set of metric files for the ${FF} font family was
created on `date` by Sebastian Rahtz
using Alan Jeffrey's fontinst program with Phons Bloemen's patches
The file ${F}.fti must be run trough phbfonti.sty, to get:
(provided AFM files of ${F} are available.....)
 + .tfm files for use by TeX in old TeX encoding (eg ptmr.tfm)
        Cork TeX encoding (eg ptmrq.tfm)
 + .vf  (virtual font) files for dvi drivers (same names as above)
 + .tfm files for the _raw_ fonts (unencoded, eg ptmr0.tf) for the vf files
 + .fd  (font description) files for use with LaTeX2e
 + .map which lists the raw font names and their full PostScript names. 
        This can be added to eg the psfonts.map file of dvips to ensure 
        that the driver recognizes the names as those of PostScript fonts
 + .sty LaTeX2e package ${FFF}.sty to use the new font family
        as appropriate for its type (as roman, sans or typewriter font)
 + a dvips config file config.${F} which can be used to tell dvips
   about the new fonts if you do not want to change the default psfonts.map
   (usage: dvips -P${F} to tell dvips about the ${FF} fonts)
ENDOFCAT






