#!/bin/bash
#
# 
# Installation script for Omega for Tamil
#
# Alex A.J. <indicTeX@gmail.com>
#
#
#
#
echo -e "\nInstallation script for Omega for Tamil"
echo -e "Alex A.J. <indicTeX@gmail.com>\n"
echo -e "Starting installation...\n"


echo -e "TEXMF root directory (Press <ENTER> if the default is ok)"
echo -e "(The default should be ok for most Linux systems)"
echo -e "Caution: DO NOT type / at the end of directory name\n"
echo -e "(/usr/share/texmf): \c"
read texdir
if [ "$texdir" = "" ]
then
   texdir="/usr/share/texmf"
fi

echo -e "\nInstalling packages...\n"

# The directories

mkdir -p $texdir/doc/indic/tamil/omega
mkdir -p $texdir/tex/lambda/tamil
mkdir -p $texdir/omega/otp/tamil
mkdir -p $texdir/omega/ocp/tamil
mkdir -p $texdir/fonts/map/dvips/tamil
mkdir -p $texdir/fonts/type1/tamil/wntamil
mkdir -p $texdir/fonts/tfm/tamil/wntamil
mkdir -p $texdir/fonts/tfm/tamil/ism

# The files

cp -f ./doc/* $texdir/doc/indic/tamil/omega
cp -f ./examples/* $texdir/doc/indic/tamil/omega
cp -f ./fonts/wntamil/*.pfb $texdir/fonts/type1/tamil/wntamil
cp -f ./fonts/wntamil/*.tfm $texdir/fonts/tfm/tamil/wntamil
cp -f ./fonts/ism/*.tfm $texdir/fonts/tfm/tamil/ism
cp -f ./omega/*.sty $texdir/tex/lambda/tamil
cp -f ./omega/*.fd $texdir/tex/lambda/tamil
cp -f ./omega/*.map $texdir/fonts/map/dvips/tamil
cp -f ./otp/*.otp $texdir/omega/otp/tamil
cp -f ./otp/*.ocp $texdir/omega/ocp/tamil


# Post installation commands

texhash
updmap-sys --enable Map tamil.map
updmap-sys --enable Map tamil_ism.map

echo -e "\n\nInstallation of Omega for Tamil completed successfully.\n"
echo -e "Documentation can be found in $texdir/doc/indic/tamil/omega"
echo -e "Some examples are provided in $texdir/doc/indic/tamil/omega\n"


#
#End of file
