/* strword.c 2.9.0 92/07/06 - new improved version of strword */

/* - Damian Cugley <pdc@prg.ox.ac.uk> Fri.  1 Mar. 1991
-----------------------------------------------------------------------
    This software module copyright (c) 1991 Damian Cugley.  
    It is provided for free on an "as-is" basis.
    See the file COPYING for more information.
-----------------------------------------------------------------------
*/

#include <ctype.h>
#include "strmisc.h"

char *
strword(str, sp)
     char *str,			/* if non-null, read from this string */
       **sp;			/* used to store state between calls */
{
  char *result,
    *p,			/* copy word to here */
    *q;			/* copy word from here */

  for (result = (str ? str : *sp); *result && isspace(*result); ++result)
    ; 
  p = result;
  if (*p == '"')	
    {	/*  word starts with " char  */
      for (q = p + 1;
	   *q && !(*q == '"' && *++q != '"');
	   *p++ = *q++)
	;
      *sp = q;			/* at least 2 past p */
    }
  else
    {
      while (*p && !isspace(*p))
	p++;
      *sp = *p ? p + 1 : p;
    }
  *p = '\0';		/* chop returned string after end of word */
  return *result ? result : (char *)0;	
}
