/* stdc.h 2.9.0 92/07/06 
 * - some #define hacks to attempt to allow either stdc or tradc */

/* Copyright (C) 1990 Damian Cugley */

#ifndef __STDC_H
#define __STDC_H

#include "config.h"

#ifndef __GNUC__
#  define inline
#  define NONRETURNING
#else
#  define inline __inline__
#  define NONRETURNING __volatile__
#endif

#ifdef __STDC__
typedef void *addr;
typedef const void *const_addr;
#  define GLUE(x,y)	x##y
#else
   typedef char *addr, *const_addr;
#  define GLUE(x,y)	x/**/y
#  define const
#  define volitile
#endif /* __STDC__ */

/*  
 *  ARGS is used so that when reading this file in trad C, the prototypes
 *  are ignored.
 */
#ifndef ARGS
#  ifdef __STDC__
#    define ARGS(X)	X
#  else
#    define ARGS(X)	()
#  endif
#endif


/*
 *  OK.  ANSI C has a type size_t that is used for sizes of things.
 *  In the GNU C header files, this is unsigned long.
 *  In BSD, it appears this should be
 *     unsigned int for malloc et al. and int otherwise
 *  In SunOS ditto
 *  In V.2, ditto
 *
 *  So I have 2 type names -- card and sizeof_t, both #define macros
 *  Since C does not do range-checking, card (as in cardinal)
 *  should be *signed* int, so that -ve numbers dont go *completely* mad.
 */

#ifdef __SDTC__
#  ifndef NEEDPROTO
     /* true STDC system */
#    include <stddef.h>
#    define sizeof_t size_t
#    define card size_t
#    define _SIZE_T
#  endif
#endif

#ifndef sizeof_t
#  define sizeof_t unsigned int
#endif

#ifndef card
#  define card int
#endif

/*
 *  e.g.,
 *  	addr malloc ARGS((sizeof_t));
 *  as opposed to
 *	void *malloc(size_t);
 *  or
 *	char *malloc();
 *  in ANSI C and tradc respectively.
 */

#endif
