#
# $Id: nan_compile.mk,v 1.4 2002/12/19 22:06:32 maarten Exp $
#
# ***** BEGIN GPL/BL DUAL LICENSE BLOCK *****
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version. The Blender
# Foundation also sells licenses for use in proprietary software under
# the Blender License.  See http://www.blender.org/BL/ for information
# about this.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# The Original Code is Copyright (C) 2001-2002 by NaN Holding BV.
# All rights reserved.
#
# The Original Code is: all of this file.
#
# Contributor(s): none yet.
#
# ***** END GPL/BL DUAL LICENSE BLOCK *****
#
# Compile and archive

include nan_definitions.mk

CPPFLAGS ?= $(NAN_CPPFLAGS)

# common parts ---------------------------------------------------

# Uncomment next line to enable integrated game engine
#CFLAGS += -DGAMEBLENDER=1

ifdef NAN_DEBUG
    CFLAGS += $(NAN_DEBUG)
    CCFLAGS += $(NAN_DEBUG)
endif

REL_CFLAGS	+= -DNDEBUG
REL_CCFLAGS	+= -DNDEBUG
DBG_CFLAGS	+= -g
DBG_CCFLAGS	+= -g

# OS dependent parts ---------------------------------------------------

ifeq ($(OS),beos)
    CC	= gcc
    CCC	= g++
    CFLAGS	+= -pipe -fPIC
    CFLAGS	+= -pipe -fPIC
    REL_CFLAGS	+= -O2
    REL_CCFLAGS	+= -O2
    NAN_DEPEND	= true
    OPENGL_HEADERS  = .
    CPPFLAGS	+= -D__BeOS
    AR	= ar
    ARFLAGS = ruv
    ARFLAGSQUIET = ru
endif

ifeq ($(OS),darwin)
    CC	= gcc
    CCC	= g++
    CFLAGS	+= -pipe -fPIC
    CCFLAGS	+= -pipe -fPIC
    REL_CFLAGS	+= -O
    REL_CCFLAGS	+= -O
    CPPFLAGS	+= -D_THREAD_SAFE
    NAN_DEPEND	= true
    OPENGL_HEADERS = /System/Library/Frameworks/OpenGL.framework
    AR = ar
    ARFLAGS = ruv
    RANLIB = ranlib
    ARFLAGSQUIET = ru
endif

ifeq ($(OS),freebsd)
    CC	= gcc
    CCC	= g++
    JAVAC = javac
    JAVAH = javah
    CFLAGS	+= -pipe -fPIC
    CCFLAGS	+= -pipe -fPIC
    REL_CFLAGS	+= -O2
    REL_CCFLAGS	+= -O2
    CPPFLAGS	+= -D_THREAD_SAFE
    NAN_DEPEND	= true
    OPENGL_HEADERS  = /usr/X11R6/include
    JAVA_HEADERS = /usr/local/jdk1.3.1/include
    JAVA_SYSTEM_HEADERS = /usr/local/jdk1.3.1/include/freebsd
    AR	= ar
    ARFLAGS = ruv
    ARFLAGSQUIET = ru
endif

ifeq ($(OS),irix)
    CC	= cc
    CCC	= CC
    CFLAGS	+= -n32 -mips3 -Xcpluscomm
    CCFLAGS	+= -n32 -mips3 -Xcpluscomm -LANG:std
    REL_CFLAGS	+= -O2 -OPT:Olimit=0
    REL_CCFLAGS += -O2 -OPT:Olimit=0
    OPENGL_HEADERS = /usr/include
    NAN_DEPEND = true
    AR = CC
    ARFLAGS = -ar -o
	ARFLAGSQUIET = -ar -o
endif

ifeq ($(OS),linux)
    CC	= gcc
    CCC	= g++
#    CFLAGS	+= -pipe
    CFLAGS	+= -pipe -fPIC
    CCFLAGS	+= -pipe -fPIC
#    CCFLAGS	+= -pipe
    REL_CFLAGS	+= -O2
    REL_CCFLAGS	+= -O2
    NAN_DEPEND = true
  ifeq ($(CPU),alpha)
    CFLAGS += -mieee
  endif
    OPENGL_HEADERS = /usr/X11R6/include
    AR = ar
    ARFLAGS = ruv
    ARFLAGSQUIET = ru
endif

ifeq ($(OS),openbsd)
    CC	= gcc
    CCC = g++
    CFLAGS	+= -pipe -fPIC
    CCFLAGS	+= -pipe -fPIC
    REL_CFLAGS	+= -O2
    REL_CCFLAGS += -O2
    NAN_DEPEND = true
    CPPFLAGS += -D__FreeBSD__
    OPENGL_HEADERS = /usr/X11R6/include
    AR = ar
    ARFLAGS = ruv
    ARFLAGSQUIET = ru
endif

ifeq ($(OS),solaris)
    CC	= gcc
    CCC = g++
    JAVAC = javac
    JAVAH = javah
    CFLAGS	+= -pipe -fPIC
    CCFLAGS	+= -pipe -fPIC
    REL_CFLAGS	+= -O2
    REL_CCFLAGS += -O2
    NAN_DEPEND = true
  ifeq ($(CPU),sparc)
    OPENGL_HEADERS = /usr/openwin/share/include
    CPPFLAGS += -DSUN_OGL_NO_VERTEX_MACROS
    JAVA_HEADERS = /usr/java/include
    JAVA_SYSTEM_HEADERS = /usr/java/include/solaris
  else
    OPENGL_HEADERS = /usr/local/include
  endif
    AR = ar
    ARFLAGS = ruv
    ARFLAGSQUIET = ru
endif

ifeq ($(OS),windows)
    CC	= $(SRCHOME)/tools/cygwin/cl_wrapper.pl
    CCC = $(SRCHOME)/tools/cygwin/cl_wrapper.pl
    JAVAC = $(SRCHOME)/tools/cygwin/java_wrapper.pl -c
    JAVAH = $(SRCHOME)/tools/cygwin/java_wrapper.pl -h
    REL_CFLAGS	+= /O2
    REL_CCFLAGS += /O2 -GX
    DBG_CFLAGS	+= /Fd$(DIR)/debug/
    DBG_CCFLAGS += /Fd$(DIR)/debug/
    CFLAGS += /MT
    CCFLAGS += /MT
    NAN_DEPEND = true
    OPENGL_HEADERS = .
    CPPFLAGS += -DWIN32 -D_WIN32 -D__WIN32
    CPPFLAGS += -D_M_IX86
    CPPFLAGS += -I"/cygdrive/c/Program Files/Microsoft Visual Studio/VC98/include"
    JAVA_HEADERS = /cygdrive/c/j2sdk1.4.0-beta3/include
    JAVA_SYSTEM_HEADERS = /cygdrive/c/j2sdk1.4.0-beta3/include/win32
    CPP = $(SRCHOME)/tools/cygwin/cl_wrapper.pl
    AR = ar
    ARFLAGS = ruv
    ARFLAGSQUIET = ru
    WINRC = $(wildcard *.rc)
endif

ifeq (debug, $(findstring debug, $(MAKECMDGOALS)))
    export DEBUG_DIR=debug/
endif

ifneq (x$(DEBUG_DIR), x)
    CFLAGS +=$(DBG_CFLAGS)
    CCFLAGS+=$(DBG_CCFLAGS)
else
    CFLAGS +=$(REL_CFLAGS)
    CCFLAGS+=$(REL_CCFLAGS)
endif

# Note: include nan_warn's LEVEL_*_WARNINGS after CC/OS have been set.
include nan_warn.mk

# compile rules

default: all

$(DIR)/$(DEBUG_DIR)%.o: %.c
    ifdef NAN_DEPEND
	@set -e; $(CC) -M $(CPPFLAGS) $< 2>/dev/null \
		| sed 's@\($*\)\.o[ :]*@$(DIR)/$(DEBUG_DIR)\1.o : @g' \
		> $(DIR)/$(DEBUG_DIR)$*.d; \
		[ -s $(DIR)/$(DEBUG_DIR)$*.d ] || $(RM) $(DIR)/$(DEBUG_DIR)$*.d
    endif
    ifdef NAN_QUIET
	@echo " -- $< -- "
	@$(CC) -c $(CFLAGS) $(CPPFLAGS) $< -o $@
    else
	$(CC) -c $(CFLAGS) $(CPPFLAGS) $< -o $@
    endif

$(DIR)/$(DEBUG_DIR)%.o: %.cpp
    ifdef NAN_DEPEND
	@set -e; $(CCC) -M $(CPPFLAGS) $< 2>/dev/null \
		| sed 's@\($*\)\.o[ :]*@$(DIR)/$(DEBUG_DIR)\1.o : @g' \
		> $(DIR)/$(DEBUG_DIR)$*.d; \
		[ -s $(DIR)/$(DEBUG_DIR)$*.d ] || $(RM) $(DIR)/$(DEBUG_DIR)$*.d
    endif
    ifdef NAN_QUIET
	@echo " -- $< -- "
	@$(CCC) -c $(CCFLAGS) $(CPPFLAGS) $< -o $@
    else
	$(CCC) -c $(CCFLAGS) $(CPPFLAGS) $< -o $@
    endif

$(DIR)/$(DEBUG_DIR)%.res: %.rc
	$(SRCHOME)/tools/cygwin/cl_wrapper.pl - rc /fo$@ $<

$(DIR)/$(DEBUG_DIR)%.class: %.java
    ifdef JARS
	$(JAVAC) -verbose -g -deprecation -sourcepath . -classpath "$(JARS)" -d $(DIR)/$(DEBUG_DIR) $<
    else
	$(JAVAC) -verbose -g -deprecation -d $(DIR)/$(DEBUG_DIR) $<
    endif

$(DIR)/$(DEBUG_DIR)%.h: $(DIR)/$(DEBUG_DIR)%.class
	$(JAVAH) -classpath $(DIR)/$(DEBUG_DIR) -d $(DIR)/$(DEBUG_DIR) -jni $*

%.h:
	@echo "WARNING: Fake header creation rule used, dependencies will be remade"

CSRCS  ?= $(wildcard *.c)
CCSRCS ?= $(wildcard *.cpp)
JSRCS  ?= $(wildcard *.java)

ifdef NAN_DEPEND
-include $(CSRCS:%.c=$(DIR)/$(DEBUG_DIR)%.d) $(CCSRCS:%.cpp=$(DIR)/$(DEBUG_DIR)%.d)
endif

OBJS += $(CSRCS:%.c=$(DIR)/$(DEBUG_DIR)%.o)
OBJS += $(CCSRCS:%.cpp=$(DIR)/$(DEBUG_DIR)%.o)
OBJS += $(WINRC:%.rc=$(DIR)/$(DEBUG_DIR)%.res)

JCLASS += $(JSRCS:%.java=$(DIR)/$(DEBUG_DIR)%.class)

LIB_a = $(DIR)/$(DEBUG_DIR)lib$(LIBNAME).a

$(LIB_a): $(OBJS)
   # $OBJS can be empty except for some spaces
    ifneq (x, x$(strip $(OBJS)))
      ifdef NAN_PARANOID
	@$(RM) $(LIB_a)
        ifdef NAN_QUIET
	@echo " -- lib: lib$(LIBNAME).a -- "
	@$(AR) $(ARFLAGSQUIET) $@ $(OBJS)
        else
	$(AR) $(ARFLAGS) $@ $(OBJS)
        endif
      else
        ifdef NAN_QUIET
	@echo " -- lib: lib$(LIBNAME).a -- "
	@$(AR) $(ARFLAGSQUIET) $@ $?
        else
	$(AR) $(ARFLAGS) $@ $?
        endif
      endif
      ifdef RANLIB
	$(RANLIB) $@
      endif
    endif

ALLTARGETS ?= $(LIB_a)

all debug :: makedir $(ALLTARGETS)

lib: $(LIB_a)

creator: $(OBJS)
	@echo "====> make creator subtarget in `pwd | sed 's/^.*develop\///'`"
	@$(MAKE) makedir DIR=$(DIR)/$(DEBUG_DIR)cre
	@$(MAKE) lib CSRCS="$(CRE_CSRCS)" LIBNAME=$(LIBNAME)$@

publisher: $(OBJS)
	@echo "====> make publisher subtarget in `pwd | sed 's/^.*develop\///'`"
	@$(MAKE) makedir DIR=$(DIR)/$(DEBUG_DIR)pub
	@$(MAKE) lib CSRCS="$(PUB_CSRCS)" LIBNAME=$(LIBNAME)$@

player: $(OBJS)
	@echo "====> make player subtarget in `pwd | sed 's/^.*develop\///'`"
	@$(MAKE) makedir DIR=$(DIR)/player/$(DEBUG_DIR)
	@$(MAKE) lib CSRCS="$(SAP_CSRCS)" LIBNAME=$(LIBNAME)$@

clean:: optclean debugclean

optclean::
	@-[ ! -d $(DIR) ] || ( cd $(DIR) && \
	    $(RM) *.o *.a *.d *.res ii_files/*.ii *.class *.h )

debugclean::
	@-[ ! -d $(DIR)/debug ] || ( cd $(DIR)/debug && \
	    $(RM) *.o *.a *.d *.res ii_files/*.ii *.class *.h )

.PHONY: makedir
makedir::
	@# don't use mkdir -p. Cygwin will try to make network paths and fail
	@[ -d $(DIR) ] || mkdir $(DIR)
	@[ -d $(DIR)/debug ] || mkdir $(DIR)/debug

