#!BPY

"""
Name: 'Batch Change Object Size & Rot'
Blender: 248
Group: 'Object'
Tooltip: 'Change the size and/or rotation values of all selected objects'
"""

__bpydoc__=\
'''
This script changes the selected objects size and/or rotation (in degrees).
'''

# ***** BEGIN GPL LICENSE BLOCK *****
#
# Script copyright (C) Campbell Barton
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------

from Blender import Draw, Scene

def changevalue(sel, PREF_SIZE, PREF_ROT, PREF_X_AXIS, PREF_Y_AXIS, PREF_Z_AXIS):
	for ob in sel:
				
		if PREF_SIZE:
				if PREF_X_AXIS:	x= 1* PREF_SIZE
				else:			x= 1
				if PREF_Y_AXIS:	y= 1* PREF_SIZE
				else:			y= 1
				if PREF_Z_AXIS:	z= 1* PREF_SIZE
				else:			z= 1
				
				ob.size = (ob.SizeX*x,  ob.SizeY*y,  ob.SizeZ*z)
		if PREF_ROT:
		# Changes radians to degrees by dividing it with ~57.296...
				ob.rot = (ob.RotX+(PREF_X_AXIS*PREF_ROT/57.2957795),  ob.RotY+(PREF_Y_AXIS*PREF_ROT/57.2957795),  ob.RotZ+(PREF_Z_AXIS*PREF_ROT/57.2957795))
	

def main():
	scn = Scene.GetCurrent()
	if not scn.objects.context:
		return
	
	PREF_SIZE= Draw.Create(1.0)
	PREF_ROT= Draw.Create(0.0)
	PREF_X_AXIS= Draw.Create(1)
	PREF_Y_AXIS= Draw.Create(1)
	PREF_Z_AXIS= Draw.Create(1)
	
	pup_block = [\
	('Multiply Size:', PREF_SIZE, 0.01, 1000.0,  'Number to multiply the size with. Leave to 1 if you do not want to resize'),\
	('     Rotation:', PREF_ROT, -360.0, 360.0, 'Amount to change the rotation in degrees'),\
	'',\
	('X Axis', PREF_X_AXIS, 'Enable X axis'),\
	('Y Axis', PREF_Y_AXIS, 'Enable Y axis'),\
	('Z Axis', PREF_Z_AXIS, 'Enable Z axis'),\
	]
	
	if not Draw.PupBlock('Object Size & Rotation', pup_block):
		return
	
	changevalue(scn.objects.context, PREF_SIZE.val, PREF_ROT.val, PREF_X_AXIS.val, PREF_Y_AXIS.val, PREF_Z_AXIS.val)
	
if __name__ == '__main__':
	main()
