#!BPY

"""
Name: 'BatchX_Conversion'
Blender: 248
Group: 'Misc'
Tooltip: 'Batch process changes to selected objects'
"""

__author__ = "Mitch Hughes (lobo_nz)"
__url__ = ("http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Misc/batchx", "Author's homepage, http://blender.formworks.co.nz")
__version__ = "0.1"

__bpydoc__ = """\
This script makes changes to selected opjects to save picking them one by one.

This script sets options on many objects (meshes) at once,

 currently it can toggle "Autosmooth" on or off, 
 
 can "Set Smooth" or "Set Solid" on all faces, apply a Material.
 
 
Eventually I will no doubt add more options as I need them or am asked to add them :) 

Usage:
	
Add the script to your blender/scripts directory
Execute this script from the "Scripts->Misc" menu and choose "BatchX",
Select desired options to modify click the "Make Changes" to apply selected changes.
"""

# $Id: batchx.py,v 0.1 2005/11/26 12:26:10$
#
# --------------------------------------------------------------------------
# BatchX by Mitch Hughes (AKA lobo_nz)
# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------

import Blender
from Blender import *
import string

g_set_autosmooth = Draw.Create(1)
g_set_smooth = Draw.Create(1)
g_set_solid = Draw.Create(1)
g_recalc_normals = Draw.Create(1)
g_material = Draw.Create(1)

g_matList = []
g_smoothList = []
g_autoSmoothList = []

# Events
EVENT_NOEVENT=1
EVENT_SET_AUTOSMOOTH=2
EVENT_SET_SMOOTH=3
EVENT_TOGGLE_RECALCNORMALS=4
EVENT_SET_MATERIAL=5

EVENT_BATCHX=99
EVENT_EXIT=100

BUT_KEYMENU = []
BUT_KEYMENU = range(10)

sc=Scene.GetCurrent()

def getObjects(objType):
	objects = Blender.Object.GetSelected()
	objList = []
	for thisObj in objects:
		#print type(thisObj.getData())
		if type(thisObj.getData()) == objType:
			objList.append(thisObj)
	return objList
	
# A method to do a 'Set Smooth' on a mesh
def setSmooth(mesh):
	for face in mesh.faces:
		face.smooth = 1
# A method to do a 'Set Solid' on a mesh
def setSolid(mesh):
	for face in mesh.faces:
		face.smooth = 0	

def batchMesh():
	global g_set_autosmooth
	global g_set_smooth
	global g_set_solid
	global g_recalc_normals
	global g_material
	
	global g_matList
	global g_smoothList
	global g_autoSmoothList
	
	for obj in getObjects(Types.NMeshType):
		meshData = obj.getData()
		
		if g_material.val > 1:
			material = Blender.Material.Get(g_matList[g_material.val-1])
			#Materials can be set to a mesh datablock
			#Or the object, we setMaterials on both to make sure :)
			obj.setMaterials([material])
			meshData.setMaterials([material])
			
		if g_set_smooth.val > 1:
			if g_smoothList[g_set_smooth.val-1] == "Set Smooth":
				setSmooth(meshData)
			elif g_smoothList[g_set_smooth.val-1] == "Set Solid":
				setSolid(meshData)
				
		if g_set_autosmooth.val > 1:
			if g_autoSmoothList[g_set_autosmooth.val-1] == "On":
				#TODO figure out avalable modes available in CVS 2.4
				#for now we just unset all other modes :)
				#setMode(m=None, m1=None, m2=None, m3=None)  
				#getMode returnes or'ed value
				#"NoVNormalsFlip"
				#"TwoSided"
				#"AutoSmooth"
				
				#meshData.setMode("NoVNormalsFlip")
				#print meshData.getMode()
				#meshData.setMode("TwoSided")
				#print meshData.getMode()
				#meshData.setMode("AutoSmooth")
				#print meshData.getMode()
				meshData.setMode("AutoSmooth")
				
			elif g_autoSmoothList[g_set_autosmooth.val-1] == "Off":
				meshData.setMode()
		meshData.update(g_recalc_normals.val)
			
			
	
        
			
def menuNameFromList(menu_title, menu_entries):
	menu_name = menu_title + " %t"
	counter = 0
	for entry in menu_entries:
		counter = counter + 1
		menu_name = menu_name +"|"+ entry +" %x"+ str(counter)
	return menu_name

def getMaterialNameList():
	matObjList = Blender.Material.Get()
	matNameList = []
	for matObj in matObjList:
		matNameList.append(matObj.name)
	return matNameList

def WIDTH(val):
	global g_drawx
	g_drawx = g_drawx + val
	return val
	
def DRAWX(val):
	global g_drawx
	if val == 0:
		g_drawx = 10
	else:
		g_drawx = g_drawx + val
	return g_drawx
    
def DRAWY(val):
    global g_drawy
    if val >= 0:
        g_drawy=g_drawy-val
        return g_drawy
    else:
        g_drawy = val*-1
        return g_drawy

def gui():
	global EVENT_NOEVENT
	global EVENT_SET_AUTOSMOOTH
	global EVENT_SET_SMOOTH
	global EVENT_TOGGLE_RECALCNORMALS
	global EVENT_SET_MATERIAL
	
	global EVENT_BATCHX
	global EVENT_EXIT
	
	global g_set_autosmooth
	global g_set_smooth
	global g_set_solid
	global g_recalc_normals
	global g_material
	
	global g_matList
	global g_smoothList
	global g_autoSmoothList
	
	
	DRAWY(-300)
	
	Blender.BGL.glClearColor(0.6, 0.6, 0.6, 0.0)
	Blender.BGL.glClear(Blender.BGL.GL_COLOR_BUFFER_BIT)
	
	BGL.glRasterPos2d(DRAWX(0), DRAWY(25))
	Draw.Text("BatchX " + __version__)
	BGL.glRasterPos2d(DRAWX(0), DRAWY(20))
	Draw.Text("Applies the chosen options")
	BGL.glRasterPos2d(DRAWX(0), DRAWY(20))
	Draw.Text("to all selected objects")
	
	BGL.glRasterPos2d(DRAWX(0), DRAWY(30))
	Draw.Text("1) Set Material")
	g_matList = getMaterialNameList()
	g_matList.insert(0, "-- No Change --")
	BUT_KEYMENU[EVENT_SET_MATERIAL] = Blender.Draw.Menu(menuNameFromList("Materials", g_matList), EVENT_SET_MATERIAL, DRAWX(0), DRAWY(25), WIDTH(150), 20, g_material.val, "Material")
	
	
	BGL.glRasterPos2d(DRAWX(0), DRAWY(25))
	Draw.Text("2) Smoothing")
	g_smoothList = ["-- No Change --","Set Smooth","Set Solid"]
	BUT_KEYMENU[EVENT_SET_SMOOTH] = Blender.Draw.Menu(menuNameFromList("Smoothing", g_smoothList), EVENT_SET_SMOOTH, DRAWX(0), DRAWY(25), WIDTH(150), 20, g_set_smooth.val, "Mesh Smoothing")
	
	BGL.glRasterPos2d(DRAWX(0), DRAWY(25))
	Draw.Text("3) Auto Smoothing")
	g_autoSmoothList = ["-- No Change --","On","Off"]
	BUT_KEYMENU[EVENT_SET_AUTOSMOOTH] = Blender.Draw.Menu(menuNameFromList("Auto Smooth", g_autoSmoothList), EVENT_SET_AUTOSMOOTH, DRAWX(0), DRAWY(25), WIDTH(150), 20, g_set_autosmooth.val, "Auto Smoothing")
	
	#This doesnt recalc normals outside, decided to always recalc normals
	#even though we dont mess with the orientation of faces
	#BGL.glRasterPos2d(DRAWX(0), DRAWY(25))
	#Draw.Text("4) Normals")
	#Draw.Toggle("Recalc Normals", EVENT_TOGGLE_RECALCNORMALS, DRAWX(0), DRAWY(25), WIDTH(95), 18, g_recalc_normals.val,"Recalculates Normals of Mesh")
	
	
	
	DRAWY(35)
	Blender.Draw.Button("Make Changes", EVENT_BATCHX, DRAWX(0), DRAWY(0), WIDTH(150), 20)
	Blender.Draw.Button("Exit", EVENT_EXIT, DRAWX(0), DRAWY(25), WIDTH(150), 20)

def event(evt, mode):
   if evt == Blender.Draw.QKEY: Blender.Draw.Exit()

def bevent(evt):
	global EVENT_NOEVENT
	global EVENT_SET_AUTOSMOOTH
	global EVENT_SET_SMOOTH
	global EVENT_TOGGLE_RECALCNORMALS
	global EVENT_SET_MATERIAL
	
	global EVENT_BATCHX
	global EVENT_EXIT
	
	global g_set_autosmooth
	global g_set_smooth
	global g_set_solid
	global g_recalc_normals
	global g_material
	
	if evt == EVENT_SET_MATERIAL:
		g_material.val = BUT_KEYMENU[EVENT_SET_MATERIAL].val
		#print g_material.val
		
	if evt == EVENT_SET_SMOOTH:
		g_set_smooth.val = BUT_KEYMENU[EVENT_SET_SMOOTH].val
		#print g_set_smooth.val
		
	if evt == EVENT_SET_AUTOSMOOTH:
		g_set_autosmooth.val = BUT_KEYMENU[EVENT_SET_AUTOSMOOTH].val
		print g_set_autosmooth.val
		
	if evt == EVENT_TOGGLE_RECALCNORMALS:
		g_recalc_normals.val = 1 - g_recalc_normals.val
		#print g_recalc_normals.val
		
	if evt == EVENT_BATCHX:
		batchMesh()
		Blender.Draw.Exit()
		
	if evt == EVENT_EXIT:
		Blender.Draw.Exit()
		
	Draw.Redraw(1)
	
Blender.Draw.Register(gui,event,bevent) 

