#!BPY
# -*- coding: latin-1 -*-
"""
Name: 'Auto Name Material Textures'
Blender: 248
Group: 'Materials'
Tooltip: 'Auto names all textures a material is using.'
"""

# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2006 Mariano Hidalgo
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------

__author__ = "Mariano Hidalgo a.k.a. uselessdreamer"
__url__ = ("http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Materials/autoname_material_textures")
__version__ = "1.0"

__bpydoc__ = """\
This little script will help you to get your .blend files a bit more tidy.

After creating a new materil I usually forgot to name the textures (Yeah Im lazy,
but Ive seen lots of materials with this issue).

When run, the script will prompt you to choose a material. Choose one and if the material
have textures they will be renamed MATERIALNAME.TEXTURETYPE, using the first six letters of
the material name; you can tweak these names now if you want to.

I coded this mainly for my Blender Library script. It will be more polite to properly
name stuff before sharing with others.

"""
import Blender
from Blender import Draw, Material, Texture

count = 0
mats = Material.Get()
if mats:
	matsmenu = "Select a material%t"
	for mat in mats:
		matsmenu = matsmenu + "|" + mat.getName()
	c = Draw.PupMenu(matsmenu)
	
	matname = mats[c-1].getName()
	texs = mats[c-1].getTextures()
	if texs:
		for mtex in texs:
			if mtex:
				name = mtex.tex.name
				type = mtex.tex.getType()
				mtex.tex.setName(matname[:6] + "." + type)
				count = count + 1	
	if count >= 1:
		Draw.PupMenu("All done%t|Renamed " + str(count) + " texture(s) in this material.")
	elif count == 0:
		Draw.PupMenu("Sorry%t|This material has no textures.")	
else:
	Draw.PupMenu("Sorry%t|There are no material in this .blend")	
