#!BPY

"""
Name: 'Image_to_Mesh'
Blender: 248
Group: 'Image'
Tooltip: 'Add a single-face mesh with an image on it'
"""

__author__ = "Ed Mackey"
__url__ = ("http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Image/Add_Image_as_mesh")
__version__ = "1.0 10/17/2005"

__bpydoc__ = """\
This script creates a new mesh object from an image file.

It will ask for an image with the file selector, then apply the image
to a single face in a mesh.  It will create the appropriate Face UVs, a
new material, and a new image texturemap, all assigned appropriately.

Basically, it will bring your 2D image into the 3D environment.
Set your 3D view's draw type to "Textured" for best results.
"""

# -------------------------------------------------------------------------- 
# Add Image 1.0 By Ed Mackey
# -------------------------------------------------------------------------- 
# ***** BEGIN GPL LICENSE BLOCK ***** 
# 
# This program is free software; you can redistribute it and/or 
# modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, 
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
# 
# ***** END GPL LICENCE BLOCK ***** 
# -------------------------------------------------------------------------- 

import Blender, os

def MakeBox(filename):
	Blender.Window.EditMode(0)
	objs = Blender.Object.GetSelected()
	for obj in objs:
		obj.select(0)
	img = Blender.Image.Load(filename)
	x,y = img.getSize()
	x1 = x / 200.0
	y1 = y / 100.0
	#print str(x1) + ", " + str(y1)

	basename = os.path.basename(filename)
	mesh = Blender.NMesh.New(basename)

	v1 = Blender.NMesh.Vert( x1, 0.0, y1)
	v2 = Blender.NMesh.Vert(-x1, 0.0, y1)
	v3 = Blender.NMesh.Vert(-x1, 0.0, 0.0)
	v4 = Blender.NMesh.Vert( x1, 0.0, 0.0)
	mesh.verts.append(v1)
	mesh.verts.append(v2)
	mesh.verts.append(v3)
	mesh.verts.append(v4)
	face = Blender.NMesh.Face([v1, v2, v3, v4])
	mesh.addFace(face)
	mesh.hasFaceUV(1)
	face.image = img
	face.uv = [(1.0,1.0), (0.0,1.0), (0.0,0.0), (1.0,0.0)]

	tex = Blender.Texture.New(basename)
	tex.setType('Image')
	tex.setImage(img)
	mat = Blender.Material.New(basename)
	mat.setTexture(0, tex, Blender.Texture.TexCo.UV)
	mesh.addMaterial(mat)
	mesh.update()

	obj = Blender.Object.New('Mesh', basename)
	obj.link(mesh)
	scene = Blender.Scene.GetCurrent()
	scene.link(obj)
	x,y,z = Blender.Window.GetCursorPos()
	obj.setLocation(x, y, z)
	obj.select(1)
	obj.makeDisplayList()

	Blender.Redraw()

def fs_callback(filename):
	MakeBox(filename)

Blender.Window.FileSelector(fs_callback, "Load Image")