#!BPY

"""
Name: 'Ipo_Converter'
Blender: 248
Group: 'Animation'
Tooltip: 'from Loc, Rot, Scale to dLoc, dRot, dScale'
"""
__author__ = ["dfelinto"]
__url__ = ("http://wiki.blender.org/index.php/Scripts/Manual/Animation/IPO_Converter")
__version__ = "0.1"

__bpydoc__ = """\
Change Ipo Keys from Loc, Rot, Scale to dLoc, dRot, dScale.

"""
#===============================================#
# Ipo Converter (from Loc, Rot, Scale to dLoc, dRot, dScale
# 
# if you have any questions about this script  let me know.
# Move the current frame to 1, just in case.
#
# Dalai Felinto
# http://blenderecia.orgfree.com
# Revision 0.00001 - April 4, 2009
#===============================================#

# -------------------------------------------------------------------------- 
# ***** BEGIN GPL LICENSE BLOCK ***** 
# 
# This program is free software; you can redistribute it and/or 
# modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, 
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
# 
# ***** END GPL LICENCE BLOCK ***** 
# -------------------------------------------------------------------------- 


import Blender

def createCurve(m_ipo, m_curve, offset):
    name = "d" + m_curve.name
    m_ipo.addCurve(name)

    for i in m_ipo.curves:
        if i.name == name:
            new_curve = i

    points = m_curve.getPoints()

    for p in points:
        pt = p.pt
        new_curve.append((pt[0],(pt[1]-offset)))
    
    new_curve.interpolation = m_curve.interpolation
    new_curve.setExtrapolation(m_curve.getExtrapolation())


curframe = Blender.Get("curframe") 
obj = Blender.Object.GetSelected()

for ob in obj:
    ipo = ob.getIpo()
    
    LocX = ipo[Blender.Ipo.OB_LOCX]
    LocY = ipo[Blender.Ipo.OB_LOCY]
    LocZ = ipo[Blender.Ipo.OB_LOCZ]
    
    RotX = ipo[Blender.Ipo.OB_ROTX]
    RotY = ipo[Blender.Ipo.OB_ROTY]
    RotZ = ipo[Blender.Ipo.OB_ROTZ]
    
    ScaleX = ipo[Blender.Ipo.OB_SCALEX]
    ScaleY = ipo[Blender.Ipo.OB_SCALEY]
    ScaleZ = ipo[Blender.Ipo.OB_SCALEZ]
    
    iponame = "d"+ipo.name
    n_ipo=Blender.Ipo.New('Object',iponame)
    
    obLoc = ob.getLocation()
    obRot = ob.getEuler()
    obSize = ob.getSize()
    
    obRot[0] = obRot[0]/( 2 * 3.1416)*360
    obRot[1] = obRot[1]/( 2 * 3.1416)*360
    obRot[2] = obRot[2]/( 2 * 3.1416)*360
    
    ############
    ## Location:
    if (LocX):
        dLocX = obLoc[0] - (LocX[curframe] - LocX[1])
        createCurve(n_ipo, LocX, dLocX)
    
    if (LocY):
        dLocY = obLoc[1] - (LocY[curframe] - LocY[1])
        createCurve(n_ipo, LocY, dLocY)
    
    if (LocZ):
        dLocZ = obLoc[2] - (LocZ[curframe] - LocZ[1])
        createCurve(n_ipo, LocZ, dLocZ)
    
    ############
    ## Rotation:
    if (RotX):
        dRotX = obRot[0] - (RotX[curframe] - RotX[1])
        createCurve(n_ipo, RotX, dRotX)
    
    if (RotY):
        dRotY = obRot[1] - (RotY[curframe] - RotY[1])
        createCurve(n_ipo, RotY, dRotY)
    
    if (RotZ):
        dRotZ = obRot[2] - (RotZ[curframe] - RotZ[1])
        createCurve(n_ipo, RotZ, dRotZ)
    
    ###########
    ## Scale:
    if (ScaleX):
        dScaleX = obSize[0] - (ScaleX[curframe] - ScaleX[1])
        createCurve(n_ipo, ScaleX, dScaleX)
    
    if (ScaleY):
        dScaleY = obSize[1] - (ScaleY[curframe] - ScaleY[1])
        createCurve(n_ipo, ScaleY, dScaleY)
    
    if (ScaleZ):
        dScaleZ = obSize[2] - (ScaleZ[curframe] - ScaleZ[1])
        createCurve(n_ipo, ScaleZ, dScaleZ)
        
        
    
    ob.setIpo(n_ipo)

Blender.Window.RedrawAll()