#!BPY
# By Ed Montgomery (edmontgomery@hotmail.com), August 12, 2007
"""
Name: 'Octrahedron'
Blender: 248
Group: 'AddMesh'
"""
__author__ = ["Ed Montgomery"]
__version__ = '1.00 08/12/2007'
__url__ = ["Script Index, http://wiki.blender.org/index.php/Scripts/Manual/Add/Octahedron"]
__email__=["edm@rocketmail.com"]


__bpydoc__ = """

Usage:

* Launch from Add Mesh menu

* Modify parameters as desired or keep defaults

"""

# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2008, Ed Montgomery
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****

import BPyAddMesh
import Blender

def add_mymesh(PREF_WIDTH, PREF_LENGTH, PREF_HEIGHT, PREF_DEPTH):

	verts = []
	faces = []
	
	# define object vertices	
	verts.append([-(PREF_WIDTH/2),(PREF_LENGTH/2),0.0])
	verts.append([-(PREF_WIDTH/2),-(PREF_LENGTH/2),0.0])
	verts.append([(PREF_WIDTH/2),-(PREF_LENGTH/2),0.0])
	verts.append([(PREF_WIDTH/2),(PREF_LENGTH/2),0.0])
        verts.append([0.0,0.0,(PREF_HEIGHT/2)])
	verts.append([0.0,0.0,-(PREF_DEPTH/2)])
	
	# define object faces
        faces.append([0,1,2,3])
        faces.append([0,1,4])
        faces.append([1,2,4])
        faces.append([2,3,4])
        faces.append([3,0,4])
	faces.append([0,1,5])
	faces.append([1,2,5])
	faces.append([2,3,5])
	faces.append([3,0,5])
	
	return verts, faces

def main():
	
	# Numeric input with default value of 1
	octahedronWidthInput = Blender.Draw.Create(1.0)
	
	# and same for length
	octahedronLengthInput  = Blender.Draw.Create(1.0)

        # And height of octahedron
        octahedronHeightInput = Blender.Draw.Create(1.0)

	# depth of octahedron
	octahedronDepthInput = Blender.Draw.Create(1.0)

	# array for popup window's content	
	block = []
	
	# add inputs to array with title, min/max values and tooltip
	block.append(("width: ", octahedronWidthInput, 0.01, 100, "width of the octahedron"))
	block.append(("length: ", octahedronLengthInput, 0.01, 100, "length of the octahedron"))
        block.append(("height: ", octahedronHeightInput, 0.01, 100, "height of the octahedron"))
	block.append(("depth: ", octahedronDepthInput, 0.01, 100, "depth of the octahedron"))
	
	# draw	popup if it is not open allready 
	if not Blender.Draw.PupBlock("Create octahedron",block):
		return
	
        verts, faces = add_mymesh(octahedronWidthInput.val, octahedronLengthInput.val, octahedronHeightInput.val, octahedronDepthInput.val)
	
        BPyAddMesh.add_mesh_simple('Octahedron', verts, [], faces)

main()
