/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.net.Socket;
import java.net.SocketException;
import org.ldaptive.AbstractConfig;

public class SocketConfig
extends AbstractConfig {
    private Boolean keepAlive;
    private Boolean oobInline;
    private Integer receiveBufferSize;
    private Integer sendBufferSize;
    private Boolean reuseAddress;
    private Integer soLinger;
    private Integer soTimeout;
    private Boolean tcpNoDelay;
    private Integer trafficClass;

    public boolean isEmpty() {
        return this.keepAlive == null && this.oobInline == null && this.receiveBufferSize == null && this.sendBufferSize == null && this.reuseAddress == null && this.soLinger == null && this.soTimeout == null && this.tcpNoDelay == null && this.trafficClass == null;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting keepAlive: {}", (Object)b);
        this.keepAlive = b;
    }

    public Boolean getOOBInline() {
        return this.oobInline;
    }

    public void setOOBInline(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting oobInline: {}", (Object)b);
        this.oobInline = b;
    }

    public Integer getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int i) {
        this.checkImmutable();
        this.logger.trace("setting receiveBufferSize: {}", (Object)i);
        this.receiveBufferSize = i;
    }

    public Integer getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int i) {
        this.checkImmutable();
        this.logger.trace("setting sendBufferSize: {}", (Object)i);
        this.sendBufferSize = i;
    }

    public Boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting reuseAddress: {}", (Object)b);
        this.reuseAddress = b;
    }

    public Integer getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int i) {
        this.checkImmutable();
        this.logger.trace("setting soLinger: {}", (Object)i);
        this.soLinger = i;
    }

    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int i) {
        this.checkImmutable();
        this.logger.trace("setting soTimeout: {}", (Object)i);
        this.soTimeout = i;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting tcpNoDelay: {}", (Object)b);
        this.tcpNoDelay = b;
    }

    public Integer getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int i) {
        this.checkImmutable();
        this.logger.trace("setting trafficClass: {}", (Object)i);
        this.trafficClass = i;
    }

    public void configureSocket(Socket socket) throws SocketException {
        if (this.keepAlive != null) {
            socket.setKeepAlive(this.keepAlive);
        }
        if (this.oobInline != null) {
            socket.setOOBInline(this.oobInline);
        }
        if (this.reuseAddress != null) {
            socket.setReuseAddress(this.reuseAddress);
        }
        if (this.tcpNoDelay != null) {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        if (this.receiveBufferSize != null) {
            socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.sendBufferSize != null) {
            socket.setSendBufferSize(this.sendBufferSize);
        }
        if (this.soLinger != null) {
            socket.setSoLinger(true, this.soLinger);
        }
        if (this.soTimeout != null) {
            socket.setSoTimeout(this.soTimeout);
        }
        if (this.trafficClass != null) {
            socket.setTrafficClass(this.trafficClass);
        }
    }

    public String toString() {
        return String.format("[%s@%d::keepAlive=%s, oobInline=%s, receiveBufferSize=%s, sendBufferSize=%s, reuseAddress=%s, soLinger=%s, soTimeout=%s, tcpNoDelay=%s, trafficClass=%s]", this.getClass().getName(), this.hashCode(), this.keepAlive, this.oobInline, this.receiveBufferSize, this.sendBufferSize, this.reuseAddress, this.soLinger, this.soTimeout, this.tcpNoDelay, this.trafficClass);
    }
}

