/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.config;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactBuilderFactory;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactBuilderFactory;

public class SAMLConfiguration {
    @Nullable
    private SAML1ArtifactBuilderFactory saml1ArtifactBuilderFactory;
    @Nullable
    private SAML2ArtifactBuilderFactory saml2ArtifactBuilderFactory;
    @Nonnull
    @Unmodifiable
    @NotLive
    private List<String> allowedBindingURLSchemes = CollectionSupport.listOf("http", "https");

    @Nullable
    public SAML1ArtifactBuilderFactory getSAML1ArtifactBuilderFactory() {
        return this.saml1ArtifactBuilderFactory;
    }

    public void setSAML1ArtifactBuilderFactory(@Nullable SAML1ArtifactBuilderFactory factory) {
        this.saml1ArtifactBuilderFactory = factory;
    }

    @Nullable
    public SAML2ArtifactBuilderFactory getSAML2ArtifactBuilderFactory() {
        return this.saml2ArtifactBuilderFactory;
    }

    public void setSAML2ArtifactBuilderFactory(@Nullable SAML2ArtifactBuilderFactory factory) {
        this.saml2ArtifactBuilderFactory = factory;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getAllowedBindingURLSchemes() {
        return this.allowedBindingURLSchemes;
    }

    public void setAllowedBindingURLSchemes(@Nullable List<String> schemes) {
        this.allowedBindingURLSchemes = schemes == null || schemes.isEmpty() ? CollectionSupport.emptyList() : StringSupport.normalizeStringCollection(schemes).stream().filter(Objects::nonNull).map(String::toLowerCase).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList())).get();
    }
}

