/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class TxnOffsetCommitResponse
extends AbstractResponse {
    private static final String TOPIC_PARTITIONS_KEY_NAME = "topics";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private final Map<TopicPartition, Errors> errors;
    private final int throttleTimeMs;

    public TxnOffsetCommitResponse(int throttleTimeMs, Map<TopicPartition, Errors> errors) {
        this.throttleTimeMs = throttleTimeMs;
        this.errors = errors;
    }

    public TxnOffsetCommitResponse(Struct struct) {
        Object[] topicPartitionsArray;
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        for (Object topicPartitionObj : topicPartitionsArray = struct.getArray(TOPIC_PARTITIONS_KEY_NAME)) {
            Struct topicPartitionStruct = (Struct)topicPartitionObj;
            String topic = topicPartitionStruct.getString(TOPIC_KEY_NAME);
            for (Object partitionObj : topicPartitionStruct.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionStruct = (Struct)partitionObj;
                Integer partition = partitionStruct.getInt(PARTITION_KEY_NAME);
                Errors error = Errors.forCode(partitionStruct.getShort(ERROR_CODE_KEY_NAME));
                errors.put(new TopicPartition(topic, partition), error);
            }
        }
        this.errors = errors;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.TXN_OFFSET_COMMIT.responseSchema(version));
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Map<String, Map<Integer, Errors>> mappedPartitions = CollectionUtils.groupDataByTopic(this.errors);
        Object[] partitionsArray = new Object[mappedPartitions.size()];
        int i = 0;
        for (Map.Entry<String, Map<Integer, Errors>> topicAndPartitions : mappedPartitions.entrySet()) {
            Struct topicPartitionsStruct = struct.instance(TOPIC_PARTITIONS_KEY_NAME);
            topicPartitionsStruct.set(TOPIC_KEY_NAME, (Object)topicAndPartitions.getKey());
            Map<Integer, Errors> partitionAndErrors = topicAndPartitions.getValue();
            Object[] partitionAndErrorsArray = new Object[partitionAndErrors.size()];
            int j = 0;
            for (Map.Entry<Integer, Errors> partitionAndError : partitionAndErrors.entrySet()) {
                Struct partitionAndErrorStruct = topicPartitionsStruct.instance(PARTITIONS_KEY_NAME);
                partitionAndErrorStruct.set(PARTITION_KEY_NAME, (Object)partitionAndError.getKey());
                partitionAndErrorStruct.set(ERROR_CODE_KEY_NAME, (Object)partitionAndError.getValue().code());
                partitionAndErrorsArray[j++] = partitionAndErrorStruct;
            }
            topicPartitionsStruct.set(PARTITIONS_KEY_NAME, (Object)partitionAndErrorsArray);
            partitionsArray[i++] = topicPartitionsStruct;
        }
        struct.set(TOPIC_PARTITIONS_KEY_NAME, (Object)partitionsArray);
        return struct;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<TopicPartition, Errors> errors() {
        return this.errors;
    }

    public static TxnOffsetCommitResponse parse(ByteBuffer buffer, short version) {
        return new TxnOffsetCommitResponse(ApiKeys.TXN_OFFSET_COMMIT.parseResponse(version, buffer));
    }

    public String toString() {
        return "TxnOffsetCommitResponse(errors=" + this.errors + ", throttleTimeMs=" + this.throttleTimeMs + ')';
    }
}

