/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.scope;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Scope;
import org.apache.unomi.api.services.SchedulerService;
import org.apache.unomi.api.services.ScopeService;
import org.apache.unomi.persistence.spi.PersistenceService;

public class ScopeServiceImpl
implements ScopeService {
    private PersistenceService persistenceService;
    private SchedulerService schedulerService;
    private Integer scopesRefreshInterval = 1000;
    private ConcurrentMap<String, Scope> scopes = new ConcurrentHashMap<String, Scope>();
    private ScheduledFuture<?> scheduledFuture;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setScopesRefreshInterval(Integer scopesRefreshInterval) {
        this.scopesRefreshInterval = scopesRefreshInterval;
    }

    public void postConstruct() {
        this.initializeTimers();
    }

    public void preDestroy() {
        this.scheduledFuture.cancel(true);
    }

    public List<Scope> getScopes() {
        return new ArrayList<Scope>(this.scopes.values());
    }

    public void save(Scope scope) {
        this.persistenceService.save((Item)scope);
    }

    public boolean delete(String id) {
        return this.persistenceService.remove(id, Scope.class);
    }

    public Scope getScope(String id) {
        return (Scope)this.scopes.get(id);
    }

    private void initializeTimers() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                ScopeServiceImpl.this.refreshScopes();
            }
        };
        this.scheduledFuture = this.schedulerService.getScheduleExecutorService().scheduleWithFixedDelay(task, 0L, this.scopesRefreshInterval.intValue(), TimeUnit.MILLISECONDS);
    }

    private void refreshScopes() {
        this.scopes = this.persistenceService.getAllItems(Scope.class).stream().collect(Collectors.toConcurrentMap(Item::getItemId, scope -> scope));
    }
}

