/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.io.Closeable;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.CamelContextTrackerRegistry;

public class CamelContextTracker
implements Closeable {
    private final Filter filter;

    public CamelContextTracker() {
        this.filter = new Filter(){

            @Override
            public boolean accept(CamelContext camelContext) {
                return !camelContext.getClass().getName().contains("Proxy");
            }
        };
    }

    public CamelContextTracker(Filter filter) {
        this.filter = filter;
    }

    public boolean accept(CamelContext camelContext) {
        return this.filter == null || this.filter.accept(camelContext);
    }

    public void contextCreated(CamelContext camelContext) {
    }

    public final void open() {
        CamelContextTrackerRegistry.INSTANCE.addTracker(this);
    }

    @Override
    public final void close() {
        CamelContextTrackerRegistry.INSTANCE.removeTracker(this);
    }

    public static interface Filter {
        public boolean accept(CamelContext var1);
    }
}

