/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger.ui;

import java.io.IOException;
import java.net.URI;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.swagger.ui.SwaggerUiResourceLocator;

@PreMatching
@Priority(value=5000)
class SwaggerUiResourceFilter
implements ContainerRequestFilter {
    private static final Pattern PATTERN = Pattern.compile(".*[.]js|.*[.]gz|.*[.]map|oauth2*[.]html|.*[.]png|.*[.]css|.*[.]ico|/css/.*|/images/.*|/lib/.*|/fonts/.*");
    private final SwaggerUiResourceLocator locator;

    SwaggerUiResourceFilter(SwaggerUiResourceLocator locator) {
        this.locator = locator;
    }

    public void filter(ContainerRequestContext rc) throws IOException {
        if ("GET".equals(rc.getRequest().getMethod())) {
            UriInfo ui = rc.getUriInfo();
            String path = "/" + ui.getPath();
            if (PATTERN.matcher(path).matches() && this.locator.exists(path)) {
                rc.setRequestUri(URI.create("api-docs" + path));
            }
        }
    }
}

