/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.providers;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

@ManagedObject(value="Abstract Provider for loading webapps")
public abstract class ScanningAppProvider
extends AbstractLifeCycle
implements AppProvider {
    private static final Logger LOG = Log.getLogger(ScanningAppProvider.class);
    private final Map<String, App> _appMap = new HashMap<String, App>();
    private DeploymentManager _deploymentManager;
    protected FilenameFilter _filenameFilter;
    private final List<Resource> _monitored = new CopyOnWriteArrayList<Resource>();
    private boolean _recursive = false;
    private int _scanInterval = 10;
    private Scanner _scanner;
    private final Scanner.DiscreteListener _scannerListener = new Scanner.DiscreteListener(){

        public void fileAdded(String filename) throws Exception {
            ScanningAppProvider.this.fileAdded(filename);
        }

        public void fileChanged(String filename) throws Exception {
            ScanningAppProvider.this.fileChanged(filename);
        }

        public void fileRemoved(String filename) throws Exception {
            ScanningAppProvider.this.fileRemoved(filename);
        }
    };

    protected ScanningAppProvider() {
    }

    protected ScanningAppProvider(FilenameFilter filter) {
        this._filenameFilter = filter;
    }

    protected void setFilenameFilter(FilenameFilter filter) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this._filenameFilter = filter;
    }

    protected Map<String, App> getDeployedApps() {
        return this._appMap;
    }

    protected App createApp(String filename) {
        return new App(this._deploymentManager, this, filename);
    }

    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getClass().getSimpleName() + ".doStart()", new Object[0]);
        }
        if (this._monitored.size() == 0) {
            throw new IllegalStateException("No configuration dir specified");
        }
        LOG.info("Deployment monitor " + this._monitored + " at interval " + this._scanInterval, new Object[0]);
        ArrayList<File> files = new ArrayList<File>();
        for (Resource resource : this._monitored) {
            if (resource.exists() && resource.getFile().canRead()) {
                files.add(resource.getFile());
                continue;
            }
            LOG.warn("Does not exist: " + resource, new Object[0]);
        }
        this._scanner = new Scanner();
        this._scanner.setScanDirs(files);
        this._scanner.setScanInterval(this._scanInterval);
        this._scanner.setRecursive(this._recursive);
        this._scanner.setFilenameFilter(this._filenameFilter);
        this._scanner.setReportDirs(true);
        this._scanner.setScanDepth(1);
        this._scanner.addListener((Scanner.Listener)this._scannerListener);
        this._scanner.start();
    }

    protected void doStop() throws Exception {
        if (this._scanner != null) {
            this._scanner.stop();
            this._scanner.removeListener((Scanner.Listener)this._scannerListener);
            this._scanner = null;
        }
    }

    protected boolean exists(String path) {
        return this._scanner.exists(path);
    }

    protected void fileAdded(String filename) throws Exception {
        App app;
        if (LOG.isDebugEnabled()) {
            LOG.debug("added {}", new Object[]{filename});
        }
        if ((app = this.createApp(filename)) != null) {
            this._appMap.put(filename, app);
            this._deploymentManager.addApp(app);
        }
    }

    protected void fileChanged(String filename) throws Exception {
        App app;
        if (LOG.isDebugEnabled()) {
            LOG.debug("changed {}", new Object[]{filename});
        }
        if ((app = this._appMap.remove(filename)) != null) {
            this._deploymentManager.removeApp(app);
        }
        if ((app = this.createApp(filename)) != null) {
            this._appMap.put(filename, app);
            this._deploymentManager.addApp(app);
        }
    }

    protected void fileRemoved(String filename) throws Exception {
        App app;
        if (LOG.isDebugEnabled()) {
            LOG.debug("removed {}", new Object[]{filename});
        }
        if ((app = this._appMap.remove(filename)) != null) {
            this._deploymentManager.removeApp(app);
        }
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public Resource getMonitoredDirResource() {
        if (this._monitored.size() == 0) {
            return null;
        }
        if (this._monitored.size() > 1) {
            throw new IllegalStateException();
        }
        return this._monitored.get(0);
    }

    public String getMonitoredDirName() {
        Resource resource = this.getMonitoredDirResource();
        return resource == null ? null : resource.toString();
    }

    @ManagedAttribute(value="scanning interval to detect changes which need reloaded")
    public int getScanInterval() {
        return this._scanInterval;
    }

    @ManagedAttribute(value="recursive scanning supported")
    public boolean isRecursive() {
        return this._recursive;
    }

    @Override
    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this._deploymentManager = deploymentManager;
    }

    public void setMonitoredResources(List<Resource> resources) {
        this._monitored.clear();
        this._monitored.addAll(resources);
    }

    public List<Resource> getMonitoredResources() {
        return Collections.unmodifiableList(this._monitored);
    }

    public void setMonitoredDirResource(Resource resource) {
        this.setMonitoredResources(Collections.singletonList(resource));
    }

    public void addScannerListener(Scanner.Listener listener) {
        this._scanner.addListener(listener);
    }

    public void setMonitoredDirName(String dir) {
        this.setMonitoredDirectories(Collections.singletonList(dir));
    }

    public void setMonitoredDirectories(Collection<String> directories) {
        try {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (String dir : directories) {
                resources.add(Resource.newResource((String)dir));
            }
            this.setMonitoredResources(resources);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void setRecursive(boolean recursive) {
        this._recursive = recursive;
    }

    public void setScanInterval(int scanInterval) {
        this._scanInterval = scanInterval;
    }

    @ManagedOperation(value="Scan the monitored directories", impact="ACTION")
    public void scan() {
        LOG.info("Performing scan of monitored directories: {}", new Object[]{this.getMonitoredResources().stream().map(r -> r.getURI().toASCIIString()).collect(Collectors.joining(", ", "[", "]"))});
        this._scanner.scan();
    }
}

