/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.exceptions;

import aQute.lib.exceptions.Exceptions;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;

@FunctionalInterface
public interface BiPredicateWithException<T, U> {
    public boolean test(T var1, U var2) throws Exception;

    default public BiPredicate<T, U> orElseThrow() {
        return (t, u) -> {
            try {
                return this.test(t, u);
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        };
    }

    default public BiPredicate<T, U> orElse(boolean orElse) {
        return (t, u) -> {
            try {
                return this.test(t, u);
            }
            catch (Exception e) {
                return orElse;
            }
        };
    }

    default public BiPredicate<T, U> orElseGet(BooleanSupplier orElseGet) {
        Objects.requireNonNull(orElseGet);
        return (t, u) -> {
            try {
                return this.test(t, u);
            }
            catch (Exception e) {
                return orElseGet.getAsBoolean();
            }
        };
    }

    public static <T, U> BiPredicate<T, U> asBiPredicate(BiPredicateWithException<T, U> unchecked) {
        return unchecked.orElseThrow();
    }

    public static <T, U> BiPredicate<T, U> asBiPredicateOrElse(BiPredicateWithException<T, U> unchecked, boolean orElse) {
        return unchecked.orElse(orElse);
    }

    public static <T, U> BiPredicate<T, U> asBiPredicateOrElseGet(BiPredicateWithException<T, U> unchecked, BooleanSupplier orElseGet) {
        return unchecked.orElseGet(orElseGet);
    }
}

