/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.ha;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.ha.ClusteredRouteFilter;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.ObjectHelper;

public final class ClusteredRouteFilters {
    private ClusteredRouteFilters() {
    }

    public static final class BlackList
    implements ClusteredRouteFilter {
        private final Set<String> names;

        public BlackList(String name) {
            this(Collections.singletonList(name));
        }

        public BlackList(Collection<String> names) {
            this.names = new HashSet<String>(names);
        }

        @Override
        public boolean test(CamelContext camelContext, String routeId, RouteDefinition route) {
            return !this.names.contains(routeId);
        }
    }

    public static final class IsAutoStartup
    implements ClusteredRouteFilter {
        @Override
        public boolean test(CamelContext camelContext, String routeId, RouteDefinition route) {
            try {
                return route.isAutoStartup(camelContext);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
    }
}

