/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.rollup;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.rollup.RollableIndexCaps;
import org.elasticsearch.common.xcontent.XContentParser;

public class GetRollupIndexCapsResponse {
    private final Map<String, RollableIndexCaps> jobs;

    public GetRollupIndexCapsResponse(Map<String, RollableIndexCaps> jobs) {
        this.jobs = Collections.unmodifiableMap(Objects.requireNonNull(jobs));
    }

    public Map<String, RollableIndexCaps> getJobs() {
        return this.jobs;
    }

    public static GetRollupIndexCapsResponse fromXContent(XContentParser parser) throws IOException {
        HashMap<String, RollableIndexCaps> jobs = new HashMap<String, RollableIndexCaps>();
        XContentParser.Token token = parser.nextToken();
        if (token.equals((Object)XContentParser.Token.START_OBJECT)) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (!token.equals((Object)XContentParser.Token.FIELD_NAME)) continue;
                String pattern = parser.currentName();
                RollableIndexCaps cap = RollableIndexCaps.PARSER.apply(pattern).apply(parser, null);
                jobs.put(pattern, cap);
            }
        }
        return new GetRollupIndexCapsResponse(jobs);
    }

    public int hashCode() {
        return Objects.hash(this.jobs);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetRollupIndexCapsResponse other = (GetRollupIndexCapsResponse)obj;
        return Objects.equals(this.jobs, other.jobs);
    }
}

