/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.spi.support.ConfigurationNotifier;
import org.ops4j.pax.logging.spi.support.EventAdminConfigurationNotifier;
import org.ops4j.pax.logging.spi.support.EventAdminTracker;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.ops4j.pax.logging.spi.support.LogReaderServiceImpl;
import org.ops4j.pax.logging.spi.support.OsgiUtil;
import org.ops4j.pax.logging.spi.support.RegisteredService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;

public class BackendSupport {
    private BackendSupport() {
    }

    public static int paxLoggingServiceRanking(BundleContext context) {
        int ranking = 1;
        String rankingProperty = context.getProperty("org.ops4j.pax.logging.ranking");
        if (rankingProperty != null) {
            ranking = Integer.parseInt(rankingProperty);
        }
        return ranking;
    }

    public static RegisteredService<LogReaderService, LogReaderServiceImpl> createAndRegisterLogReaderService(BundleContext context) {
        LogReaderServiceImpl logReader = new LogReaderServiceImpl(100, FallbackLogFactory.createFallbackLog(context.getBundle(), "pax-logging"));
        Hashtable<String, Integer> serviceProperties = new Hashtable<String, Integer>();
        ((Dictionary)serviceProperties).put("service.ranking", BackendSupport.paxLoggingServiceRanking(context));
        ServiceRegistration registration = context.registerService(LogReaderService.class, (Object)logReader, serviceProperties);
        return new RegisteredService<LogReaderService, LogReaderServiceImpl>(logReader, registration);
    }

    public static RegisteredService<EventAdminPoster, EventAdminPoster> eventAdminSupport(BundleContext context) {
        EventAdminPoster eventAdmin;
        try {
            eventAdmin = new EventAdminTracker(context);
        }
        catch (NoClassDefFoundError e) {
            eventAdmin = new EventAdminPoster(){

                public void postEvent(Bundle bundle, int level, LogEntry entry, String message, Throwable exception, ServiceReference sr, Map context) {
                }

                public void destroy() {
                }

                public void close() throws Exception {
                }
            };
        }
        return new RegisteredService<EventAdminPoster, EventAdminPoster>(eventAdmin, null);
    }

    public static RegisteredService<ConfigurationNotifier, ConfigurationNotifier> eventAdminConfigurationNotifier(BundleContext context) {
        ConfigurationNotifier notifier;
        try {
            notifier = new EventAdminConfigurationNotifier(context);
        }
        catch (NoClassDefFoundError e) {
            notifier = new ConfigurationNotifier(){

                @Override
                public void configurationDone() {
                }

                @Override
                public void configurationError(Throwable t) {
                }

                @Override
                public void close() throws Exception {
                }
            };
        }
        return new RegisteredService<ConfigurationNotifier, ConfigurationNotifier>(notifier, null);
    }

    public static String defaultLogLevel(BundleContext bundleContext) {
        String level = OsgiUtil.systemOrContextProperty(bundleContext, "org.ops4j.pax.logging.DefaultServiceLog.level");
        if (level == null || "".equals(level.trim())) {
            return "DEBUG";
        }
        return level;
    }

    public static int convertLogServiceLevel(String levelName) {
        if ("DEBUG".equalsIgnoreCase(levelName)) {
            return 4;
        }
        if ("INFO".equalsIgnoreCase(levelName)) {
            return 3;
        }
        if ("ERROR".equalsIgnoreCase(levelName)) {
            return 1;
        }
        if ("WARN".equalsIgnoreCase(levelName)) {
            return 2;
        }
        if ("OFF".equalsIgnoreCase(levelName) || "NONE".equalsIgnoreCase(levelName)) {
            return 0;
        }
        return 4;
    }

    public static String convertLogServiceLevel(int level) {
        switch (level) {
            case 0: {
                return "OFF";
            }
            case 3: {
                return "INFO";
            }
            case 2: {
                return "WARN";
            }
            case 1: {
                return "ERROR";
            }
        }
        return "DEBUG";
    }

    public static Level toJULLevel(String levelName) {
        if (levelName == null || levelName.equalsIgnoreCase("OFF")) {
            return Level.OFF;
        }
        if (levelName.equalsIgnoreCase("FATAL") || levelName.equalsIgnoreCase("SEVERE") || levelName.equalsIgnoreCase("ERROR")) {
            return Level.SEVERE;
        }
        if (levelName.equalsIgnoreCase("WARN") || levelName.equalsIgnoreCase("WARNING")) {
            return Level.WARNING;
        }
        if (levelName.equalsIgnoreCase("INFO") || levelName.equalsIgnoreCase("CONFIG") || levelName.equalsIgnoreCase("CONF")) {
            return Level.INFO;
        }
        if (levelName.equalsIgnoreCase("DEBUG") || levelName.equalsIgnoreCase("FINE")) {
            return Level.FINE;
        }
        if (levelName.equalsIgnoreCase("TRACE") || levelName.equalsIgnoreCase("FINER")) {
            return Level.FINER;
        }
        if (levelName.equalsIgnoreCase("FINEST")) {
            return Level.FINEST;
        }
        if (levelName.equalsIgnoreCase("ALL")) {
            return Level.ALL;
        }
        return Level.INFO;
    }

    public static String category(Bundle bundle) {
        String category = "undefined";
        if (bundle != null && (category = bundle.getSymbolicName()) == null) {
            category = "bundle@" + bundle.getBundleId();
        }
        return category;
    }

    public static boolean isConfigurationAdminAvailable() {
        try {
            BackendSupport.class.getClassLoader().loadClass("org.osgi.service.cm.ConfigurationAdmin");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String externalFile(BundleContext bundleContext, String defaultFile) {
        String property = OsgiUtil.systemOrContextProperty(bundleContext, "org.ops4j.pax.logging.property.file");
        return property == null ? defaultFile : property;
    }
}

