/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.parser.antlr4.internal.atnmanager;

import groovyjarjarantlr4.v4.runtime.atn.ATN;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AtnManager {
    private static final ReentrantReadWriteLock RRWL = new ReentrantReadWriteLock(true);
    private static final ReentrantReadWriteLock.WriteLock WRITE_LOCK = RRWL.writeLock();
    public static final ReentrantReadWriteLock.ReadLock READ_LOCK = RRWL.readLock();
    private static final String DFA_CACHE_THRESHOLD_OPT = "groovy.antlr4.cache.threshold";
    private static final int DEFAULT_DFA_CACHE_THRESHOLD = 64;
    private static final int MIN_DFA_CACHE_THRESHOLD = 2;
    private static final int DFA_CACHE_THRESHOLD;

    public abstract ATN getATN();

    protected abstract boolean shouldClearDfaCache();

    static {
        int t = 64;
        try {
            t = Integer.parseInt(System.getProperty(DFA_CACHE_THRESHOLD_OPT));
            t = t < 2 ? 2 : t;
        }
        catch (Exception exception) {
            // empty catch block
        }
        DFA_CACHE_THRESHOLD = t;
    }

    protected class AtnWrapper {
        private final ATN atn;
        private final AtomicLong counter = new AtomicLong(0L);

        public AtnWrapper(ATN atn) {
            this.atn = atn;
        }

        public ATN checkAndClear() {
            if (!AtnManager.this.shouldClearDfaCache()) {
                return this.atn;
            }
            if (0L != this.counter.incrementAndGet() % (long)DFA_CACHE_THRESHOLD) {
                return this.atn;
            }
            WRITE_LOCK.lock();
            try {
                this.atn.clearDFA();
            }
            finally {
                WRITE_LOCK.unlock();
            }
            return this.atn;
        }
    }
}

