/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedResequencerMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Resequencer;
import org.apache.camel.processor.StreamResequencer;

@ManagedResource(description="Managed Resequencer")
public class ManagedResequencer
extends ManagedProcessor
implements ManagedResequencerMBean {
    private final Resequencer processor;
    private final StreamResequencer streamProcessor;
    private final String expression;

    public ManagedResequencer(CamelContext context, Resequencer processor, ProcessorDefinition<?> definition) {
        super(context, processor, definition);
        this.processor = processor;
        this.streamProcessor = null;
        this.expression = processor.getExpression().toString();
    }

    public ManagedResequencer(CamelContext context, StreamResequencer processor, ProcessorDefinition<?> definition) {
        super(context, processor, definition);
        this.processor = null;
        this.streamProcessor = processor;
        this.expression = this.streamProcessor.getExpression().toString();
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public Integer getBatchSize() {
        if (this.processor != null) {
            return this.processor.getBatchSize();
        }
        return null;
    }

    @Override
    public Long getTimeout() {
        if (this.processor != null) {
            return this.processor.getBatchTimeout();
        }
        return this.streamProcessor.getTimeout();
    }

    @Override
    public Boolean isAllowDuplicates() {
        if (this.processor != null) {
            return this.processor.isAllowDuplicates();
        }
        return null;
    }

    @Override
    public Boolean isReverse() {
        if (this.processor != null) {
            return this.processor.isReverse();
        }
        return null;
    }

    @Override
    public Boolean isIgnoreInvalidExchanges() {
        if (this.processor != null) {
            return this.processor.isIgnoreInvalidExchanges();
        }
        return this.streamProcessor.isIgnoreInvalidExchanges();
    }

    @Override
    public Integer getCapacity() {
        if (this.processor != null) {
            return null;
        }
        return this.streamProcessor.getCapacity();
    }

    @Override
    public Boolean isRejectOld() {
        if (this.processor != null) {
            return null;
        }
        return this.streamProcessor.isRejectOld();
    }
}

