/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.rest.AbstractRestChannel;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class DefaultRestChannel
extends AbstractRestChannel
implements RestChannel {
    static final String CLOSE = "close";
    static final String CONNECTION = "connection";
    static final String KEEP_ALIVE = "keep-alive";
    static final String CONTENT_TYPE = "content-type";
    static final String CONTENT_LENGTH = "content-length";
    static final String SET_COOKIE = "set-cookie";
    private final HttpRequest httpRequest;
    private final BigArrays bigArrays;
    private final HttpHandlingSettings settings;
    private final ThreadContext threadContext;
    private final HttpChannel httpChannel;

    DefaultRestChannel(HttpChannel httpChannel, HttpRequest httpRequest, RestRequest request, BigArrays bigArrays, HttpHandlingSettings settings, ThreadContext threadContext) {
        super(request, settings.getDetailedErrorsEnabled());
        this.httpChannel = httpChannel;
        this.httpRequest = httpRequest;
        this.bigArrays = bigArrays;
        this.settings = settings;
        this.threadContext = threadContext;
    }

    @Override
    protected BytesStreamOutput newBytesOutput() {
        return new ReleasableBytesStreamOutput(this.bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(RestResponse restResponse) {
        ArrayList<Releasable> toClose = new ArrayList<Releasable>(3);
        if (this.isCloseConnection()) {
            toClose.add(() -> CloseableChannel.closeChannel(this.httpChannel));
        }
        boolean success = false;
        try {
            BytesReference finalContent;
            block11: {
                BytesReference content = restResponse.content();
                if (content instanceof Releasable) {
                    toClose.add((Releasable)((Object)content));
                }
                finalContent = content;
                try {
                    if (this.request.method() == RestRequest.Method.HEAD) {
                        finalContent = BytesArray.EMPTY;
                    }
                }
                catch (IllegalArgumentException ignored) {
                    if ($assertionsDisabled || restResponse.status() == RestStatus.METHOD_NOT_ALLOWED) break block11;
                    throw new AssertionError((Object)"request HTTP method is unsupported but HTTP status is not METHOD_NOT_ALLOWED(405)");
                }
            }
            HttpResponse httpResponse = this.httpRequest.createResponse(restResponse.status(), finalContent);
            String opaque = this.request.header("X-Opaque-Id");
            if (opaque != null) {
                this.setHeaderField(httpResponse, "X-Opaque-Id", opaque);
            }
            this.addCustomHeaders(httpResponse, restResponse.getHeaders());
            this.addCustomHeaders(httpResponse, this.threadContext.getResponseHeaders());
            this.setHeaderField(httpResponse, CONTENT_TYPE, restResponse.contentType(), false);
            this.setHeaderField(httpResponse, CONTENT_LENGTH, String.valueOf(restResponse.content().length()), false);
            this.addCookies(httpResponse);
            BytesStreamOutput bytesStreamOutput = this.bytesOutputOrNull();
            if (bytesStreamOutput instanceof ReleasableBytesStreamOutput) {
                toClose.add((Releasable)((Object)bytesStreamOutput));
            }
            ActionListener<Void> listener = ActionListener.wrap(() -> Releasables.close(toClose));
            this.httpChannel.sendResponse(httpResponse, listener);
            success = true;
        }
        finally {
            if (!success) {
                Releasables.close(toClose);
            }
        }
    }

    private void setHeaderField(HttpResponse response, String headerField, String value) {
        this.setHeaderField(response, headerField, value, true);
    }

    private void setHeaderField(HttpResponse response, String headerField, String value, boolean override) {
        if (override || !response.containsHeader(headerField)) {
            response.addHeader(headerField, value);
        }
    }

    private void addCustomHeaders(HttpResponse response, Map<String, List<String>> customHeaders) {
        if (customHeaders != null) {
            for (Map.Entry<String, List<String>> headerEntry : customHeaders.entrySet()) {
                for (String headerValue : headerEntry.getValue()) {
                    this.setHeaderField(response, headerEntry.getKey(), headerValue);
                }
            }
        }
    }

    private void addCookies(HttpResponse response) {
        List<String> cookies;
        if (this.settings.isResetCookies() && !(cookies = this.request.getHttpRequest().strictCookies()).isEmpty()) {
            for (String cookie : cookies) {
                response.addHeader(SET_COOKIE, cookie);
            }
        }
    }

    private boolean isCloseConnection() {
        try {
            boolean http10 = this.request.getHttpRequest().protocolVersion() == HttpRequest.HttpVersion.HTTP_1_0;
            return CLOSE.equalsIgnoreCase(this.request.header(CONNECTION)) || http10 && !KEEP_ALIVE.equalsIgnoreCase(this.request.header(CONNECTION));
        }
        catch (Exception e) {
            return true;
        }
    }
}

