/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core.internal.net;

import java.lang.reflect.Field;
import java.net.SocketOption;

public class NetUtils {
    public static SocketOption<Integer> getTcpKeepIdleSocketOptionOrNull() {
        return NetUtils.getExtendedSocketOptionOrNull("TCP_KEEPIDLE");
    }

    public static SocketOption<Integer> getTcpKeepIntervalSocketOptionOrNull() {
        return NetUtils.getExtendedSocketOptionOrNull("TCP_KEEPINTERVAL");
    }

    public static SocketOption<Integer> getTcpKeepCountSocketOptionOrNull() {
        return NetUtils.getExtendedSocketOptionOrNull("TCP_KEEPCOUNT");
    }

    private static <T> SocketOption<T> getExtendedSocketOptionOrNull(String fieldName) {
        try {
            Class<?> extendedSocketOptionsClass = Class.forName("jdk.net.ExtendedSocketOptions");
            Field field = extendedSocketOptionsClass.getField(fieldName);
            return (SocketOption)field.get(null);
        }
        catch (Exception t) {
            return null;
        }
    }
}

