/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.backoff;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.camel.util.backoff.BackOff;
import org.apache.camel.util.backoff.BackOffTimer;
import org.apache.camel.util.function.ThrowingFunction;

final class BackOffTimerTask
implements BackOffTimer.Task,
Runnable {
    private final BackOff backOff;
    private final ScheduledExecutorService scheduler;
    private final ThrowingFunction<BackOffTimer.Task, Boolean, Exception> function;
    private final AtomicReference<ScheduledFuture<?>> futureRef;
    private final List<BiConsumer<BackOffTimer.Task, Throwable>> consumers;
    private BackOffTimer.Task.Status status;
    private long currentAttempts;
    private long currentDelay;
    private long currentElapsedTime;
    private long lastAttemptTime;
    private long nextAttemptTime;

    BackOffTimerTask(BackOff backOff, ScheduledExecutorService scheduler, ThrowingFunction<BackOffTimer.Task, Boolean, Exception> function) {
        this.backOff = backOff;
        this.scheduler = scheduler;
        this.status = BackOffTimer.Task.Status.Active;
        this.currentAttempts = 0L;
        this.currentDelay = backOff.getDelay().toMillis();
        this.currentElapsedTime = 0L;
        this.lastAttemptTime = -1L;
        this.nextAttemptTime = -1L;
        this.function = function;
        this.consumers = new ArrayList<BiConsumer<BackOffTimer.Task, Throwable>>();
        this.futureRef = new AtomicReference();
    }

    @Override
    public BackOff getBackOff() {
        return this.backOff;
    }

    @Override
    public BackOffTimer.Task.Status getStatus() {
        return this.status;
    }

    @Override
    public long getCurrentAttempts() {
        return this.currentAttempts;
    }

    @Override
    public long getCurrentDelay() {
        return this.currentDelay;
    }

    @Override
    public long getCurrentElapsedTime() {
        return this.currentElapsedTime;
    }

    @Override
    public long getLastAttemptTime() {
        return this.lastAttemptTime;
    }

    @Override
    public long getNextAttemptTime() {
        return this.nextAttemptTime;
    }

    @Override
    public void reset() {
        this.currentAttempts = 0L;
        this.currentDelay = 0L;
        this.currentElapsedTime = 0L;
        this.lastAttemptTime = -1L;
        this.nextAttemptTime = -1L;
        this.status = BackOffTimer.Task.Status.Active;
    }

    @Override
    public void cancel() {
        this.stop();
        ScheduledFuture<?> future = this.futureRef.get();
        if (future != null) {
            future.cancel(true);
        }
        this.complete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void whenComplete(BiConsumer<BackOffTimer.Task, Throwable> whenCompleted) {
        List<BiConsumer<BackOffTimer.Task, Throwable>> list = this.consumers;
        synchronized (list) {
            this.consumers.add(whenCompleted);
        }
    }

    @Override
    public void run() {
        if (this.status == BackOffTimer.Task.Status.Active) {
            try {
                this.lastAttemptTime = System.currentTimeMillis();
                if (this.function.apply(this).booleanValue()) {
                    long delay = this.next();
                    if (this.status != BackOffTimer.Task.Status.Active) {
                        this.complete(null);
                    } else {
                        this.nextAttemptTime = this.lastAttemptTime + delay;
                        this.futureRef.lazySet(this.scheduler.schedule(this, delay, TimeUnit.MILLISECONDS));
                    }
                } else {
                    this.stop();
                    this.complete(null);
                }
            }
            catch (Exception e) {
                this.stop();
                this.complete(e);
            }
        }
    }

    void stop() {
        this.currentAttempts = 0L;
        this.currentDelay = -1L;
        this.currentElapsedTime = 0L;
        this.lastAttemptTime = -1L;
        this.nextAttemptTime = -1L;
        this.status = BackOffTimer.Task.Status.Inactive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void complete(Throwable throwable) {
        List<BiConsumer<BackOffTimer.Task, Throwable>> list = this.consumers;
        synchronized (list) {
            this.consumers.forEach(c -> c.accept(this, throwable));
        }
    }

    long next() {
        if (this.status == BackOffTimer.Task.Status.Active) {
            ++this.currentAttempts;
            if (this.currentAttempts > this.backOff.getMaxAttempts()) {
                this.currentDelay = -1L;
                this.status = BackOffTimer.Task.Status.Exhausted;
            } else if (this.currentElapsedTime > this.backOff.getMaxElapsedTime().toMillis()) {
                this.currentDelay = -1L;
                this.status = BackOffTimer.Task.Status.Exhausted;
            } else {
                if (this.currentDelay <= this.backOff.getMaxDelay().toMillis()) {
                    this.currentDelay = (long)((double)this.currentDelay * this.backOff.getMultiplier());
                }
                this.currentElapsedTime += this.currentDelay;
            }
        }
        return this.currentDelay;
    }

    public String toString() {
        return "BackOffTimerTask[status=" + (Object)((Object)this.status) + ", currentAttempts=" + this.currentAttempts + ", currentDelay=" + this.currentDelay + ", currentElapsedTime=" + this.currentElapsedTime + ", lastAttemptTime=" + this.lastAttemptTime + ", nextAttemptTime=" + this.nextAttemptTime + ']';
    }
}

